"""
This type stub file was generated by pyright.
"""

from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union
from sqlalchemy.schema import Column
from sqlalchemy.sql.base import Executable
from sqlalchemy.sql.elements import ClauseElement
from .base import AddColumn, ColumnDefault, ColumnName, ColumnNullable, ColumnType, RenameTable, _ServerDefault
from .impl import DefaultImpl
from ..util.sqla_compat import compiles
from sqlalchemy.dialects.mssql.base import MSDDLCompiler
from sqlalchemy.sql.schema import Index, Table
from sqlalchemy.sql.selectable import TableClause
from sqlalchemy.sql.type_api import TypeEngine

if TYPE_CHECKING:
    ...
class MSSQLImpl(DefaultImpl):
    __dialect__ = ...
    transactional_ddl = ...
    batch_separator = ...
    type_synonyms = ...
    identity_attrs_ignore = ...
    def __init__(self, *arg, **kw) -> None:
        ...
    
    def emit_begin(self) -> None:
        ...
    
    def emit_commit(self) -> None:
        ...
    
    def alter_column(self, table_name: str, column_name: str, nullable: Optional[bool] = ..., server_default: Optional[Union[_ServerDefault, Literal[False]]] = ..., name: Optional[str] = ..., type_: Optional[TypeEngine] = ..., schema: Optional[str] = ..., existing_type: Optional[TypeEngine] = ..., existing_server_default: Optional[_ServerDefault] = ..., existing_nullable: Optional[bool] = ..., **kw: Any) -> None:
        ...
    
    def create_index(self, index: Index, **kw: Any) -> None:
        ...
    
    def bulk_insert(self, table: Union[TableClause, Table], rows: List[dict], **kw: Any) -> None:
        ...
    
    def drop_column(self, table_name: str, column: Column[Any], schema: Optional[str] = ..., **kw) -> None:
        ...
    
    def compare_server_default(self, inspector_column, metadata_column, rendered_metadata_default, rendered_inspector_default): # -> bool:
        ...
    
    def adjust_reflected_dialect_options(self, reflected_object: Dict[str, Any], kind: str) -> Dict[str, Any]:
        ...
    


class _ExecDropConstraint(Executable, ClauseElement):
    inherit_cache = ...
    def __init__(self, tname: str, colname: Union[Column[Any], str], type_: str, schema: Optional[str]) -> None:
        ...
    


class _ExecDropFKConstraint(Executable, ClauseElement):
    inherit_cache = ...
    def __init__(self, tname: str, colname: Column[Any], schema: Optional[str]) -> None:
        ...
    


@compiles(AddColumn, "mssql")
def visit_add_column(element: AddColumn, compiler: MSDDLCompiler, **kw) -> str:
    ...

def mssql_add_column(compiler: MSDDLCompiler, column: Column[Any], **kw) -> str:
    ...

@compiles(ColumnNullable, "mssql")
def visit_column_nullable(element: ColumnNullable, compiler: MSDDLCompiler, **kw) -> str:
    ...

@compiles(ColumnDefault, "mssql")
def visit_column_default(element: ColumnDefault, compiler: MSDDLCompiler, **kw) -> str:
    ...

@compiles(ColumnName, "mssql")
def visit_rename_column(element: ColumnName, compiler: MSDDLCompiler, **kw) -> str:
    ...

@compiles(ColumnType, "mssql")
def visit_column_type(element: ColumnType, compiler: MSDDLCompiler, **kw) -> str:
    ...

@compiles(RenameTable, "mssql")
def visit_rename_table(element: RenameTable, compiler: MSDDLCompiler, **kw) -> str:
    ...

