"""
This type stub file was generated by pyright.
"""

from typing import Any

from saml2.client_base import Base

"""Contains classes and functions that a SAML2.0 Service Provider (SP) may use
to conclude its tasks.
"""
logger = ...
class Saml2Client(Base):
    """The basic pySAML2 service provider class"""
    def prepare_for_authenticate(self,
        entityid: Any=...,
        relay_state: Any=...,
        binding: Any=...,
        vorg: Any=...,
        nameid_format: Any=...,
        scoping: Any=...,
        consent: Any=...,
        extensions: Any=...,
        sign: Any=...,
        sigalg: Any=...,
        digest_alg: Any=...,
        response_binding: Any=...,
        **kwargs: Any) -> tuple[Any, dict[str, Any] | dict[str, str]]:
        """Makes all necessary preparations for an authentication request.

        :param entityid: The entity ID of the IdP to send the request to
        :param relay_state: To where the user should be returned after
            successfull log in.
        :param binding: Which binding to use for sending the request
        :param vorg: The entity_id of the virtual organization I'm a member of
        :param nameid_format:
        :param scoping: For which IdPs this query are aimed.
        :param consent: Whether the principal have given her consent
        :param extensions: Possible extensions
        :param sign: Whether the request should be signed or not.
        :param response_binding: Which binding to use for receiving the response
        :param kwargs: Extra key word arguments
        :return: session id and AuthnRequest info
        """
        ...
    
    def prepare_for_negotiated_authenticate(self, entityid=..., relay_state=..., binding=..., vorg=..., nameid_format=..., scoping=..., consent=..., extensions=..., sign=..., response_binding=..., sigalg=..., digest_alg=..., **kwargs): # -> tuple[Any, Any | Literal['urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect'], dict[str, Any] | dict[str, str]]:
        """Makes all necessary preparations for an authentication request
        that negotiates which binding to use for authentication.

        :param entityid: The entity ID of the IdP to send the request to
        :param relay_state: To where the user should be returned after
            successfull log in.
        :param binding: Which binding to use for sending the request
        :param vorg: The entity_id of the virtual organization I'm a member of
        :param nameid_format:
        :param scoping: For which IdPs this query are aimed.
        :param consent: Whether the principal have given her consent
        :param extensions: Possible extensions
        :param sign: Whether the request should be signed or not.
        :param response_binding: Which binding to use for receiving the response
        :param kwargs: Extra key word arguments
        :return: session id and AuthnRequest info
        """
        ...
    
    def global_logout(self, name_id, reason=..., expire=..., sign=..., sign_alg=..., digest_alg=...): # -> tuple[Literal[0], Literal['504 Gateway Timeout'], list[Any], list[Any]] | dict[Any, Any]:
        """More or less a layer of indirection :-/
        Bootstrapping the whole thing by finding all the IdPs that should
        be notified.

        :param name_id: The identifier of the subject that wants to be
            logged out.
        :param reason: Why the subject wants to log out
        :param expire: The latest the log out should happen.
            If this time has passed don't bother.
        :param sign: Whether the request should be signed or not.
            This also depends on what binding is used.
        :return: Depends on which binding is used:
            If the HTTP redirect binding then a HTTP redirect,
            if SOAP binding has been used the just the result of that
            conversation.
        """
        ...
    
    def do_logout(self, name_id, entity_ids, reason, expire, sign=..., expected_binding=..., sign_alg=..., digest_alg=..., **kwargs): # -> tuple[Literal[0], Literal['504 Gateway Timeout'], list[Any], list[Any]] | dict[Any, Any]:
        """

        :param name_id: Identifier of the Subject (a NameID instance)
        :param entity_ids: List of entity ids for the IdPs that have provided
            information concerning the subject
        :param reason: The reason for doing the logout
        :param expire: Try to logout before this time.
        :param sign: Whether to sign the request or not
        :param expected_binding: Specify the expected binding then not try it
            all
        :param kwargs: Extra key word arguments.
        :return:
        """
        ...
    
    def local_logout(self, name_id): # -> Literal[True]:
        """Remove the user from the cache, equals local logout

        :param name_id: The identifier of the subject
        """
        ...
    
    def is_logged_in(self, name_id): # -> bool:
        """Check if user is in the cache

        :param name_id: The identifier of the subject
        """
        ...
    
    def handle_logout_response(self, response, sign_alg=..., digest_alg=...): # -> tuple[Literal[0], Literal['200 Ok'], list[tuple[Literal['Content-type'], Literal['text/html']]], list[Any]] | tuple[Literal[0], Literal['504 Gateway Timeout'], list[Any], list[Any]] | dict[Any, Any]:
        """handles a Logout response

        :param response: A response.Response instance
        :return: 4-tuple of (session_id of the last sent logout request,
            response message, response headers and message)
        """
        ...
    
    def do_authz_decision_query(self, entity_id, action, subject_id, nameid_format, evidence=..., resource=..., sp_name_qualifier=..., name_qualifier=..., consent=..., extensions=..., sign=...): # -> Any | None:
        ...
    
    def do_assertion_id_request(self, assertion_ids, entity_id, consent=..., extensions=..., sign=...): # -> Any | None:
        ...
    
    def do_authn_query(self, entity_id, consent=..., extensions=..., sign=...): # -> Any | None:
        ...
    
    def do_attribute_query(self, entityid, subject_id, attribute=..., sp_name_qualifier=..., name_qualifier=..., nameid_format=..., real_id=..., consent=..., extensions=..., sign=..., binding=..., nsprefix=..., sign_alg=..., digest_alg=...): # -> Any | dict[str, Any] | dict[str, str] | None:
        """Does a attribute request to an attribute authority, this is
        by default done over SOAP.

        :param entityid: To whom the query should be sent
        :param subject_id: The identifier of the subject
        :param attribute: A dictionary of attributes and values that is
            asked for
        :param sp_name_qualifier: The unique identifier of the
            service provider or affiliation of providers for whom the
            identifier was generated.
        :param name_qualifier: The unique identifier of the identity
            provider that generated the identifier.
        :param nameid_format: The format of the name ID
        :param real_id: The identifier which is the key to this entity in the
            identity database
        :param binding: Which binding to use
        :param nsprefix: Namespace prefixes preferred before those automatically
            produced.
        :return: The attributes returned if BINDING_SOAP was used.
            HTTP args if BINDING_HTT_POST was used.
        """
        ...
    
    def handle_logout_request(self, request, name_id, binding, sign=..., sign_alg=..., digest_alg=..., relay_state=..., sigalg=..., signature=...): # -> dict[str, Any] | dict[str, str]:
        """
        Deal with a LogoutRequest

        :param request: The request as text string
        :param name_id: The id of the current user
        :param binding: Which binding the message came in over
        :param sign: Whether the response will be signed or not
        :param sign_alg: The signing algorithm for the response
        :param digest_alg: The digest algorithm for the the response
        :param relay_state: The relay state of the request
        :param sigalg: The SigAlg query param of the request
        :param signature: The Signature query param of the request
        :return: Keyword arguments which can be used to send the response
            what's returned follow different patterns for different bindings.
            If the binding is BINDIND_SOAP, what is returned looks like this::

                {
                    "data": <the SOAP enveloped response>
                    "url": "",
                    'headers': [('content-type', 'application/soap+xml')]
                    'method': "POST
                }
        """
        ...
    


