"""
This type stub file was generated by pyright.
"""

"""This module provides methods for symmetric cryptography.

The default symmetric cryptography method used is Fernet by the cryptography
library. Reference: https://cryptography.io/en/latest/fernet/
"""
logger = ...
class Fernet:
    """The default symmetric cryptography method."""
    @staticmethod
    def generate_key(): # -> bytes:
        """Return a key suitable for use by this method.

        :return: byte data representing the encyption/decryption key
        """
        ...
    
    def __init__(self, key=...) -> None:
        """Initialize this method by optionally providing a key.

        :param key: byte data representing the encyption/decryption key
        """
        ...
    
    def encrypt(self, plaintext, *args, **kwargs): # -> bytes:
        """Encrypt the given plaintext.

        :param plaintext: byte data representing the plaintext
        :return: byte data representing the ciphertext
        """
        ...
    
    def decrypt(self, ciphertext, *args, **kwargs): # -> bytes:
        """Decrypt the given ciphertext.

        :param ciphertext: byte data representing the ciphertext
        :return: byte data representing the plaintext
        """
        ...
    
    def build_cipher(self, *args, **kwargs): # -> None:
        ...
    


class AESCipher:
    """[deprecated] Symmetric cryptography method using AES.

    The default parameter set is AES 128bit in CBC mode.
    """
    POSTFIX_MODE = ...
    AES_BLOCK_SIZE = ...
    def __init__(self, key) -> None:
        """
        :param key: The encryption key
        :return: AESCipher instance
        """
        ...
    
    def build_cipher(self, alg=...): # -> tuple[Cipher[Any], bytes]:
        """
        :param alg: cipher algorithm
        :return: A Cipher instance
        """
        ...
    
    def encrypt(self, msg, alg=..., padding=..., b64enc=..., block_size=...): # -> bytes:
        """
        :param key: The encryption key
        :param msg: Message to be encrypted
        :param padding: Which padding that should be used
        :param b64enc: Whether the result should be base64encoded
        :param block_size: If PKCS#7 padding which block size to use
        :return: The encrypted message
        """
        ...
    
    def decrypt(self, msg, alg=..., padding=..., b64dec=...): # -> bytes:
        """
        :param key: The encryption key
        :param msg: Base64 encoded message to be decrypted
        :return: The decrypted message
        """
        ...
    


class Default(Fernet):
    """Default class is saml2.cryptography.symmetric.Fernet"""
    ...


