"""
This type stub file was generated by pyright.
"""

from typing import Any, Callable, List, TYPE_CHECKING, Tuple, Type, Union
from ..operations.ops import AddColumnOp, AlterColumnOp, CreateTableOp, MigrateOperation, MigrationScript, ModifyTableOps
from ..runtime.migration import MigrationContext
from ..script.revision import _GetRevArg

if TYPE_CHECKING:
    ...
ProcessRevisionDirectiveFn = Callable[["MigrationContext", "_GetRevArg", List["MigrationScript"]], None]
class Rewriter:
    """A helper object that allows easy 'rewriting' of ops streams.

    The :class:`.Rewriter` object is intended to be passed along
    to the
    :paramref:`.EnvironmentContext.configure.process_revision_directives`
    parameter in an ``env.py`` script.    Once constructed, any number
    of "rewrites" functions can be associated with it, which will be given
    the opportunity to modify the structure without having to have explicit
    knowledge of the overall structure.

    The function is passed the :class:`.MigrationContext` object and
    ``revision`` tuple that are passed to the  :paramref:`.Environment
    Context.configure.process_revision_directives` function normally,
    and the third argument is an individual directive of the type
    noted in the decorator.  The function has the choice of  returning
    a single op directive, which normally can be the directive that
    was actually passed, or a new directive to replace it, or a list
    of zero or more directives to replace it.

    .. seealso::

        :ref:`autogen_rewriter` - usage example

    """
    _traverse = ...
    _chained: Tuple[Union[ProcessRevisionDirectiveFn, Rewriter], ...] = ...
    def __init__(self) -> None:
        ...
    
    def chain(self, other: Union[ProcessRevisionDirectiveFn, Rewriter,]) -> Rewriter:
        """Produce a "chain" of this :class:`.Rewriter` to another.

        This allows two or more rewriters to operate serially on a stream,
        e.g.::

            writer1 = autogenerate.Rewriter()
            writer2 = autogenerate.Rewriter()


            @writer1.rewrites(ops.AddColumnOp)
            def add_column_nullable(context, revision, op):
                op.column.nullable = True
                return op


            @writer2.rewrites(ops.AddColumnOp)
            def add_column_idx(context, revision, op):
                idx_op = ops.CreateIndexOp(
                    "ixc", op.table_name, [op.column.name]
                )
                return [op, idx_op]

            writer = writer1.chain(writer2)

        :param other: a :class:`.Rewriter` instance
        :return: a new :class:`.Rewriter` that will run the operations
         of this writer, then the "other" writer, in succession.

        """
        ...
    
    def rewrites(self, operator: Union[Type[AddColumnOp], Type[MigrateOperation], Type[AlterColumnOp], Type[CreateTableOp], Type[ModifyTableOps],]) -> Callable[..., Any]:
        """Register a function as rewriter for a given type.

        The function should receive three arguments, which are
        the :class:`.MigrationContext`, a ``revision`` tuple, and
        an op directive of the type indicated.  E.g.::

            @writer1.rewrites(ops.AddColumnOp)
            def add_column_nullable(context, revision, op):
                op.column.nullable = True
                return op

        """
        ...
    
    def __call__(self, context: MigrationContext, revision: _GetRevArg, directives: List[MigrationScript]) -> None:
        ...
    
    def process_revision_directives(self, context: MigrationContext, revision: _GetRevArg, directives: List[MigrationScript]) -> None:
        ...
    


