"""
This type stub file was generated by pyright.
"""

import logging
import defusedxml.ElementTree
from typing import Any, Optional, Union
from xml.etree import ElementTree
from saml2.validate import valid_instance
from saml2.version import version as __version__

"""Contains base classes representing SAML elements.

    These codes were originally written by Jeffrey Scudder for
    representing Saml elements. Takashi Matsuo had added some codes, and
    changed some. Roland Hedberg rewrote the whole thing from bottom up so
    barely anything but the original structures remained.

    Module objective: provide data classes for SAML constructs. These
    classes hide the XML-ness of SAML and provide a set of native Python
    classes to interact with.

    Conversions to and from XML should only be necessary when the SAML classes
    "touch the wire" and are sent over HTTP. For this reason this module
    provides methods and functions to convert SAML classes to and from strings.
"""
logger = ...
NAMESPACE = ...
NAMEID_FORMAT_EMAILADDRESS = ...
DECISION_TYPE_PERMIT = ...
DECISION_TYPE_DENY = ...
DECISION_TYPE_INDETERMINATE = ...
VERSION = ...
BINDING_SOAP = ...
BINDING_PAOS = ...
BINDING_HTTP_REDIRECT = ...
BINDING_HTTP_POST = ...
BINDING_HTTP_ARTIFACT = ...
BINDING_URI = ...
def class_name(instance): # -> str:
    ...

def create_class_from_xml_string(target_class, xml_string): # -> None:
    """Creates an instance of the target class from a string.

    :param target_class: The class which will be instantiated and populated
        with the contents of the XML. This class must have a c_tag and a
        c_namespace class variable.
    :param xml_string: A string which contains valid XML. The root element
        of the XML string should match the tag and namespace of the desired
        class.

    :return: An instance of the target class with members assigned according to
        the contents of the XML - or None if the root XML tag and namespace did
        not match those of the target class.
    """
    ...

def create_class_from_element_tree(target_class, tree, namespace=..., tag=...): # -> None:
    """Instantiates the class and populates members according to the tree.

    Note: Only use this function with classes that have c_namespace and c_tag
    class members.

    :param target_class: The class which will be instantiated and populated
        with the contents of the XML.
    :param tree: An element tree whose contents will be converted into
        members of the new target_class instance.
    :param namespace: The namespace which the XML tree's root node must
        match. If omitted, the namespace defaults to the c_namespace of the
        target class.
    :param tag: The tag which the XML tree's root node must match. If
        omitted, the tag defaults to the c_tag class member of the target
        class.

    :return: An instance of the target class - or None if the tag and namespace
        of the XML tree's root node did not match the desired namespace and tag.
    """
    ...

class Error(Exception):
    """Exception class thrown by this module."""
    ...


class SAMLError(Exception):
    ...


class ExtensionElement:
    """XML which is not part of the SAML specification,
    these are called extension elements. If a classes parser
    encounters an unexpected XML construct, it is translated into an
    ExtensionElement instance. ExtensionElement is designed to fully
    capture the information in the XML. Child nodes in an XML
    extension are turned into ExtensionElements as well.
    """
    def __init__(self, tag, namespace=..., attributes=..., children=..., text=...) -> None:
        """Constructor for ExtensionElement

        :param namespace: The XML namespace for this element.
        :param tag: The tag (without the namespace qualifier) for
            this element. To reconstruct the full qualified name of the
            element, combine this tag with the namespace.
        :param attributes: The attribute value string pairs for the XML
            attributes of this element.
        :param children: list (optional) A list of ExtensionElements which
            represent the XML child nodes of this element.
        """
        ...
    
    def to_string(self):
        """Serialize the object into a XML string"""
        ...
    
    def transfer_to_element_tree(self): # -> Element | None:
        ...
    
    def become_child_element_of(self, element_tree): # -> None:
        """Converts this object into an etree element and adds it as a child
        node in an etree element.

        Adds self to the ElementTree. This method is required to avoid verbose
        XML which constantly redefines the namespace.

        :param element_tree: ElementTree._Element The element to which this
            object's XML will be added.
        """
        ...
    
    def find_children(self, tag=..., namespace=...): # -> list[Any]:
        """Searches child nodes for objects with the desired tag/namespace.

        Returns a list of extension elements within this object whose tag
        and/or namespace match those passed in. To find all children in
        a particular namespace, specify the namespace but not the tag name.
        If you specify only the tag, the result list may contain extension
        elements in multiple namespaces.

        :param tag: str (optional) The desired tag
        :param namespace: str (optional) The desired namespace

        :return: A list of elements whose tag and/or namespace match the
            parameters values
        """
        ...
    
    def loadd(self, ava): # -> Self:
        """expects a special set of keys"""
        ...
    


def extension_element_from_string(xml_string): # -> ExtensionElement:
    ...

class ExtensionContainer:
    c_tag = ...
    c_namespace = ...
    def __init__(self, text=..., extension_elements=..., extension_attributes=...) -> None:
        ...
    
    def harvest_element_tree(self, tree): # -> None:
        ...
    
    def find_extensions(self, tag=..., namespace=...): # -> list[Any]:
        """Searches extension elements for child nodes with the desired name.

        Returns a list of extension elements within this object whose tag
        and/or namespace match those passed in. To find all extensions in
        a particular namespace, specify the namespace but not the tag name.
        If you specify only the tag, the result list may contain extension
        elements in multiple namespaces.

        :param tag: str (optional) The desired tag
        :param namespace: str (optional) The desired namespace

        :Return: A list of elements whose tag and/or namespace match the
            parameters values
        """
        ...
    
    def extensions_as_elements(self, tag, schema): # -> list[Any]:
        """Return extensions that has the given tag and belongs to the
        given schema as native elements of that schema.

        :param tag: The tag of the element
        :param schema: Which schema the element should originate from
        :return: a list of native elements
        """
        ...
    
    def add_extension_elements(self, items): # -> None:
        ...
    
    def add_extension_element(self, item): # -> None:
        ...
    
    def add_extension_attribute(self, name, value): # -> None:
        ...
    


def make_vals(val, klass, klass_inst=..., prop=..., part=..., base64encode=...): # -> None:
    """
    Creates a class instance with a specified value, the specified
    class instance may be a value on a property in a defined class instance.

    :param val: The value
    :param klass: The value class
    :param klass_inst: The class instance which has a property on which
        what this function returns is a value.
    :param prop: The property which the value should be assigned to.
    :param part: If the value is one of a possible list of values it should be
        handled slightly different compared to if it isn't.
    :return: Value class instance
    """
    ...

def make_instance(klass, spec, base64encode=...):
    """
    Constructs a class instance containing the specified information

    :param klass: The class
    :param spec: Information to be placed in the instance (a dictionary)
    :return: The instance
    """
    ...

class SamlBase(ExtensionContainer):
    """A foundation class on which SAML classes are built. It
    handles the parsing of attributes and children which are common to all
    SAML classes. By default, the SamlBase class translates all XML child
    nodes into ExtensionElements.
    """
    c_children: Any = ...
    c_attributes: Any = ...
    c_attribute_type: Any = ...
    c_child_order: list[str] = ...
    c_cardinality: dict[str, dict[str, int]] = ...
    c_any: Optional[dict[str, str]] = ...
    c_any_attribute: Optional[dict[str, str]] = ...
    c_value_type: Any = ...
    c_ns_prefix = ...
    def become_child_element_of(self, node): # -> None:
        """
        Note: Only for use with classes that have a c_tag and c_namespace class
        member. It is in SamlBase so that it can be inherited but it should
        not be called on instances of SamlBase.

        :param node: The node to which this instance should be a child
        """
        ...
    
    def register_prefix(self, nspair): # -> None:
        """
        Register with ElementTree a set of namespaces

        :param nspair: A dictionary of prefixes and uris to use when
            constructing the text representation.
        :return:
        """
        ...
    
    def get_ns_map_attribute(self, attributes, uri_set):
        ...
    
    def tag_get_uri(self, elem): # -> None:
        ...
    
    def get_ns_map(self, elements, uri_set):
        ...
    
    def get_prefix_map(self, elements): # -> dict[Any, Any]:
        ...
    
    def get_xml_string_with_self_contained_assertion_within_advice_encrypted_assertion(self, assertion_tag, advice_tag): # -> Any:
        ...
    
    def get_xml_string_with_self_contained_assertion_within_encrypted_assertion(self, assertion_tag): # -> Any:
        """Makes a encrypted assertion only containing self contained
        namespaces.

        :param assertion_tag: Tag for the assertion to be transformed.
        :return: A new samlp.Resonse in string representation.
        """
        ...
    
    def set_prefixes(self, elem, prefix_map): # -> None:
        ...
    
    def fixup_element_prefixes(self, elem, uri_map, memo): # -> None:
        ...
    
    def to_string_force_namespace(self, nspair): # -> Any:
        ...
    
    def to_string(self, nspair=...): # -> Any:
        """Converts the Saml object to a string containing XML.

        :param nspair: A dictionary of prefixes and uris to use when
            constructing the text representation.
        :return: String representation of the object
        """
        ...
    
    def __str__(self) -> str:
        ...
    
    def keyswv(self): # -> list[str]:
        """Return the keys of attributes or children that has values

        :return: list of keys
        """
        ...
    
    def keys(self): # -> list[str]:
        """Return all the keys that represent possible attributes and
        children.

        :return: list of keys
        """
        ...
    
    def children_with_values(self): # -> list[Any]:
        """Returns all children that has values

        :return: Possibly empty list of children.
        """
        ...
    
    def set_text(self, val, base64encode=...): # -> Self:
        """Sets the text property of this instance.

        :param val: The value of the text property
        :param base64encode: Whether the value should be base64encoded
        :return: The instance
        """
        ...
    
    def loadd(self, ava, base64encode=...): # -> Self:
        """
        Sets attributes, children, extension elements and extension
        attributes of this element instance depending on what is in
        the given dictionary. If there are already values on properties
        those will be overwritten. If the keys in the dictionary does
        not correspond to known attributes/children/.. they are ignored.

        :param ava: The dictionary
        :param base64encode: Whether the values on attributes or texts on
            children shoule be base64encoded.
        :return: The instance
        """
        ...
    
    def clear_text(self): # -> None:
        ...
    
    def __eq__(self, other) -> bool:
        ...
    
    def child_class(self, child): # -> Any | None:
        """Return the class a child element should be an instance of

        :param child: The name of the child element
        :return: The class
        """
        ...
    
    def child_cardinality(self, child): # -> tuple[dict[str, int] | Literal[1], dict[str, int] | Literal['unbounded']] | tuple[Literal[1], Literal[1]] | None:
        """Return the cardinality of a child element

        :param child: The name of the child element
        :return: The cardinality as a 2-tuple (min, max).
            The max value is either a number or the string "unbounded".
            The min value is always a number.
        """
        ...
    
    def verify(self): # -> Literal[True]:
        ...
    
    def empty(self): # -> bool:
        ...
    


def element_to_extension_element(element): # -> ExtensionElement:
    """
    Convert an element into a extension element

    :param element: The element instance
    :return: An extension element instance
    """
    ...

def extension_element_to_element(extension_element, translation_functions, namespace=...): # -> None:
    """Convert an extension element to a normal element.
    In order to do this you need to have an idea of what type of
    element it is. Or rather which module it belongs to.

    :param extension_element: The extension element
    :param translation_functions: A dictionary with class identifiers
        as keys and string-to-element translations functions as values
    :param namespace: The namespace of the translation functions.
    :return: An element instance or None
    """
    ...

def extension_elements_to_elements(extension_elements, schemas, keep_unmatched=...): # -> list[Any]:
    """Create a list of elements each one matching one of the
    given extension elements. This is of course dependent on the access
    to schemas that describe the extension elements.

    :param extension_elements: The list of extension elements
    :param schemas: Imported Python modules that represent the different
        known schemas used for the extension elements
    :param keep_unmatched: Whether to keep extension elements that did not match any
        schemas
    :return: A list of elements, representing the set of extension elements
        that was possible to match against a Class in the given schemas.
        The elements returned are the native representation of the elements
        according to the schemas.
    """
    ...

def extension_elements_as_dict(extension_elements, onts): # -> dict[Any, Any]:
    ...

REQUIRED = ...
def is_required_attribute(cls, attr):
    """
    Check if the attribute is a required attribute for a specific SamlBase
    class.

    :param cls: The class
    :param attr: An attribute, note it must be the name of the attribute
        that appears in the XSD in which the class is defined.
    :return: True if required
    """
    ...

