"""
This type stub file was generated by pyright.
"""

from typing import Any

from saml2 import SAMLError
from saml2.entity import Entity
from saml2.response import AuthnResponse

"""Contains classes and functions that a SAML2.0 Service Provider (SP) may use
to conclude its tasks.
"""
logger = ...
SSO_BINDING = ...
FORM_SPEC = ...
LAX = ...
ECP_SERVICE = ...
ACTOR = ...
MIME_PAOS = ...
class IdpUnspecified(SAMLError):
    ...


class VerifyError(SAMLError):
    ...


class SignOnError(SAMLError):
    ...


class LogoutError(SAMLError):
    ...


class NoServiceDefined(SAMLError):
    ...


def create_requested_attribute_node(requested_attrs, attribute_converters): # -> RequestedAttributes:
    ...

class Base(Entity):
    """The basic pySAML2 service provider class"""
    def __init__(self, config=..., identity_cache=..., state_cache=..., virtual_organization=..., config_file=..., msg_cb=...) -> None:
        """
        :param config: A saml2.config.Config instance
        :param identity_cache: Where the class should store identity information
        :param state_cache: Where the class should keep state information
        :param virtual_organization: A specific virtual organization
        """
        ...
    
    def sso_location(self, entityid=..., binding=...): # -> None:
        ...
    
    def add_vo_information_about_user(self, name_id): # -> dict[Any, Any]:
        """Add information to the knowledge I have about the user. This is
        for Virtual organizations.

        :param name_id: The subject identifier
        :return: A possibly extended knowledge.
        """
        ...
    
    @staticmethod
    def is_session_valid(_session_id): # -> Literal[True]:
        """Place holder. Supposed to check if the session is still valid."""
        ...
    
    def service_urls(self, binding=...): # -> list[Any] | None:
        ...
    
    def create_authn_request(self, destination, vorg=..., scoping=..., binding=..., nameid_format=..., service_url_binding=..., message_id=..., consent=..., extensions=..., sign=..., sign_prepare=..., sign_alg=..., digest_alg=..., allow_create=..., requested_attributes=..., **kwargs):
        """Creates an authentication request.

        :param destination: Where the request should be sent.
        :param vorg: The virtual organization the service belongs to.
        :param scoping: The scope of the request
        :param binding: The protocol to use for the Response !!
        :param nameid_format: Format of the NameIDPolicy
        :param service_url_binding: Where the reply should be sent dependent
            on reply binding.
        :param message_id: The identifier for this request
        :param consent: Whether the principal have given her consent
        :param extensions: Possible extensions
        :param sign: Whether the request should be signed or not.
        :param sign_prepare: Whether the signature should be prepared or not.
        :param sign_alg: The request signature algorithm
        :param digest_alg: The request digest algorithm
        :param allow_create: If the identity provider is allowed, in the course
            of fulfilling the request, to create a new identifier to represent
            the principal.
        :param requested_attributes: A list of dicts which define attributes to
            be used as eIDAS Requested Attributes for this request. If not
            defined the configuration option requested_attributes will be used,
            if defined. The format is the same as the requested_attributes
            configuration option.
        :param kwargs: Extra key word arguments
        :return: either a tuple of request ID and <samlp:AuthnRequest> instance
                 or a tuple of request ID and str when sign is set to True
        """
        ...
    
    def create_attribute_query(self, destination, name_id=..., attribute=..., message_id=..., consent=..., extensions=..., sign=..., sign_prepare=..., sign_alg=..., digest_alg=..., **kwargs): # -> tuple[Any, Any]:
        """Constructs an AttributeQuery

        :param destination: To whom the query should be sent
        :param name_id: The identifier of the subject
        :param attribute: A dictionary of attributes and values that is
            asked for. The key are one of 4 variants:
            3-tuple of name_format,name and friendly_name,
            2-tuple of name_format and name,
            1-tuple with name or
            just the name as a string.
        :param sp_name_qualifier: The unique identifier of the
            service provider or affiliation of providers for whom the
            identifier was generated.
        :param name_qualifier: The unique identifier of the identity
            provider that generated the identifier.
        :param format: The format of the name ID
        :param message_id: The identifier of the session
        :param consent: Whether the principal have given her consent
        :param extensions: Possible extensions
        :param sign: Whether the query should be signed or not.
        :param sign_prepare: Whether the Signature element should be added.
        :return: Tuple of request ID and an AttributeQuery instance
        """
        ...
    
    def create_authz_decision_query(self, destination, action, evidence=..., resource=..., subject=..., message_id=..., consent=..., extensions=..., sign=..., sign_alg=..., digest_alg=..., **kwargs): # -> tuple[Any, Any]:
        """Creates an authz decision query.

        :param destination: The IdP endpoint
        :param action: The action you want to perform (has to be at least one)
        :param evidence: Why you should be able to perform the action
        :param resource: The resource you want to perform the action on
        :param subject: Who wants to do the thing
        :param message_id: Message identifier
        :param consent: If the principal gave her consent to this request
        :param extensions: Possible request extensions
        :param sign: Whether the request should be signed or not.
        :return: AuthzDecisionQuery instance
        """
        ...
    
    def create_authz_decision_query_using_assertion(self, destination, assertion, action=..., resource=..., subject=..., message_id=..., consent=..., extensions=..., sign=..., sign_alg=..., digest_alg=..., nsprefix=...): # -> tuple[Any, Any]:
        """Makes an authz decision query based on a previously received
        Assertion.

        :param destination: The IdP endpoint to send the request to
        :param assertion: An Assertion instance
        :param action: The action you want to perform (has to be at least one)
        :param resource: The resource you want to perform the action on
        :param subject: Who wants to do the thing
        :param message_id: Message identifier
        :param consent: If the principal gave her consent to this request
        :param extensions: Possible request extensions
        :param sign: Whether the request should be signed or not.
        :return: AuthzDecisionQuery instance
        """
        ...
    
    @staticmethod
    def create_assertion_id_request(assertion_id_refs, **kwargs): # -> tuple[Literal[0], str] | tuple[Literal[0], Any]:
        """

        :param assertion_id_refs:
        :return: One ID ref
        """
        ...
    
    def create_authn_query(self, subject, destination=..., authn_context=..., session_index=..., message_id=..., consent=..., extensions=..., sign=..., nsprefix=..., sign_alg=..., digest_alg=...): # -> tuple[Any, Any]:
        """

        :param subject: The subject its all about as a <Subject> instance
        :param destination: The IdP endpoint to send the request to
        :param authn_context: list of <RequestedAuthnContext> instances
        :param session_index: a specified session index
        :param message_id: Message identifier
        :param consent: If the principal gave her consent to this request
        :param extensions: Possible request extensions
        :param sign: Whether the request should be signed or not.
        :return:
        """
        ...
    
    def create_name_id_mapping_request(self, name_id_policy, name_id=..., base_id=..., encrypted_id=..., destination=..., message_id=..., consent=..., extensions=..., sign=..., nsprefix=..., sign_alg=..., digest_alg=...): # -> tuple[Any, Any]:
        """

        :param name_id_policy:
        :param name_id:
        :param base_id:
        :param encrypted_id:
        :param destination:
        :param message_id: Message identifier
        :param consent: If the principal gave her consent to this request
        :param extensions: Possible request extensions
        :param sign: Whether the request should be signed or not.
        :return:
        """
        ...
    
    def parse_authn_request_response(self,
        xmlstr: str,
        binding: Any,
        outstanding: Any=...,
        outstanding_certs: Any=...,
        conv_info: Any=...) -> AuthnResponse | None:
        """Deal with an AuthnResponse

        :param xmlstr: The reply as a xml string
        :param binding: Which binding that was used for the transport
        :param outstanding: A dictionary with session IDs as keys and
            the original web request from the user before redirection
            as values.
        :param outstanding_certs:
        :param conv_info: Information about the conversation.
        :return: An response.AuthnResponse or None
        """
        ...
    
    def parse_authz_decision_query_response(self, response, binding=...): # -> None:
        """Verify that the response is OK"""
        ...
    
    def parse_authn_query_response(self, response, binding=...): # -> None:
        """Verify that the response is OK"""
        ...
    
    def parse_assertion_id_request_response(self, response, binding): # -> None:
        """Verify that the response is OK"""
        ...
    
    def parse_attribute_query_response(self, response, binding): # -> None:
        ...
    
    def parse_name_id_mapping_request_response(self, txt, binding=...): # -> None:
        """

        :param txt: SOAP enveloped SAML message
        :param binding: Just a placeholder, it's always BINDING_SOAP
        :return: parsed and verified <NameIDMappingResponse> instance
        """
        ...
    
    def create_ecp_authn_request(self, entityid=..., relay_state=..., sign=..., sign_alg=..., digest_alg=..., **kwargs): # -> tuple[Any | Literal[0], str]:
        """Makes an authentication request.

        :param entityid: The entity ID of the IdP to send the request to
        :param relay_state: A token that can be used by the SP to know
            where to continue the conversation with the client
        :param sign: Whether the request should be signed or not.
        :return: SOAP message with the AuthnRequest
        """
        ...
    
    def parse_ecp_authn_response(self, txt, outstanding=...): # -> tuple[AuthnResponse | None, Any | None]:
        ...
    
    @staticmethod
    def can_handle_ecp_response(response): # -> bool:
        ...
    
    @staticmethod
    def create_discovery_service_request(url, entity_id, **kwargs): # -> str:
        """
        Created the HTTP redirect URL needed to send the user to the
        discovery service.

        :param url: The URL of the discovery service
        :param entity_id: The unique identifier of the service provider
        :param return: The discovery service MUST redirect the user agent
            to this location in response to this request
        :param policy: A parameter name used to indicate the desired behavior
            controlling the processing of the discovery service
        :param returnIDParam: A parameter name used to return the unique
            identifier of the selected identity provider to the original
            requester.
        :param isPassive: A boolean value True/False that controls
            whether the discovery service is allowed to visibly interact with
            the user agent.
        :return: A URL
        """
        ...
    
    @staticmethod
    def parse_discovery_service_response(url=..., query=..., returnIDParam=...): # -> str:
        """
        Deal with the response url from a Discovery Service

        :param url: the url the user was redirected back to or
        :param query: just the query part of the URL.
        :param returnIDParam: This is where the identifier of the IdP is
            place if it was specified in the query. Default is 'entityID'
        :return: The IdP identifier or "" if none was given
        """
        ...
    


