"""
This type stub file was generated by pyright.
"""

from logging import Logger
from typing import Any

from saml2 import SAMLError

class Subject:
    text: str|None

logger: Logger = ...
class IncorrectlySigned(SAMLError):
    ...


class InvalidAssertion(SAMLError):
    ...


class DecryptionFailed(SAMLError):
    ...


class VerificationError(SAMLError):
    ...


class StatusError(SAMLError):
    ...


class UnsolicitedResponse(SAMLError):
    ...


class StatusVersionMismatch(StatusError):
    ...


class StatusAuthnFailed(StatusError):
    ...


class StatusInvalidAttrNameOrValue(StatusError):
    ...


class StatusInvalidAuthnResponseStatement(StatusError):
    ...


class StatusInvalidNameidPolicy(StatusError):
    ...


class StatusNoAuthnContext(StatusError):
    ...


class StatusNoAvailableIdp(StatusError):
    ...


class StatusNoPassive(StatusError):
    ...


class StatusNoSupportedIdp(StatusError):
    ...


class StatusPartialLogout(StatusError):
    ...


class StatusProxyCountExceeded(StatusError):
    ...


class StatusRequestDenied(StatusError):
    ...


class StatusRequestUnsupported(StatusError):
    ...


class StatusRequestVersionDeprecated(StatusError):
    ...


class StatusRequestVersionTooHigh(StatusError):
    ...


class StatusRequestVersionTooLow(StatusError):
    ...


class StatusResourceNotRecognized(StatusError):
    ...


class StatusTooManyResponses(StatusError):
    ...


class StatusUnknownAttrProfile(StatusError):
    ...


class StatusUnknownPrincipal(StatusError):
    ...


class StatusUnsupportedBinding(StatusError):
    ...


class StatusResponder(StatusError):
    ...


STATUSCODE2EXCEPTION = ...
def for_me(conditions, myself): # -> bool:
    """Am I among the intended audiences"""
    ...

def authn_response(conf, return_addrs, outstanding_queries=..., timeslack=..., asynchop=..., allow_unsolicited=..., want_assertions_signed=..., conv_info=...): # -> AuthnResponse:
    ...

def attribute_response(conf, return_addrs, timeslack=..., asynchop=..., test=..., conv_info=...): # -> AttributeResponse:
    ...

class StatusResponse:
    msgtype = ...
    def __init__(self, sec_context, return_addrs=..., timeslack=..., request_id=..., asynchop=..., conv_info=...) -> None:
        ...
    
    def load_instance(self, instance): # -> Self:
        ...
    
    def status_ok(self): # -> Literal[True]:
        ...
    
    def issue_instant_ok(self):
        """Check that the response was issued at a reasonable time"""
        ...
    
    def loads(self, xmldata, decode=..., origxml=...): # -> Self:
        ...
    
    def verify(self, keys=...): # -> Literal[True] | None:
        ...
    
    def update(self, mold): # -> None:
        ...
    
    def issuer(self): # -> LiteralString:
        ...
    


class LogoutResponse(StatusResponse):
    msgtype = ...
    def __init__(self, sec_context, return_addrs=..., timeslack=..., asynchop=..., conv_info=...) -> None:
        ...
    


class NameIDMappingResponse(StatusResponse):
    msgtype = ...
    def __init__(self, sec_context, return_addrs=..., timeslack=..., request_id=..., asynchop=..., conv_info=...) -> None:
        ...
    


class ManageNameIDResponse(StatusResponse):
    msgtype = ...
    def __init__(self, sec_context, return_addrs=..., timeslack=..., request_id=..., asynchop=..., conv_info=...) -> None:
        ...
    


class AuthnResponse(StatusResponse):
    """This is where all the profile compliance is checked.
    This one does saml2int compliance."""
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, entity_id, return_addrs=..., outstanding_queries=..., timeslack=..., asynchop=..., allow_unsolicited=..., test=..., allow_unknown_attributes=..., want_assertions_signed=..., want_assertions_or_response_signed=..., want_response_signed=..., conv_info=..., **kwargs) -> None:
        ...
    
    def check_subject_confirmation_in_response_to(self, irp): # -> bool:
        ...
    
    def loads(self, xmldata, decode=..., origxml=...): # -> Self:
        ...
    
    def clear(self): # -> None:
        ...
    
    def authn_statement_ok(self, optional=...): # -> bool:
        ...
    
    def condition_ok(self, lax=...): # -> bool:
        ...
    
    def decrypt_attributes(self, attribute_statement, keys=...): # -> None:
        """
        Decrypts possible encrypted attributes and adds the decrypts to the
        list of attributes.

        :param attribute_statement: A SAML.AttributeStatement which might
            contain both encrypted attributes and attributes.
        """
        ...
    
    def read_attribute_statement(self, attr_statem): # -> dict[Any, Any]:
        ...
    
    def get_identity(self) -> dict[Any, Any]:
        """The assertion can contain zero or more attributeStatements"""
        ...
    
    def get_subject(self, keys: Any=...) -> Subject|None:
        """The assertion must contain a Subject"""
        ...
    
    def decrypt_assertions(self, encrypted_assertions, decr_txt, issuer=..., verified=...): # -> list[Any]:
        """Moves the decrypted assertion from the encrypted assertion to a
        list.

        :param encrypted_assertions: A list of encrypted assertions.
        :param decr_txt: The string representation containing the decrypted
        data. Used when verifying signatures.
        :param issuer: The issuer of the response.
        :param verified: If True do not verify signatures, otherwise verify
        the signature if it exists.
        :return: A list of decrypted assertions.
        """
        ...
    
    def find_encrypt_data_assertion(self, enc_assertions): # -> Literal[True] | None:
        """Verifies if a list of encrypted assertions contains encrypted data.

        :param enc_assertions: A list of encrypted assertions.
        :return: True encrypted data exists otherwise false.
        """
        ...
    
    def find_encrypt_data_assertion_list(self, _assertions): # -> Literal[True] | None:
        """Verifies if a list of assertions contains encrypted data in the
        advice element.

        :param _assertions: A list of assertions.
        :return: True encrypted data exists otherwise false.
        """
        ...
    
    def find_encrypt_data(self, resp): # -> bool:
        """Verifies if a saml response contains encrypted assertions with
        encrypted data.

        :param resp: A saml response.
        :return: True encrypted data exists otherwise false.
        """
        ...
    
    def parse_assertion(self, keys=...):
        """Parse the assertions for a saml response.

        :param keys: A string representing a RSA key or a list of strings
        containing RSA keys.
        :return: True if the assertions are parsed otherwise False.
        """
        ...
    
    def verify(self, keys=...): # -> Self | None:
        """Verify that the assertion is syntactically correct and the
        signature is correct if present.

        :param keys: If not the default key file should be used then use one
        of these.
        """
        ...
    
    def session_id(self):
        """Returns the SessionID of the response"""
        ...
    
    def id(self):
        """Return the ID of the response"""
        ...
    
    def authn_info(self): # -> list[Any]:
        ...
    
    def authz_decision_info(self): # -> dict[str, list[Any]]:
        ...
    
    def session_info(self): # -> dict[str, Any]:
        """Returns a predefined set of information gleened from the
        response.
        :returns: Dictionary with information
        """
        ...
    
    def __str__(self) -> str:
        ...
    
    def verify_recipient(self, recipient): # -> bool:
        """
        Verify that I'm the recipient of the assertion

        :param recipient: A URI specifying the entity or location to which an
            attesting entity can present the assertion.
        :return: True/False
        """
        ...
    
    def verify_attesting_entity(self, subject_confirmation): # -> bool:
        """
        At least one address specification has to be correct.

        :param subject_confirmation: A SubbjectConfirmation instance
        :return: True/False
        """
        ...
    


class AuthnQueryResponse(AuthnResponse):
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, entity_id, return_addrs=..., timeslack=..., asynchop=..., test=..., conv_info=...) -> None:
        ...
    
    def condition_ok(self, lax=...): # -> Literal[True]:
        ...
    


class AttributeResponse(AuthnResponse):
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, entity_id, return_addrs=..., timeslack=..., asynchop=..., test=..., conv_info=...) -> None:
        ...
    


class AuthzResponse(AuthnResponse):
    """A successful response will be in the form of assertions containing
    authorization decision statements."""
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, entity_id, return_addrs=..., timeslack=..., asynchop=..., conv_info=...) -> None:
        ...
    


class ArtifactResponse(AuthnResponse):
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, entity_id, return_addrs=..., timeslack=..., asynchop=..., test=..., conv_info=...) -> None:
        ...
    


def response_factory(xmlstr, conf, return_addrs=..., outstanding_queries=..., timeslack=..., decode=..., request_id=..., origxml=..., asynchop=..., allow_unsolicited=..., want_assertions_signed=..., conv_info=...): # -> AuthnResponse | LogoutResponse | StatusResponse:
    ...

class AssertionIDResponse:
    msgtype = ...
    def __init__(self, sec_context, attribute_converters, timeslack=..., **kwargs) -> None:
        ...
    
    def loads(self, xmldata, decode=..., origxml=...): # -> Self:
        ...
    
    def verify(self, keys=...): # -> Self:
        ...
    


