"""
This type stub file was generated by pyright.
"""

from typing import List, Optional, TYPE_CHECKING, Union
from .runtime.environment import ProcessRevisionDirectiveFn
from alembic.config import Config
from alembic.script.base import Script
from alembic.script.revision import _RevIdType

if TYPE_CHECKING:
    ...
def list_templates(config: Config) -> None:
    """List available templates.

    :param config: a :class:`.Config` object.

    """
    ...

def init(config: Config, directory: str, template: str = ..., package: bool = ...) -> None:
    """Initialize a new scripts directory.

    :param config: a :class:`.Config` object.

    :param directory: string path of the target directory

    :param template: string name of the migration environment template to
     use.

    :param package: when True, write ``__init__.py`` files into the
     environment location as well as the versions/ location.

    """
    ...

def revision(config: Config, message: Optional[str] = ..., autogenerate: bool = ..., sql: bool = ..., head: str = ..., splice: bool = ..., branch_label: Optional[_RevIdType] = ..., version_path: Optional[str] = ..., rev_id: Optional[str] = ..., depends_on: Optional[str] = ..., process_revision_directives: Optional[ProcessRevisionDirectiveFn] = ...) -> Union[Optional[Script], List[Optional[Script]]]:
    """Create a new revision file.

    :param config: a :class:`.Config` object.

    :param message: string message to apply to the revision; this is the
     ``-m`` option to ``alembic revision``.

    :param autogenerate: whether or not to autogenerate the script from
     the database; this is the ``--autogenerate`` option to
     ``alembic revision``.

    :param sql: whether to dump the script out as a SQL string; when specified,
     the script is dumped to stdout.  This is the ``--sql`` option to
     ``alembic revision``.

    :param head: head revision to build the new revision upon as a parent;
     this is the ``--head`` option to ``alembic revision``.

    :param splice: whether or not the new revision should be made into a
     new head of its own; is required when the given ``head`` is not itself
     a head.  This is the ``--splice`` option to ``alembic revision``.

    :param branch_label: string label to apply to the branch; this is the
     ``--branch-label`` option to ``alembic revision``.

    :param version_path: string symbol identifying a specific version path
     from the configuration; this is the ``--version-path`` option to
     ``alembic revision``.

    :param rev_id: optional revision identifier to use instead of having
     one generated; this is the ``--rev-id`` option to ``alembic revision``.

    :param depends_on: optional list of "depends on" identifiers; this is the
     ``--depends-on`` option to ``alembic revision``.

    :param process_revision_directives: this is a callable that takes the
     same form as the callable described at
     :paramref:`.EnvironmentContext.configure.process_revision_directives`;
     will be applied to the structure generated by the revision process
     where it can be altered programmatically.   Note that unlike all
     the other parameters, this option is only available via programmatic
     use of :func:`.command.revision`

    """
    ...

def check(config: Config) -> None:
    """Check if revision command with autogenerate has pending upgrade ops.

    :param config: a :class:`.Config` object.

    .. versionadded:: 1.9.0

    """
    ...

def merge(config: Config, revisions: _RevIdType, message: Optional[str] = ..., branch_label: Optional[_RevIdType] = ..., rev_id: Optional[str] = ...) -> Optional[Script]:
    """Merge two revisions together.  Creates a new migration file.

    :param config: a :class:`.Config` instance

    :param message: string message to apply to the revision

    :param branch_label: string label name to apply to the new revision

    :param rev_id: hardcoded revision identifier instead of generating a new
     one.

    .. seealso::

        :ref:`branches`

    """
    ...

def upgrade(config: Config, revision: str, sql: bool = ..., tag: Optional[str] = ...) -> None:
    """Upgrade to a later version.

    :param config: a :class:`.Config` instance.

    :param revision: string revision target or range for --sql mode

    :param sql: if True, use ``--sql`` mode

    :param tag: an arbitrary "tag" that can be intercepted by custom
     ``env.py`` scripts via the :meth:`.EnvironmentContext.get_tag_argument`
     method.

    """
    ...

def downgrade(config: Config, revision: str, sql: bool = ..., tag: Optional[str] = ...) -> None:
    """Revert to a previous version.

    :param config: a :class:`.Config` instance.

    :param revision: string revision target or range for --sql mode

    :param sql: if True, use ``--sql`` mode

    :param tag: an arbitrary "tag" that can be intercepted by custom
     ``env.py`` scripts via the :meth:`.EnvironmentContext.get_tag_argument`
     method.

    """
    ...

def show(config, rev): # -> None:
    """Show the revision(s) denoted by the given symbol.

    :param config: a :class:`.Config` instance.

    :param revision: string revision target

    """
    ...

def history(config: Config, rev_range: Optional[str] = ..., verbose: bool = ..., indicate_current: bool = ...) -> None:
    """List changeset scripts in chronological order.

    :param config: a :class:`.Config` instance.

    :param rev_range: string revision range

    :param verbose: output in verbose mode.

    :param indicate_current: indicate current revision.

    """
    ...

def heads(config, verbose=..., resolve_dependencies=...): # -> None:
    """Show current available heads in the script directory.

    :param config: a :class:`.Config` instance.

    :param verbose: output in verbose mode.

    :param resolve_dependencies: treat dependency version as down revisions.

    """
    ...

def branches(config, verbose=...): # -> None:
    """Show current branch points.

    :param config: a :class:`.Config` instance.

    :param verbose: output in verbose mode.

    """
    ...

def current(config: Config, verbose: bool = ...) -> None:
    """Display the current revision for a database.

    :param config: a :class:`.Config` instance.

    :param verbose: output in verbose mode.

    """
    ...

def stamp(config: Config, revision: _RevIdType, sql: bool = ..., tag: Optional[str] = ..., purge: bool = ...) -> None:
    """'stamp' the revision table with the given revision; don't
    run any migrations.

    :param config: a :class:`.Config` instance.

    :param revision: target revision or list of revisions.   May be a list
     to indicate stamping of multiple branch heads.

     .. note:: this parameter is called "revisions" in the command line
        interface.

    :param sql: use ``--sql`` mode

    :param tag: an arbitrary "tag" that can be intercepted by custom
     ``env.py`` scripts via the :class:`.EnvironmentContext.get_tag_argument`
     method.

    :param purge: delete all entries in the version table before stamping.

    """
    ...

def edit(config: Config, rev: str) -> None:
    """Edit revision script(s) using $EDITOR.

    :param config: a :class:`.Config` instance.

    :param rev: target revision.

    """
    ...

def ensure_version(config: Config, sql: bool = ...) -> None:
    """Create the alembic version table if it doesn't exist already .

    :param config: a :class:`.Config` instance.

    :param sql: use ``--sql`` mode

     .. versionadded:: 1.7.6

    """
    ...

