"""
This type stub file was generated by pyright.
"""

import dataclasses
import typing as t

"""
This module defines a Connexion specific options class to pass to the Connexion App or API.
"""
NO_UI_MSG = ...
logger = ...
@dataclasses.dataclass
class SwaggerUIOptions:
    """Options to configure the Swagger UI.

    :param serve_spec: Whether to serve the Swagger / OpenAPI Specification
    :param spec_path: Where to serve the Swagger / OpenAPI Specification

    :param swagger_ui: Whether to serve the Swagger UI
    :param swagger_ui_path: Where to serve the Swagger UI
    :param swagger_ui_config: Options to configure the Swagger UI. See
          https://swagger.io/docs/open-source-tools/swagger-ui/usage/configuration
          for an overview of the available options.
    :param swagger_ui_template_dir: Directory with static files to use to serve Swagger UI
    :param swagger_ui_template_arguments: Arguments passed to the Swagger UI template. Useful
        when providing your own template dir with additional template arguments.
    """
    serve_spec: bool = ...
    spec_path: t.Optional[str] = ...
    swagger_ui: bool = ...
    swagger_ui_config: dict = ...
    swagger_ui_path: str = ...
    swagger_ui_template_dir: t.Optional[str] = ...
    swagger_ui_template_arguments: dict = ...


class SwaggerUIConfig:
    """Class holding swagger UI specific options."""
    def __init__(self, options: t.Optional[SwaggerUIOptions] = ..., oas_version: t.Tuple[int, ...] = ...) -> None:
        ...
    
    @property
    def openapi_spec_available(self) -> bool:
        """Whether to make the OpenAPI Specification available."""
        ...
    
    @property
    def openapi_spec_path(self) -> str:
        """Path to host the Swagger UI."""
        ...
    
    @property
    def swagger_ui_available(self) -> bool:
        """Whether to make the Swagger UI available."""
        ...
    
    @property
    def swagger_ui_path(self) -> str:
        """Path to mount the Swagger UI and make it accessible via a browser."""
        ...
    
    @property
    def swagger_ui_template_dir(self) -> str:
        """Directory with static files to use to serve Swagger UI."""
        ...
    
    @property
    def swagger_ui_config(self) -> dict:
        """Options to configure the Swagger UI."""
        ...
    
    @property
    def swagger_ui_template_arguments(self) -> dict:
        """Arguments passed to the Swagger UI template."""
        ...
    


