"""
This type stub file was generated by pyright.
"""

from starlette.types import Receive, Scope, Send

"""
This module defines a Validator interface with base functionality that can be subclassed
for custom validators provided to the RequestValidationMiddleware.
"""
class AbstractRequestBodyValidator:
    """
    Validator interface with base functionality that can be subclassed for custom validators.

    .. note: Validators load the whole body into memory, which can be a problem for large payloads.
    """
    MUTABLE_VALIDATION = ...
    MAX_MESSAGE_LENGTH = ...
    def __init__(self, *, schema: dict, required: bool = ..., nullable: bool = ..., encoding: str, strict_validation: bool, **kwargs) -> None:
        """
        :param schema: Schema of operation to validate
        :param required: Whether RequestBody is required
        :param nullable: Whether RequestBody is nullable
        :param encoding: Encoding of body (passed via Content-Type header)
        :param kwargs: Additional arguments for subclasses
        :param strict_validation: Whether to allow parameters not defined in the spec
        """
        ...
    
    async def wrap_receive(self, receive: Receive, *, scope: Scope) -> Receive:
        """
        Wrap the provided `receive` channel with request body validation.

        This method updates the provided `scope` in place with the right `Content-Length` header.
        """
        ...
    


class AbstractResponseBodyValidator:
    """
    Validator interface with base functionality that can be subclassed for custom validators.

    .. note: Validators load the whole body into memory, which can be a problem for large payloads.
    """
    def __init__(self, scope: Scope, *, schema: dict, nullable: bool = ..., encoding: str) -> None:
        ...
    
    def wrap_send(self, send: Send) -> Send:
        """Wrap the provided send channel with response body validation"""
        ...
    


