"""
This type stub file was generated by pyright.
"""

import functools
from typing import Any, Optional, TYPE_CHECKING, Union
from sqlalchemy.ext.compiler import compiles
from sqlalchemy.schema import Column, DDLElement
from sqlalchemy.sql.elements import quoted_name
from ..util.sqla_compat import Computed, Identity
from sqlalchemy.sql.compiler import Compiled, DDLCompiler
from sqlalchemy.sql.type_api import TypeEngine
from .impl import DefaultImpl

if TYPE_CHECKING:
    ...
_ServerDefault = Union["TextClause", "FetchedValue", "Function[Any]", str]
class AlterTable(DDLElement):
    """Represent an ALTER TABLE statement.

    Only the string name and optional schema name of the table
    is required, not a full Table object.

    """
    def __init__(self, table_name: str, schema: Optional[Union[quoted_name, str]] = ...) -> None:
        ...
    


class RenameTable(AlterTable):
    def __init__(self, old_table_name: str, new_table_name: Union[quoted_name, str], schema: Optional[Union[quoted_name, str]] = ...) -> None:
        ...
    


class AlterColumn(AlterTable):
    def __init__(self, name: str, column_name: str, schema: Optional[str] = ..., existing_type: Optional[TypeEngine] = ..., existing_nullable: Optional[bool] = ..., existing_server_default: Optional[_ServerDefault] = ..., existing_comment: Optional[str] = ...) -> None:
        ...
    


class ColumnNullable(AlterColumn):
    def __init__(self, name: str, column_name: str, nullable: bool, **kw) -> None:
        ...
    


class ColumnType(AlterColumn):
    def __init__(self, name: str, column_name: str, type_: TypeEngine, **kw) -> None:
        ...
    


class ColumnName(AlterColumn):
    def __init__(self, name: str, column_name: str, newname: str, **kw) -> None:
        ...
    


class ColumnDefault(AlterColumn):
    def __init__(self, name: str, column_name: str, default: Optional[_ServerDefault], **kw) -> None:
        ...
    


class ComputedColumnDefault(AlterColumn):
    def __init__(self, name: str, column_name: str, default: Optional[Computed], **kw) -> None:
        ...
    


class IdentityColumnDefault(AlterColumn):
    def __init__(self, name: str, column_name: str, default: Optional[Identity], impl: DefaultImpl, **kw) -> None:
        ...
    


class AddColumn(AlterTable):
    def __init__(self, name: str, column: Column[Any], schema: Optional[Union[quoted_name, str]] = ...) -> None:
        ...
    


class DropColumn(AlterTable):
    def __init__(self, name: str, column: Column[Any], schema: Optional[str] = ...) -> None:
        ...
    


class ColumnComment(AlterColumn):
    def __init__(self, name: str, column_name: str, comment: Optional[str], **kw) -> None:
        ...
    


@compiles(RenameTable)
def visit_rename_table(element: RenameTable, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(AddColumn)
def visit_add_column(element: AddColumn, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(DropColumn)
def visit_drop_column(element: DropColumn, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(ColumnNullable)
def visit_column_nullable(element: ColumnNullable, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(ColumnType)
def visit_column_type(element: ColumnType, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(ColumnName)
def visit_column_name(element: ColumnName, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(ColumnDefault)
def visit_column_default(element: ColumnDefault, compiler: DDLCompiler, **kw) -> str:
    ...

@compiles(ComputedColumnDefault)
def visit_computed_column(element: ComputedColumnDefault, compiler: DDLCompiler, **kw):
    ...

@compiles(IdentityColumnDefault)
def visit_identity_column(element: IdentityColumnDefault, compiler: DDLCompiler, **kw):
    ...

def quote_dotted(name: Union[quoted_name, str], quote: functools.partial) -> Union[quoted_name, str]:
    """quote the elements of a dotted name"""
    ...

def format_table_name(compiler: Compiled, name: Union[quoted_name, str], schema: Optional[Union[quoted_name, str]]) -> Union[quoted_name, str]:
    ...

def format_column_name(compiler: DDLCompiler, name: Optional[Union[quoted_name, str]]) -> Union[quoted_name, str]:
    ...

def format_server_default(compiler: DDLCompiler, default: Optional[_ServerDefault]) -> str:
    ...

def format_type(compiler: DDLCompiler, type_: TypeEngine) -> str:
    ...

def alter_table(compiler: DDLCompiler, name: str, schema: Optional[str]) -> str:
    ...

def drop_column(compiler: DDLCompiler, name: str, **kw) -> str:
    ...

def alter_column(compiler: DDLCompiler, name: str) -> str:
    ...

def add_column(compiler: DDLCompiler, column: Column[Any], **kw) -> str:
    ...

