"""
This type stub file was generated by pyright.
"""

from saml2 import SAMLError

logger = ...
class UnknownNameFormat(SAMLError):
    ...


class ConverterError(SAMLError):
    ...


def load_maps(dirspec): # -> dict[Any, Any]:
    """load the attribute maps

    :param dirspec: a directory specification
    :return: a dictionary with the name of the map as key and the
        map as value. The map itself is a dictionary with two keys:
        "to" and "fro". The values for those keys are the actual mapping.
    """
    ...

def ac_factory(path=...): # -> list[Any]:
    """Attribute Converter factory

    :param path: The path to a directory where the attribute maps are expected
        to reside.
    :return: A list of AttributeConverter instances
    """
    ...

def to_local(acs, statement, allow_unknown_attributes=...): # -> dict[Any, Any]:
    """Replaces the attribute names in a attribute value assertion with the
    equivalent name from a local name format.

    :param acs: List of Attribute Converters
    :param statement: The Attribute Statement
    :param allow_unknown_attributes: If unknown attributes are allowed
    :return: A key,values dictionary
    """
    ...

def list_to_local(acs, attrlist, allow_unknown_attributes=...): # -> dict[Any, Any]:
    """Replaces the attribute names in a attribute value assertion with the
    equivalent name from a local name format.

    :param acs: List of Attribute Converters
    :param attrlist: List of Attributes
    :param allow_unknown_attributes: If unknown attributes are allowed
    :return: A key,values dictionary
    """
    ...

def from_local(acs, ava, name_format): # -> None:
    ...

def from_local_name(acs, attr, name_format):
    """
    :param acs: List of AttributeConverter instances
    :param attr: attribute name as string
    :param name_format: Which name-format it should be translated to
    :return: An Attribute instance
    """
    ...

def to_local_name(acs, attr):
    """
    :param acs: List of AttributeConverter instances
    :param attr: an Attribute instance
    :return: The local attribute name
    """
    ...

def get_local_name(acs, attr, name_format): # -> None:
    ...

def d_to_local_name(acs, attr):
    """
    :param acs: List of AttributeConverter instances
    :param attr: an Attribute dictionary
    :return: The local attribute name
    """
    ...

class AttributeConverter:
    """Converts from an attribute statement to a key,value dictionary and
    vice-versa"""
    def __init__(self, name_format=...) -> None:
        ...
    
    def adjust(self): # -> None:
        """If one of the transformations is not defined it is expected to
        be the mirror image of the other.
        """
        ...
    
    def from_dict(self, mapdict): # -> None:
        """Import the attribute map from  a dictionary

        :param mapdict: The dictionary
        """
        ...
    
    def lcd_ava_from(self, attribute): # -> tuple[Any, list[str | Any]]:
        """
        If nothing else works, this should

        :param attribute: an Attribute instance
        :return:
        """
        ...
    
    def fail_safe_fro(self, statement): # -> dict[Any, Any]:
        """In case there is not formats defined or if the name format is
        undefined

        :param statement: AttributeStatement instance
        :return: A dictionary with names and values
        """
        ...
    
    def ava_from(self, attribute, allow_unknown=...): # -> tuple[Any | Literal['eduPersonTargetedID'], list[Any]]:
        ...
    
    def fro(self, statement): # -> dict[Any, Any]:
        """Get the attributes and the attribute values.

        :param statement: The AttributeStatement.
        :return: A dictionary containing attributes and values
        """
        ...
    
    def to_format(self, attr): # -> Attribute:
        """Creates an Attribute instance with name, name_format and
        friendly_name

        :param attr: The local name of the attribute
        :return: An Attribute instance
        """
        ...
    
    def from_format(self, attr): # -> Literal['']:
        """Find out the local name of an attribute

        :param attr: An saml.Attribute instance
        :return: The local attribute name or "" if no mapping could be made
        """
        ...
    
    def d_from_format(self, attr): # -> Literal['']:
        """Find out the local name of an attribute

        :param attr: An Attribute dictionary
        :return: The local attribute name or "" if no mapping could be made
        """
        ...
    
    def to_(self, attrvals): # -> list[Any]:
        """Create a list of Attribute instances.

        :param attrvals: A dictionary of attributes and values
        :return: A list of Attribute instances
        """
        ...
    
    def to_eptid_value(self, values): # -> list[AttributeValue]:
        """
        Create AttributeValue instances of NameID from the given values.

        Special handling for the "eptid" attribute
        Name=urn:oid:1.3.6.1.4.1.5923.1.1.1.10
        FriendlyName=eduPersonTargetedID

        values is a list of items of type str or dict. When an item is a
        dictionary it has the keys: "NameQualifier", "SPNameQualifier", and
        "text".

        Returns a list of AttributeValue instances of NameID elements.
        """
        ...
    


class AttributeConverterNOOP(AttributeConverter):
    """Does a NOOP conversion, that is no conversion is made"""
    def __init__(self, name_format=...) -> None:
        ...
    
    def to_(self, attrvals): # -> list[Any]:
        """Create a list of Attribute instances.

        :param attrvals: A dictionary of attributes and values
        :return: A list of Attribute instances
        """
        ...
    


