"""
This type stub file was generated by pyright.
"""

from saml2.entity import Entity

"""
Contains a class that can do SAML ECP Authentication for other python
programs.
"""
SERVICE = ...
PAOS_HEADER_INFO = ...
logger = ...
class Client(Entity):
    """ECP-aware client that works on the client (application) side.

    You can use this class when you want to login user through
    ECP-aware SP and IdP.
    """
    def __init__(self, user, passwd, sp=..., idp=..., metadata_file=..., xmlsec_binary=..., verbose=..., ca_certs=..., disable_ssl_certificate_validation=..., key_file=..., cert_file=..., config=...) -> None:
        """
        :param user: user name
        :param passwd: user password
        :param sp: The SP URL
        :param idp: The IdP PAOS endpoint
        :param metadata_file: Where the metadata file is if used
        :param xmlsec_binary: Where the xmlsec1 binary can be found (*)
        :param verbose: Chatty or not
        :param ca_certs: is the path of a file containing root CA certificates
            for SSL server certificate validation (*)
        :param disable_ssl_certificate_validation: If
            disable_ssl_certificate_validation is true, SSL cert validation
            will not be performed (*)
        :param key_file: Private key filename (*)
        :param cert_file: Certificate filename (*)
        :param config: Config() instance, overrides all the parameters marked
            with an asterisk (*) above
        """
        ...
    
    def phase2(self, authn_request, rc_url, idp_entity_id, headers=..., sign=..., sign_alg=..., **kwargs):
        """
        Doing the second phase of the ECP conversation, the conversation
        with the IdP happens.

        :param authn_request: The AuthenticationRequest
        :param rc_url: The assertion consumer service url of the SP
        :param idp_entity_id: The EntityID of the IdP
        :param headers: Possible extra headers
        :param sign: If the message should be signed
        :return: The response from the IdP
        """
        ...
    
    @staticmethod
    def parse_sp_ecp_response(respdict): # -> dict[str, Any]:
        ...
    
    def ecp_conversation(self, respdict, idp_entity_id=...): # -> None:
        """

        :param respdict:
        :param idp_entity_id:
        :return:
        """
        ...
    
    @staticmethod
    def add_paos_headers(headers=...): # -> list[tuple[Any, Any]] | list[Any]:
        ...
    
    def operation(self, url, idp_entity_id, op, **opargs): # -> Response:
        """
        This is the method that should be used by someone that wants
        to authenticate using SAML ECP

        :param url: The page that access is sought for
        :param idp_entity_id: The entity ID of the IdP that should be
            used for authentication
        :param op: Which HTTP operation (GET/POST/PUT/DELETE)
        :param opargs: Arguments to the HTTP call
        :return: The page
        """
        ...
    
    def delete(self, url=..., idp_entity_id=...): # -> Response:
        ...
    
    def get(self, url=..., idp_entity_id=..., headers=...): # -> Response:
        ...
    
    def post(self, url=..., data=..., idp_entity_id=..., headers=...): # -> Response:
        ...
    
    def put(self, url=..., data=..., idp_entity_id=..., headers=...): # -> Response:
        ...
    


