"""
This type stub file was generated by pyright.
"""

from typing import Any, Dict, Literal, Optional, TYPE_CHECKING, Union
from sqlalchemy import Column, Index, Table
from sqlalchemy.sql.schema import Constraint
from sqlalchemy.engine import Dialect
from sqlalchemy.sql.elements import ColumnClause
from sqlalchemy.sql.functions import Function
from sqlalchemy.sql.type_api import TypeEngine
from ..ddl.impl import DefaultImpl

if TYPE_CHECKING:
    ...
class BatchOperationsImpl:
    def __init__(self, operations, table_name, schema, recreate, copy_from, table_args, table_kwargs, reflect_args, reflect_kwargs, naming_convention, partial_reordering) -> None:
        ...
    
    @property
    def dialect(self) -> Dialect:
        ...
    
    @property
    def impl(self) -> DefaultImpl:
        ...
    
    def flush(self) -> None:
        ...
    
    def alter_column(self, *arg, **kw) -> None:
        ...
    
    def add_column(self, *arg, **kw) -> None:
        ...
    
    def drop_column(self, *arg, **kw) -> None:
        ...
    
    def add_constraint(self, const: Constraint) -> None:
        ...
    
    def drop_constraint(self, const: Constraint) -> None:
        ...
    
    def rename_table(self, *arg, **kw): # -> None:
        ...
    
    def create_index(self, idx: Index, **kw: Any) -> None:
        ...
    
    def drop_index(self, idx: Index, **kw: Any) -> None:
        ...
    
    def create_table_comment(self, table): # -> None:
        ...
    
    def drop_table_comment(self, table): # -> None:
        ...
    
    def create_table(self, table):
        ...
    
    def drop_table(self, table):
        ...
    
    def create_column_comment(self, column): # -> None:
        ...
    


class ApplyBatchImpl:
    def __init__(self, impl: DefaultImpl, table: Table, table_args: tuple, table_kwargs: Dict[str, Any], reflected: bool, partial_reordering: tuple = ...) -> None:
        ...
    
    def alter_column(self, table_name: str, column_name: str, nullable: Optional[bool] = ..., server_default: Optional[Union[Function[Any], str, bool]] = ..., name: Optional[str] = ..., type_: Optional[TypeEngine] = ..., autoincrement: Optional[Union[bool, Literal["auto"]]] = ..., comment: Union[str, Literal[False]] = ..., **kw) -> None:
        ...
    
    def add_column(self, table_name: str, column: Column[Any], insert_before: Optional[str] = ..., insert_after: Optional[str] = ..., **kw) -> None:
        ...
    
    def drop_column(self, table_name: str, column: Union[ColumnClause[Any], Column[Any]], **kw) -> None:
        ...
    
    def create_column_comment(self, column): # -> None:
        """the batch table creation function will issue create_column_comment
        on the real "impl" as part of the create table process.

        That is, the Column object will have the comment on it already,
        so when it is received by add_column() it will be a normal part of
        the CREATE TABLE and doesn't need an extra step here.

        """
        ...
    
    def create_table_comment(self, table): # -> None:
        """the batch table creation function will issue create_table_comment
        on the real "impl" as part of the create table process.

        """
        ...
    
    def drop_table_comment(self, table): # -> None:
        """the batch table creation function will issue drop_table_comment
        on the real "impl" as part of the create table process.

        """
        ...
    
    def add_constraint(self, const: Constraint) -> None:
        ...
    
    def drop_constraint(self, const: Constraint) -> None:
        ...
    
    def create_index(self, idx: Index) -> None:
        ...
    
    def drop_index(self, idx: Index) -> None:
        ...
    
    def rename_table(self, *arg, **kw):
        ...
    


