"""
This type stub file was generated by pyright.
"""

from saml2 import SAMLError
from saml2.httpbase import HTTPBase

logger = ...
__author__ = ...
ARTIFACT_TYPECODE = ...
SERVICE2MESSAGE = ...
class UnknownBinding(SAMLError):
    ...


def create_artifact(entity_id, message_handle, endpoint_index=...): # -> str:
    """
    SAML_artifact   := B64(TypeCode EndpointIndex RemainingArtifact)
    TypeCode        := Byte1Byte2
    EndpointIndex   := Byte1Byte2

    RemainingArtifact := SourceID MessageHandle
    SourceID          := 20-byte_sequence
    MessageHandle     := 20-byte_sequence

    :param entity_id:
    :param message_handle:
    :param endpoint_index:
    :return:
    """
    ...

class Entity(HTTPBase):
    def __init__(self, entity_type, config=..., config_file=..., virtual_organization=..., msg_cb=...) -> None:
        ...
    
    def reload_metadata(self, metadata_conf): # -> bool:
        """
        Reload metadata configuration.

        Load a new metadata configuration as defined by metadata_conf (by
        passing this to Config.load_metadata) and make this entity (as well as
        subordinate objects with own metadata reference) use the new metadata.

        The structure of metadata_conf is the same as the 'metadata' entry in
        the configuration passed to saml2.Config.

        param metadata_conf: Metadata configuration as passed to Config.load_metadata
        return: True if successfully reloaded
        """
        ...
    
    def apply_binding(self, binding, msg_str, destination=..., relay_state=..., response=..., sign=..., sigalg=..., **kwargs): # -> dict[str, Any] | dict[str, str]:
        """
        Construct the necessary HTTP arguments dependent on Binding

        :param binding: Which binding to use
        :param msg_str: The return message as a string (XML) if the message is
            to be signed it MUST contain the signature element.
        :param destination: Where to send the message
        :param relay_state: Relay_state if provided
        :param response: Which type of message this is
        :param kwargs: response type specific arguments
        :return: A dictionary
        """
        ...
    
    def pick_binding(self, service, bindings=..., descr_type=..., request=..., entity_id=...): # -> tuple[Any | str, Any] | tuple[Any | str, Any | None]:
        ...
    
    def message_args(self, message_id=...): # -> dict[str, Any]:
        ...
    
    def response_args(self, message, bindings=..., descr_type=...): # -> dict[str, Any]:
        """

        :param message: The message to which a reply is constructed
        :param bindings: Which bindings can be used.
        :param descr_type: Type of descriptor (spssp, idpsso, )
        :return: Dictionary
        """
        ...
    
    @staticmethod
    def unravel(txt, binding, msgtype=...): # -> bytes | Any:
        """
        Will unpack the received text. Depending on the context the original
         response may have been transformed before transmission.
        :param txt:
        :param binding:
        :param msgtype:
        :return:
        """
        ...
    
    @staticmethod
    def parse_soap_message(text): # -> dict[str, Any]:
        """

        :param text: The SOAP message
        :return: A dictionary with two keys "body" and "header"
        """
        ...
    
    @staticmethod
    def unpack_soap_message(text): # -> dict[str, Any]:
        """
        Picks out the parts of the SOAP message, body and headers apart
        :param text: The SOAP message
        :return: A dictionary with two keys "body"/"header"
        """
        ...
    
    def sign(self, msg, mid=..., to_sign=..., sign_prepare=..., sign_alg=..., digest_alg=...):
        ...
    
    def has_encrypt_cert_in_metadata(self, sp_entity_id): # -> bool:
        """Verifies if the metadata contains encryption certificates.

        :param sp_entity_id: Entity ID for the calling service provider.
        :return: True if encrypt cert exists in metadata, otherwise False.
        """
        ...
    
    @staticmethod
    def srv2typ(service): # -> str | None:
        ...
    
    def create_error_response(self, in_response_to, destination, info, sign=..., issuer=..., sign_alg=..., digest_alg=..., **kwargs):
        """Create a error response.

        :param in_response_to: The identifier of the message this is a response
            to.
        :param destination: The intended recipient of this message
        :param info: Either an Exception instance or a 2-tuple consisting of
            error code and descriptive text
        :param sign: Whether the response should be signed or not
        :param issuer: The issuer of the response
        :param kwargs: To capture key,value pairs I don't care about
        :return: A response instance
        """
        ...
    
    def create_logout_request(self, destination, issuer_entity_id, subject_id=..., name_id=..., reason=..., expire=..., message_id=..., consent=..., extensions=..., sign=..., session_indexes=..., sign_alg=..., digest_alg=...): # -> tuple[Any, Any]:
        """Constructs a LogoutRequest

        :param destination: Destination of the request
        :param issuer_entity_id: The entity ID of the IdP the request is
            target at.
        :param subject_id: The identifier of the subject
        :param name_id: A NameID instance identifying the subject
        :param reason: An indication of the reason for the logout, in the
            form of a URI reference.
        :param expire: The time at which the request expires,
            after which the recipient may discard the message.
        :param message_id: Request identifier
        :param consent: Whether the principal have given her consent
        :param extensions: Possible extensions
        :param sign: Whether the query should be signed or not.
        :param session_indexes: SessionIndex instances or just values
        :return: A LogoutRequest instance
        """
        ...
    
    def create_logout_response(self, request, bindings=..., status=..., sign=..., issuer=..., sign_alg=..., digest_alg=...):
        """Create a LogoutResponse.

        :param request: The request this is a response to
        :param bindings: Which bindings that can be used for the response
            If None the preferred bindings are gathered from the configuration
        :param status: The return status of the response operation
            If None the operation is regarded as a Success.
        :param issuer: The issuer of the message
        :return: HTTP args
        """
        ...
    
    def create_artifact_resolve(self, artifact, destination, sessid, consent=..., extensions=..., sign=..., sign_alg=..., digest_alg=...): # -> tuple[Any, Any]:
        """
        Create a ArtifactResolve request

        :param artifact:
        :param destination:
        :param sessid: session id
        :param consent:
        :param extensions:
        :param sign:
        :return: The request message
        """
        ...
    
    def create_artifact_response(self, request, artifact, bindings=..., status=..., sign=..., issuer=..., sign_alg=..., digest_alg=...):
        """
        Create an ArtifactResponse
        :return:
        """
        ...
    
    def create_manage_name_id_request(self, destination, message_id=..., consent=..., extensions=..., sign=..., name_id=..., new_id=..., encrypted_id=..., new_encrypted_id=..., terminate=..., sign_alg=..., digest_alg=...): # -> tuple[Any, Any]:
        """

        :param destination:
        :param message_id:
        :param consent:
        :param extensions:
        :param sign:
        :param name_id:
        :param new_id:
        :param encrypted_id:
        :param new_encrypted_id:
        :param terminate:
        :return:
        """
        ...
    
    def parse_manage_name_id_request(self, xmlstr, binding=...): # -> None:
        """Deal with a LogoutRequest

        :param xmlstr: The response as a xml string
        :param binding: What type of binding this message came through.
        :return: None if the reply doesn't contain a valid SAML LogoutResponse,
            otherwise the reponse if the logout was successful and None if it
            was not.
        """
        ...
    
    def create_manage_name_id_response(self, request, bindings=..., status=..., sign=..., issuer=..., sign_alg=..., digest_alg=..., **kwargs):
        ...
    
    def parse_manage_name_id_request_response(self, string, binding=...): # -> None:
        ...
    
    def parse_logout_request_response(self, xmlstr, binding=...): # -> None:
        ...
    
    def parse_logout_request(self, xmlstr, binding=..., relay_state=..., sigalg=..., signature=...): # -> None:
        """Deal with a LogoutRequest

        :param xmlstr: The response as a xml string
        :param binding: What type of binding this message came through.
        :return: None if the reply doesn't contain a valid SAML LogoutResponse,
            otherwise the reponse if the logout was successful and None if it
            was not.
        """
        ...
    
    def use_artifact(self, message, endpoint_index=...): # -> str:
        """

        :param message:
        :param endpoint_index:
        :return:
        """
        ...
    
    def artifact2destination(self, artifact, descriptor): # -> None:
        """
        Translate an artifact into a receiver location

        :param artifact: The Base64 encoded SAML artifact
        :return:
        """
        ...
    
    def artifact2message(self, artifact, descriptor, sign=..., sign_alg=..., digest_alg=...): # -> Response:
        """

        :param artifact: The Base64 encoded SAML artifact as sent over the net
        :param descriptor: The type of entity on the other side
        :param sign: Whether ArtifactResolve should be signed or not
        :return: A SAML message (request/response)
        """
        ...
    
    def parse_artifact_resolve(self, txt, **kwargs): # -> None:
        """
        Always done over SOAP

        :param txt: The SOAP enveloped ArtifactResolve
        :param kwargs:
        :return: An ArtifactResolve instance
        """
        ...
    
    def parse_artifact_resolve_response(self, xmlstr):
        ...
    


