"""
This type stub file was generated by pyright.
"""

import typing as t
from contextvars import ContextVar
from starlette.types import ASGIApp, Receive, Scope, Send
from connexion.middleware import SpecMiddleware
from connexion.middleware.abstract import AbstractSpecAPI
from connexion.options import SwaggerUIOptions
from connexion.spec import Specification

logger = ...
_original_scope: ContextVar[Scope] = ...
class SwaggerUIAPI(AbstractSpecAPI):
    def __init__(self, *args, default: ASGIApp, swagger_ui_options: t.Optional[SwaggerUIOptions] = ..., **kwargs) -> None:
        ...
    
    @staticmethod
    def normalize_string(string): # -> str:
        ...
    
    def add_openapi_json(self): # -> None:
        """
        Adds openapi json to {base_path}/openapi.json
             (or {base_path}/swagger.json for swagger2)
        """
        ...
    
    def add_openapi_yaml(self): # -> None:
        """
        Adds openapi json to {base_path}/openapi.json
             (or {base_path}/swagger.json for swagger2)
        """
        ...
    
    def add_swagger_ui(self): # -> None:
        """
        Adds swagger ui to {base_path}/ui/
        """
        ...
    


class SwaggerUIMiddleware(SpecMiddleware):
    def __init__(self, app: ASGIApp) -> None:
        """Middleware that hosts a swagger UI.

        :param app: app to wrap in middleware.
        """
        ...
    
    def add_api(self, specification: Specification, base_path: t.Optional[str] = ..., arguments: t.Optional[dict] = ..., **kwargs) -> None:
        """Add an API to the router based on a OpenAPI spec.

        :param specification: OpenAPI spec.
        :param base_path: Base path where to add this API.
        :param arguments: Jinja arguments to replace in the spec.
        """
        ...
    
    async def __call__(self, scope: Scope, receive: Receive, send: Send) -> None:
        ...
    
    async def default_fn(self, _scope: Scope, receive: Receive, send: Send) -> None:
        """
        Callback to call next app as default when no matching route is found.

        Unfortunately we cannot just pass the next app as default, since the router manipulates
        the scope when descending into mounts, losing information about the base path. Therefore,
        we use the original scope instead.

        This is caused by https://github.com/encode/starlette/issues/1336.
        """
        ...
    


