"""
This type stub file was generated by pyright.
"""

import abc

"""
This module defines an AbstractOperation class which implements an abstract Operation interface
and functionality shared between Swagger 2 and OpenAPI 3 specifications.
"""
logger = ...
DEFAULT_MIMETYPE = ...
class AbstractOperation(metaclass=abc.ABCMeta):
    """
    An API routes requests to an Operation by a (path, method) pair.
    The operation uses a resolver to resolve its handler function.
    We use the provided spec to do a bunch of heavy lifting before
    (and after) we call security_schemes handler.
    The registered handler function ends up looking something like::

        @secure_endpoint
        @validate_inputs
        @deserialize_function_inputs
        @serialize_function_outputs
        @validate_outputs
        def user_provided_handler_function(important, stuff):
            if important:
                serious_business(stuff)
    """
    def __init__(self, method, path, operation, resolver, app_security=..., security_schemes=..., randomize_endpoint=..., uri_parser_class=...) -> None:
        """
        :param method: HTTP method
        :type method: str
        :param path:
        :type path: str
        :param operation: swagger operation object
        :type operation: dict
        :param resolver: Callable that maps operationID to a function
        :param app_security: list of security rules the application uses by default
        :type app_security: list
        :param security_schemes: `Security Definitions Object
            <https://github.com/swagger-api/swagger-spec/blob/master/versions/2.0.md#security-definitions-object>`_
        :type security_schemes: dict
        :param randomize_endpoint: number of random characters to append to operation name
        :type randomize_endpoint: integer
        :param uri_parser_class: class to use for uri parsing
        :type uri_parser_class: AbstractURIParser
        """
        ...
    
    @classmethod
    @abc.abstractmethod
    def from_spec(cls, spec, *args, path, method, resolver, **kwargs): # -> None:
        ...
    
    @property
    def method(self): # -> Any:
        """
        The HTTP method for this operation (ex. GET, POST)
        """
        ...
    
    @property
    def request_body(self): # -> None:
        """The request body for this operation"""
        ...
    
    @property
    def is_request_body_defined(self) -> bool:
        """Whether the request body is defined for this operation"""
        ...
    
    @property
    def path(self): # -> Any:
        """
        The path of the operation, relative to the API base path
        """
        ...
    
    @property
    def security(self):
        ...
    
    @property
    def security_schemes(self): # -> None:
        ...
    
    @property
    def responses(self):
        """
        Returns the responses for this operation
        """
        ...
    
    @property
    def operation_id(self):
        """
        The operation id used to identify the operation internally to the app
        """
        ...
    
    @property
    def randomize_endpoint(self): # -> None:
        """
        number of random digits to generate and append to the operation_id.
        """
        ...
    
    @property
    def router_controller(self):
        """
        The router controller to use (python module where handler functions live)
        """
        ...
    
    @property
    @abc.abstractmethod
    def parameters(self): # -> None:
        """
        Returns the parameters for this operation
        """
        ...
    
    @property
    @abc.abstractmethod
    def produces(self): # -> None:
        """
        Content-Types that the operation produces
        """
        ...
    
    @property
    @abc.abstractmethod
    def consumes(self): # -> None:
        """
        Content-Types that the operation consumes
        """
        ...
    
    @abc.abstractmethod
    def body_name(self, content_type: str) -> str:
        """
        Name of the body in the spec.
        """
        ...
    
    @abc.abstractmethod
    def body_schema(self, content_type: str = ...) -> dict:
        """
        The body schema definition for this operation.
        """
        ...
    
    @abc.abstractmethod
    def body_definition(self, content_type: str = ...) -> dict:
        """
        The body definition for this operation.
        :rtype: dict
        """
        ...
    
    def response_definition(self, status_code=..., content_type=...):
        """
        response definition for this endpoint
        """
        ...
    
    @abc.abstractmethod
    def response_schema(self, status_code=..., content_type=...): # -> None:
        """
        response schema for this endpoint
        """
        ...
    
    @abc.abstractmethod
    def example_response(self, status_code=..., content_type=...): # -> None:
        """
        Returns an example from the spec
        """
        ...
    
    @abc.abstractmethod
    def get_path_parameter_types(self): # -> None:
        """
        Returns the types for parameters in the path
        """
        ...
    
    @abc.abstractmethod
    def with_definitions(self, schema): # -> None:
        """
        Returns the given schema, but with the definitions from the spec
        attached. This allows any remaining references to be resolved by a
        validator (for example).
        """
        ...
    
    def get_mimetype(self): # -> Literal['application/json']:
        """
        If the endpoint has no 'produces' then the default is
        'application/json'.

        :rtype str
        """
        ...
    
    @property
    def uri_parser_class(self): # -> None:
        """
        The uri parser class for this operation.
        """
        ...
    
    @property
    def function(self):
        """
        Resolved function.

        :rtype: types.FunctionType
        """
        ...
    


