"""
This type stub file was generated by pyright.
"""

import abc
import typing as t
from collections.abc import Mapping
from jsonschema import Draft4Validator
from .operations import AbstractOperation, OpenAPIOperation, Swagger2Operation

"""
This module defines Python interfaces for OpenAPI specifications.
"""
validate_properties = Draft4Validator.VALIDATORS["properties"]
def create_spec_validator(spec: dict) -> Draft4Validator:
    """Create a Validator to validate an OpenAPI spec against the OpenAPI schema.

    :param spec: specification to validate
    """
    ...

NO_SPEC_VERSION_ERR_MSG = ...
def canonical_base_path(base_path):
    """
    Make given "basePath" a canonical base URL which can be prepended to paths starting with "/".
    """
    ...

class Specification(Mapping):
    operation_cls: t.Type[AbstractOperation]
    def __init__(self, raw_spec, *, base_uri=...) -> None:
        ...
    
    def get_path_params(self, path): # -> list[Any]:
        ...
    
    def get_operation(self, path, method): # -> Mapping[Any, Any] | list[Any] | tuple[Any, ...]:
        ...
    
    @property
    def raw(self): # -> Any:
        ...
    
    @property
    def version(self): # -> tuple[int, ...]:
        ...
    
    @property
    def security(self): # -> None:
        ...
    
    @property
    @abc.abstractmethod
    def security_schemes(self):
        ...
    
    def __getitem__(self, k):
        ...
    
    def __iter__(self): # -> Iterator[Any]:
        ...
    
    def __len__(self): # -> int:
        ...
    
    @classmethod
    def from_file(cls, spec, *, arguments=..., base_uri=...): # -> Swagger2Specification | OpenAPISpecification:
        """
        Takes in a path to a YAML file, and returns a Specification
        """
        ...
    
    @classmethod
    def from_dict(cls, spec, *, base_uri=...): # -> Swagger2Specification | OpenAPISpecification:
        """
        Takes in a dictionary, and returns a Specification
        """
        ...
    
    def clone(self): # -> Self:
        ...
    
    @classmethod
    def load(cls, spec, *, arguments=...): # -> Swagger2Specification | OpenAPISpecification:
        ...
    
    def with_base_path(self, base_path): # -> Self:
        ...
    
    @property
    @abc.abstractmethod
    def base_path(self): # -> None:
        ...
    
    @base_path.setter
    @abc.abstractmethod
    def base_path(self, base_path): # -> None:
        ...
    


class Swagger2Specification(Specification):
    """Python interface for a Swagger 2 specification."""
    yaml_name = ...
    operation_cls = Swagger2Operation
    openapi_schema = ...
    @property
    def produces(self):
        ...
    
    @property
    def consumes(self):
        ...
    
    @property
    def definitions(self):
        ...
    
    @property
    def parameter_definitions(self):
        ...
    
    @property
    def response_definitions(self):
        ...
    
    @property
    def security_schemes(self): # -> dict[Any, Any]:
        ...
    
    @property
    def base_path(self): # -> str:
        ...
    
    @base_path.setter
    def base_path(self, base_path): # -> None:
        ...
    


class OpenAPISpecification(Specification):
    """Python interface for an OpenAPI 3 specification."""
    yaml_name = ...
    operation_cls = OpenAPIOperation
    openapi_schema = ...
    @property
    def security_schemes(self):
        ...
    
    @property
    def components(self):
        ...
    
    @property
    def base_path(self): # -> LiteralString:
        ...
    
    @base_path.setter
    def base_path(self, base_path): # -> None:
        ...
    


