#include <cassert>
#include <vector>

#include "types.hpp"

/**
 * The following pruning parameters are taken by using the Pruner from [1],
 * bases are simulated as having the theoretical slope of BKZ-(beta-2), in
 * attempt at predicting bases shape during progressive-BKZ
 *
 *  Generated using the script ./find_pruning_params.py. 
 * 
 */
const std::vector<FT> pruning_params[MAX_ENUM_N/2 + 1] = {
    {}, // dummy values
{ 1.0000, 0.0001 }, // BKZ-2, p=1.000000
{ 1.0000, 0.7347, 0.4695, 0.0395 }, // BKZ-4, p=0.288170
{ 1.0000, 0.8297, 0.6595, 0.4725, 0.3040, 0.2369 }, // BKZ-6, p=0.394078
{ 1.0000, 0.9040, 0.8081, 0.6523, 0.4992, 0.3503, 0.2606, 0.2169 }, // BKZ-8, p=0.339650
{ 1.0000, 1.0000, 0.9966, 0.9966, 0.5197, 0.5197, 0.3264, 0.3264, 0.3190, 0.3190 }, // BKZ-10, p=0.250344
{ 1.0000, 1.0000, 0.9900, 0.9900, 0.6683, 0.6683, 0.4022, 0.4022, 0.3848, 0.3848, 0.3848, 0.3848 }, // BKZ-12, p=0.250184
{ 1.0000, 1.0000, 1.0000, 0.9452, 0.8287, 0.7184, 0.5753, 0.5091, 0.4316, 0.3494, 0.3046, 0.2968, 0.2946, 0.2930 }, // BKZ-14, p=0.248952
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9305, 0.9305, 0.5958, 0.5958, 0.4306, 0.4306, 0.3598, 0.3598, 0.3564, 0.3564, 0.3564, 0.3564 }, // BKZ-16, p=0.250227
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9279, 0.8667, 0.7565, 0.6663, 0.5543, 0.4969, 0.4252, 0.3901, 0.3255, 0.3167, 0.3133, 0.3115, 0.3096, 0.3078 }, // BKZ-18, p=0.249684
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9307, 0.8839, 0.8004, 0.7443, 0.6453, 0.5792, 0.4931, 0.4417, 0.3841, 0.3342, 0.3306, 0.3299, 0.3299, 0.3299, 0.3299, 0.3299 }, // BKZ-20, p=0.249506
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9708, 0.9357, 0.8518, 0.7911, 0.7070, 0.6378, 0.5536, 0.5053, 0.4485, 0.4075, 0.3581, 0.3247, 0.2910, 0.2910, 0.2910, 0.2910, 0.2910, 0.2910 }, // BKZ-22, p=0.249768
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9725, 0.9691, 0.8760, 0.8735, 0.7544, 0.7519, 0.6280, 0.6236, 0.5157, 0.5077, 0.4169, 0.4161, 0.3304, 0.3176, 0.2547, 0.2490, 0.1783, 0.1741, 0.1680, 0.1679 }, // BKZ-24, p=0.249728
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9769, 0.9681, 0.8912, 0.8891, 0.7798, 0.7759, 0.6649, 0.6580, 0.5590, 0.5495, 0.4639, 0.4540, 0.3804, 0.3706, 0.3068, 0.2969, 0.2422, 0.2418, 0.1881, 0.1777, 0.1571, 0.1571 }, // BKZ-26, p=0.243917
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9812, 0.9773, 0.9050, 0.9024, 0.8053, 0.8053, 0.6992, 0.6972, 0.5969, 0.5944, 0.5061, 0.5018, 0.4260, 0.4201, 0.3561, 0.3479, 0.2972, 0.2849, 0.2405, 0.2284, 0.1852, 0.1787, 0.1673, 0.1673 }, // BKZ-28, p=0.247274
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9847, 0.9806, 0.9182, 0.9156, 0.8292, 0.8269, 0.7291, 0.7272, 0.6322, 0.6307, 0.5438, 0.5421, 0.4656, 0.4625, 0.3978, 0.3919, 0.3364, 0.3295, 0.2821, 0.2729, 0.2338, 0.2219, 0.1909, 0.1767, 0.1458, 0.1449 }, // BKZ-30, p=0.244716
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9885, 0.9885, 0.9292, 0.9273, 0.8484, 0.8456, 0.7540, 0.7504, 0.6631, 0.6579, 0.5787, 0.5721, 0.5014, 0.4946, 0.4322, 0.4255, 0.3711, 0.3642, 0.3165, 0.3092, 0.2681, 0.2593, 0.2251, 0.2143, 0.1887, 0.1762, 0.1488, 0.1274 }, // BKZ-32, p=0.234024
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9523, 0.9523, 0.8683, 0.8683, 0.7915, 0.7915, 0.7073, 0.7073, 0.6227, 0.6227, 0.5357, 0.5357, 0.4749, 0.4749, 0.4107, 0.4107, 0.3527, 0.3527, 0.2998, 0.2998, 0.2515, 0.2515, 0.2078, 0.2078, 0.1729, 0.1729, 0.1705, 0.1705 }, // BKZ-34, p=0.249459
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9947, 0.9903, 0.9493, 0.9453, 0.8848, 0.8809, 0.8000, 0.7977, 0.7174, 0.7143, 0.6389, 0.6350, 0.5656, 0.5616, 0.4991, 0.4951, 0.4396, 0.4354, 0.3864, 0.3816, 0.3387, 0.3326, 0.2962, 0.2885, 0.2584, 0.2490, 0.2270, 0.2173, 0.1947, 0.1880, 0.1598, 0.1470 }, // BKZ-36, p=0.242894
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9935, 0.9918, 0.9622, 0.9563, 0.8949, 0.8921, 0.8212, 0.8186, 0.7432, 0.7409, 0.6665, 0.6648, 0.5948, 0.5934, 0.5292, 0.5277, 0.4693, 0.4675, 0.4146, 0.4121, 0.3662, 0.3631, 0.3226, 0.3188, 0.2837, 0.2787, 0.2491, 0.2424, 0.2202, 0.2119, 0.1918, 0.1902, 0.1593, 0.1591 }, // BKZ-38, p=0.241266
{ 1.0000, 1.0000, 1.0000, 1.0000, 0.9945, 0.9945, 0.9671, 0.9615, 0.9091, 0.9065, 0.8403, 0.8378, 0.7662, 0.7640, 0.6926, 0.6910, 0.6233, 0.6218, 0.5592, 0.5576, 0.5001, 0.4983, 0.4462, 0.4440, 0.3977, 0.3951, 0.3541, 0.3509, 0.3148, 0.3106, 0.2798, 0.2741, 0.2488, 0.2410, 0.2149, 0.2139, 0.1997, 0.1970, 0.1874, 0.1874 }, // BKZ-40, p=0.249724
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9999, 0.9709, 0.9673, 0.9223, 0.9187, 0.8560, 0.8536, 0.7858, 0.7829, 0.7162, 0.7126, 0.6490, 0.6453, 0.5860, 0.5823, 0.5279, 0.5242, 0.4747, 0.4710, 0.4261, 0.4223, 0.3822, 0.3780, 0.3423, 0.3375, 0.3061, 0.3002, 0.2731, 0.2662, 0.2408, 0.2387, 0.2174, 0.2088, 0.2057, 0.2056, 0.2055, 0.2054 }, // BKZ-42, p=0.249948
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9775, 0.9750, 0.9315, 0.9279, 0.8708, 0.8650, 0.8049, 0.7974, 0.7378, 0.7299, 0.6727, 0.6648, 0.6110, 0.6035, 0.5535, 0.5464, 0.5007, 0.4939, 0.4524, 0.4459, 0.4082, 0.4017, 0.3682, 0.3618, 0.3318, 0.3248, 0.2984, 0.2907, 0.2696, 0.2696, 0.2378, 0.2366, 0.2156, 0.2151, 0.2145, 0.2145, 0.2145, 0.2145 }, // BKZ-44, p=0.248877
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9818, 0.9793, 0.9356, 0.9356, 0.8842, 0.8769, 0.8216, 0.8130, 0.7573, 0.7483, 0.6941, 0.6854, 0.6337, 0.6255, 0.5772, 0.5696, 0.5250, 0.5179, 0.4771, 0.4706, 0.4329, 0.4268, 0.3929, 0.3869, 0.3561, 0.3499, 0.3224, 0.3158, 0.2917, 0.2845, 0.2652, 0.2581, 0.2407, 0.2398, 0.2254, 0.2253, 0.2253, 0.2253, 0.2253, 0.2253 }, // BKZ-46, p=0.249954
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9896, 0.9840, 0.9498, 0.9429, 0.8881, 0.8881, 0.8386, 0.8260, 0.7763, 0.7634, 0.7152, 0.7026, 0.6567, 0.6446, 0.6015, 0.5900, 0.5500, 0.5391, 0.5025, 0.4925, 0.4594, 0.4508, 0.4159, 0.4072, 0.3798, 0.3719, 0.3459, 0.3384, 0.3146, 0.3086, 0.2858, 0.2760, 0.2582, 0.2505, 0.2479, 0.2479, 0.2479, 0.2479, 0.2479, 0.2479, 0.2479, 0.2479 }, // BKZ-48, p=0.249836
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9996, 0.9683, 0.9650, 0.9234, 0.9034, 0.8593, 0.8418, 0.7963, 0.7813, 0.7358, 0.7221, 0.6781, 0.6648, 0.6227, 0.6092, 0.5692, 0.5564, 0.5212, 0.5133, 0.4835, 0.4750, 0.4391, 0.4300, 0.4044, 0.3950, 0.3679, 0.3594, 0.3351, 0.3271, 0.3017, 0.2909, 0.2743, 0.2739, 0.2602, 0.2591, 0.2587, 0.2583, 0.2579, 0.2575, 0.2571, 0.2566, 0.2562, 0.2558 }, // BKZ-50, p=0.249867
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9899, 0.9898, 0.9588, 0.9559, 0.9138, 0.9106, 0.8600, 0.8567, 0.8020, 0.7987, 0.7448, 0.7416, 0.6872, 0.6843, 0.6313, 0.6313, 0.5822, 0.5799, 0.5343, 0.5325, 0.4909, 0.4893, 0.4512, 0.4497, 0.4134, 0.4123, 0.3800, 0.3792, 0.3497, 0.3488, 0.3232, 0.3209, 0.2992, 0.2949, 0.2772, 0.2712, 0.2510, 0.2482, 0.2417, 0.2417, 0.2417, 0.2417, 0.2417, 0.2417, 0.2417, 0.2417 }, // BKZ-52, p=0.234962
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9917, 0.9892, 0.9645, 0.9619, 0.9232, 0.9202, 0.8722, 0.8692, 0.8178, 0.8145, 0.7619, 0.7587, 0.7069, 0.7038, 0.6537, 0.6509, 0.6029, 0.6004, 0.5554, 0.5554, 0.5112, 0.5096, 0.4718, 0.4704, 0.4353, 0.4340, 0.4002, 0.3991, 0.3694, 0.3682, 0.3415, 0.3394, 0.3165, 0.3130, 0.2939, 0.2888, 0.2692, 0.2667, 0.2504, 0.2501, 0.2401, 0.2401, 0.2401, 0.2401, 0.2401, 0.2401, 0.2401, 0.2401 }, // BKZ-54, p=0.237040
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9948, 0.9946, 0.9672, 0.9672, 0.9312, 0.9286, 0.8836, 0.8809, 0.8315, 0.8289, 0.7780, 0.7753, 0.7248, 0.7220, 0.6731, 0.6703, 0.6239, 0.6212, 0.5766, 0.5743, 0.5333, 0.5314, 0.4917, 0.4902, 0.4554, 0.4547, 0.4206, 0.4193, 0.3894, 0.3882, 0.3607, 0.3590, 0.3347, 0.3321, 0.3111, 0.3074, 0.2874, 0.2858, 0.2707, 0.2645, 0.2503, 0.2501, 0.2500, 0.2500, 0.2500, 0.2500, 0.2500, 0.2500, 0.2500, 0.2500 }, // BKZ-56, p=0.241267
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9947, 0.9947, 0.9742, 0.9716, 0.9389, 0.9361, 0.8942, 0.8914, 0.8446, 0.8420, 0.7931, 0.7906, 0.7416, 0.7391, 0.6911, 0.6886, 0.6423, 0.6401, 0.5966, 0.5941, 0.5532, 0.5520, 0.5124, 0.5106, 0.4757, 0.4750, 0.4407, 0.4397, 0.4084, 0.4073, 0.3797, 0.3783, 0.3531, 0.3510, 0.3288, 0.3258, 0.3067, 0.3026, 0.2839, 0.2822, 0.2660, 0.2654, 0.2514, 0.2513, 0.2512, 0.2512, 0.2512, 0.2512, 0.2512, 0.2512, 0.2512, 0.2512 }, // BKZ-58, p=0.245958
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9962, 0.9962, 0.9779, 0.9752, 0.9458, 0.9426, 0.9039, 0.9008, 0.8569, 0.8541, 0.8072, 0.8046, 0.7573, 0.7554, 0.7082, 0.7056, 0.6603, 0.6585, 0.6151, 0.6133, 0.5717, 0.5697, 0.5314, 0.5313, 0.4956, 0.4942, 0.4589, 0.4577, 0.4285, 0.4274, 0.3995, 0.3970, 0.3709, 0.3693, 0.3459, 0.3435, 0.3225, 0.3194, 0.3010, 0.2970, 0.2803, 0.2758, 0.2681, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679, 0.2679 }, // BKZ-60, p=0.249855
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9993, 0.9989, 0.9810, 0.9774, 0.9519, 0.9471, 0.9129, 0.9078, 0.8678, 0.8632, 0.8198, 0.8159, 0.7710, 0.7678, 0.7229, 0.7201, 0.6761, 0.6738, 0.6314, 0.6294, 0.5891, 0.5872, 0.5491, 0.5475, 0.5118, 0.5103, 0.4773, 0.4759, 0.4450, 0.4436, 0.4152, 0.4138, 0.3875, 0.3860, 0.3619, 0.3602, 0.3383, 0.3362, 0.3168, 0.3141, 0.2974, 0.2936, 0.2854, 0.2854, 0.2652, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648, 0.2648 }, // BKZ-62, p=0.249548
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9996, 0.9837, 0.9794, 0.9576, 0.9510, 0.9212, 0.9139, 0.8782, 0.8714, 0.8319, 0.8261, 0.7844, 0.7797, 0.7372, 0.7335, 0.6913, 0.6884, 0.6472, 0.6449, 0.6054, 0.6035, 0.5659, 0.5644, 0.5283, 0.5266, 0.4948, 0.4936, 0.4617, 0.4601, 0.4323, 0.4307, 0.4038, 0.4022, 0.3776, 0.3758, 0.3534, 0.3513, 0.3315, 0.3291, 0.3125, 0.3109, 0.2983, 0.2895, 0.2823, 0.2823, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702, 0.2702 }, // BKZ-64, p=0.249417
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9998, 0.9848, 0.9800, 0.9634, 0.9545, 0.9315, 0.9206, 0.8903, 0.8795, 0.8451, 0.8355, 0.7987, 0.7903, 0.7524, 0.7452, 0.7072, 0.7010, 0.6635, 0.6583, 0.6218, 0.6174, 0.5824, 0.5785, 0.5454, 0.5419, 0.5108, 0.5077, 0.4785, 0.4756, 0.4478, 0.4446, 0.4201, 0.4169, 0.3942, 0.3910, 0.3703, 0.3667, 0.3482, 0.3442, 0.3333, 0.3333, 0.3098, 0.3049, 0.2919, 0.2911, 0.2785, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782, 0.2782 }, // BKZ-66, p=0.249798
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9907, 0.9902, 0.9800, 0.9800, 0.9359, 0.9308, 0.9035, 0.8904, 0.8571, 0.8467, 0.8113, 0.8026, 0.7660, 0.7586, 0.7216, 0.7154, 0.6786, 0.6734, 0.6375, 0.6330, 0.5984, 0.5945, 0.5615, 0.5582, 0.5270, 0.5240, 0.4946, 0.4919, 0.4637, 0.4608, 0.4359, 0.4329, 0.4096, 0.4067, 0.3854, 0.3822, 0.3630, 0.3593, 0.3423, 0.3380, 0.3230, 0.3182, 0.3033, 0.3019, 0.2864, 0.2854, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837, 0.2837 }, // BKZ-68, p=0.249974
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9995, 0.9902, 0.9889, 0.9832, 0.9800, 0.9444, 0.9399, 0.9140, 0.8990, 0.8688, 0.8559, 0.8237, 0.8124, 0.7792, 0.7693, 0.7355, 0.7270, 0.6931, 0.6858, 0.6523, 0.6461, 0.6136, 0.6082, 0.5769, 0.5722, 0.5425, 0.5384, 0.5102, 0.5067, 0.4788, 0.4749, 0.4511, 0.4471, 0.4244, 0.4209, 0.3999, 0.3960, 0.3770, 0.3729, 0.3559, 0.3514, 0.3362, 0.3314, 0.3171, 0.3148, 0.3029, 0.3023, 0.2889, 0.2886, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885, 0.2885 }, // BKZ-70, p=0.249247
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9913, 0.9881, 0.9805, 0.9800, 0.9800, 0.9800, 0.9268, 0.9161, 0.8853, 0.8688, 0.8364, 0.8240, 0.7914, 0.7814, 0.7484, 0.7399, 0.7068, 0.6995, 0.6666, 0.6603, 0.6282, 0.6228, 0.5917, 0.5870, 0.5573, 0.5531, 0.5249, 0.5212, 0.4947, 0.4916, 0.4651, 0.4613, 0.4392, 0.4355, 0.4142, 0.4107, 0.3912, 0.3875, 0.3698, 0.3657, 0.3500, 0.3454, 0.3316, 0.3265, 0.3119, 0.3092, 0.2958, 0.2946, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929, 0.2929 }, // BKZ-72, p=0.249934
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9998, 0.9920, 0.9909, 0.9890, 0.9890, 0.9800, 0.9800, 0.9538, 0.9538, 0.8956, 0.8848, 0.8509, 0.8352, 0.8041, 0.7920, 0.7612, 0.7510, 0.7201, 0.7112, 0.6805, 0.6727, 0.6424, 0.6357, 0.6061, 0.6002, 0.5718, 0.5665, 0.5394, 0.5347, 0.5089, 0.5046, 0.4805, 0.4768, 0.4528, 0.4484, 0.4285, 0.4241, 0.4049, 0.4007, 0.3833, 0.3788, 0.3632, 0.3583, 0.3444, 0.3391, 0.3246, 0.3215, 0.3086, 0.3049, 0.2978, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974, 0.2974 }, // BKZ-74, p=0.249416
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9936, 0.9908, 0.9830, 0.9826, 0.9800, 0.9800, 0.9800, 0.9800, 0.9188, 0.9161, 0.8697, 0.8498, 0.8161, 0.8040, 0.7725, 0.7636, 0.7322, 0.7246, 0.6934, 0.6868, 0.6556, 0.6500, 0.6193, 0.6146, 0.5849, 0.5809, 0.5524, 0.5490, 0.5218, 0.5188, 0.4934, 0.4905, 0.4652, 0.4626, 0.4415, 0.4379, 0.4176, 0.4147, 0.3961, 0.3928, 0.3760, 0.3721, 0.3570, 0.3527, 0.3393, 0.3346, 0.3219, 0.3203, 0.3067, 0.3015, 0.2984, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983, 0.2983 }, // BKZ-76, p=0.250040
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9934, 0.9913, 0.9877, 0.9877, 0.9854, 0.9854, 0.9800, 0.9800, 0.9484, 0.9484, 0.8803, 0.8798, 0.8334, 0.8206, 0.7854, 0.7795, 0.7445, 0.7410, 0.7062, 0.7036, 0.6683, 0.6665, 0.6315, 0.6305, 0.5964, 0.5959, 0.5633, 0.5633, 0.5324, 0.5302, 0.5037, 0.5036, 0.4758, 0.4722, 0.4512, 0.4512, 0.4287, 0.4284, 0.4075, 0.4073, 0.3886, 0.3875, 0.3702, 0.3679, 0.3521, 0.3492, 0.3350, 0.3317, 0.3179, 0.3159, 0.3048, 0.3037, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031, 0.3031 }, // BKZ-78, p=0.249555
{ 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9937, 0.9911, 0.9869, 0.9867, 0.9853, 0.9853, 0.9800, 0.9800, 0.9623, 0.9623, 0.8995, 0.8926, 0.8496, 0.8281, 0.7976, 0.7852, 0.7558, 0.7466, 0.7176, 0.7097, 0.6809, 0.6740, 0.6455, 0.6396, 0.6117, 0.6066, 0.5795, 0.5750, 0.5492, 0.5455, 0.5207, 0.5167, 0.4933, 0.4909, 0.4669, 0.4632, 0.4438, 0.4400, 0.4210, 0.4177, 0.4001, 0.3966, 0.3806, 0.3768, 0.3624, 0.3582, 0.3454, 0.3409, 0.3297, 0.3249, 0.3153, 0.3093, 0.3064, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063, 0.3063 }, // BKZ-80, p=0.249058
};

const FT* get_pruning_coefficients(const int block_size) {
	assert(2 <= block_size && block_size <= MAX_ENUM_N);
	return &pruning_params[(block_size + 1) / 2][0];
}
