# bnmapi-python
Unofficial python wrapper for Bank Negara Malaysia OpenAPI (https://apikijangportal.bnm.gov.my/)

## Dependencies
- requests

## Usage
```
>>> from openbnm.openbnm import OpenBNM
>>> bnm = OpenBNM()
>>> bnm.base_rates()
{'data': [{'bank_code': 'AFFINBANK', 'bank_name': 'Affin Bank', 'base_rate': 2.7, 'base_lending_rate': 5.56, 'indicative_eff_lending_rate': 3.3}, {'bank_code': 'ALLIANCEB', 'bank_name': 'Alliance Bank', 'base_rate': 2.57, 'base_lending_rate': 5.42, 'indicative_eff_lending_rate': 3.11}, {'bank_code': 'AMBANK', 'bank_name': 'AmBank', 'base_rate': 2.6, 'base_lending_rate': 5.45, 'indicative_eff_lending_rate': 3.25}, {'bank_code': 'BANGKOK', 'bank_name': 'Bangkok Bank Berhad', 'base_rate': 3.22, 'base_lending_rate': 5.87, 'indicative_eff_lending_rate': 4.42}, {'bank_code': 'BANKCHINA', 'bank_name': 'Bank of China (Malaysia) Berhad', 'base_rate': 2.55, 'base_lending_rate': 5.35, 'indicative_eff_lending_rate': 3.55}, {'bank_code': 'CIMB BANK', 'bank_name': 'CIMB Bank Berhad', 'base_rate': 2.75, 'base_lending_rate': 5.6, 'indicative_eff_lending_rate': 3.5}, {'bank_code': 'CITIBANK', 'bank_name': 'Citibank Berhad', 'base_rate': 2.4, 'base_lending_rate': 5.55, 'indicative_eff_lending_rate': 3.2}, {'bank_code': '', 'bank_name': 'Hong Leong Bank Malaysia Berhad', 'base_rate': 2.63, 'base_lending_rate': 5.64, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'HSBC Bank Malaysia Berhad', 'base_rate': 2.39, 'base_lending_rate': 5.49, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'Industrial and Commercial Bank of China (Malaysia) Berhad', 'base_rate': 2.52, 'base_lending_rate': 5.45, 'indicative_eff_lending_rate': 3.47}, {'bank_code': '', 'bank_name': 'Malayan Banking Berhad', 'base_rate': 1.75, 'base_lending_rate': 5.4, 'indicative_eff_lending_rate': 3.25}, {'bank_code': '', 'bank_name': 'OCBC Bank (Malaysia) Berhad', 'base_rate': 2.58, 'base_lending_rate': 5.51, 'indicative_eff_lending_rate': 3.45}, {'bank_code': '', 'bank_name': 'Public Bank Berhad', 'base_rate': 2.27, 'base_lending_rate': 5.47, 'indicative_eff_lending_rate': 3.1}, {'bank_code': '', 'bank_name': 'RHB Bank Berhad', 'base_rate': 2.5, 'base_lending_rate': 5.45, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'Standard Chartered Bank Malaysia Berhad', 'base_rate': 2.27, 'base_lending_rate': 5.45, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'United Overseas Bank (Malaysia) Bhd.', 'base_rate': 2.61, 'base_lending_rate': 5.57, 'indicative_eff_lending_rate': 3.36}, {'bank_code': 'AFFINIB', 'bank_name': 'Affin Islamic Bank Berhad', 'base_rate': 2.7, 'base_financing_rate': 5.56, 'indicative_eff_lending_rate': 3.3}, {'bank_code': 'RJHI', 'bank_name': 'Al Rajhi Banking & Investment Corporation (Malaysia) Berhad', 'base_rate': 2.85, 'base_financing_rate': 5.75, 'indicative_eff_lending_rate': 4.2}, {'bank_code': '', 'bank_name': 'Alliance Islamic Bank Berhad', 'base_rate': 2.57, 'base_financing_rate': 5.42, 'indicative_eff_lending_rate': 3.11}, {'bank_code': '', 'bank_name': 'AmBank Islamic Berhad', 'base_rate': 2.6, 'base_financing_rate': 5.45, 'indicative_eff_lending_rate': 3.25}, {'bank_code': '', 'bank_name': 'Bank Islam Malaysia Berhad', 'base_rate': 2.52, 'base_financing_rate': 5.47, 'indicative_eff_lending_rate': 3.25}, {'bank_code': '', 'bank_name': 'Bank Muamalat Malaysia Berhad', 'base_rate': 2.56, 'base_financing_rate': 5.56, 'indicative_eff_lending_rate': 3.56}, {'bank_code': '', 'bank_name': 'CIMB Islamic Bank Berhad', 'base_rate': 2.75, 'base_financing_rate': 5.6, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'Hong Leong Islamic Bank Berhad', 'base_rate': 2.63, 'base_financing_rate': 5.64, 'indicative_eff_lending_rate': 3.35}, {'bank_code': '', 'bank_name': 'HSBC Amanah Malaysia Berhad', 'base_rate': 2.39, 'base_financing_rate': 5.49, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'Kuwait Finance House (Malaysia) Berhad', 'base_rate': 2.25, 'base_financing_rate': 6.14, 'indicative_eff_lending_rate': 3.3}, {'bank_code': '', 'bank_name': 'Maybank Islamic Berhad', 'base_rate': 1.75, 'base_financing_rate': 5.4, 'indicative_eff_lending_rate': 3.25}, {'bank_code': '', 'bank_name': 'MBSB Bank Berhad', 'base_rate': 2.65, 'base_financing_rate': 5.5, 'indicative_eff_lending_rate': 3.2}, {'bank_code': '', 'bank_name': 'OCBC Al-Amin Bank Berhad', 'base_rate': 2.58, 'base_financing_rate': 5.52, 'indicative_eff_lending_rate': 3.45}, {'bank_code': '', 'bank_name': 'Public Islamic Bank Berhad', 'base_rate': 2.27, 'base_financing_rate': 5.47, 'indicative_eff_lending_rate': 3.1}, {'bank_code': '', 'bank_name': 'RHB Islamic Bank Berhad', 'base_rate': 2.5, 'base_financing_rate': 5.45, 'indicative_eff_lending_rate': 3.5}, {'bank_code': '', 'bank_name': 'Standard Chartered Saadiq Berhad', 'base_rate': 2.27, 'base_financing_rate': 5.45, 'indicative_eff_lending_rate': 3.5}, {'bank_code': 'BKRMB', 'bank_name': 'Bank Kerjasama Rakyat Malaysia Berhad', 'base_rate': 2.6, 'base_financing_rate': 5.58, 'indicative_eff_lending_rate': 3.4}, {'bank_code': '', 'bank_name': 'Agrobank', 'base_rate': 2.35, 'base_financing_rate': 5.5, 'indicative_eff_lending_rate': 0}, {'bank_code': '', 'bank_name': 'Bank Simpanan Nasional', 'base_rate': 2.6, 'base_financing_rate': 5.35, 'indicative_eff_lending_rate': 3.1}], 'meta': {'last_updated': '2020-08-06 16:49:01', 'total_result': 35, 'effective_date': '2020-08-06'}}
```

## Examples
Daily interbank swap volume by tenure on 30 September 2021
```
>>> bnm.interbank_swap('2021-09-30')
{'data': {'date': '2021-09-30', 'overnight': 1321.35, '1_week': 372.82, '2_week': 0.01, '1_month': 133.31, '2_month': 0.57, '3_month': 42.36, '6_month': 95.09, '9_month': 60, '12_month': 0, 'more_1_year': 25}, 'meta': {'last_updated': '2022-10-19 07:00:07', 'total_result': 1}}
```

Daily trading prices of Malaysia gold bullion coin on October 2021
```
>>> bnm.kijang_emas('2021', '10')
{'data': [{'effective_date': '2021-10-01', 'one_oz': {'buying': 7467, 'selling': 7769}, 'half_oz': {'buying': 3733, 'selling': 3958}, 'quarter_oz': {'buying': 1867, 'selling': 2016}}, {'effective_date': '2021-10-04', 'one_oz': {'buying': 7507, 'selling': 7826}, 'half_oz': {'buying': 3754, 'selling': 3987}, 'quarter_oz': {'buying': 1877, 'selling': 2030}}, {'effective_date': '2021-10-05', 'one_oz': {'buying': 7520, 'selling': 7827}, 'half_oz': {'buying': 3760, 'selling': 3987}, 'quarter_oz': {'buying': 1880, 'selling': 2030}}, {'effective_date': '2021-10-06', 'one_oz': {'buying': 7490, 'selling': 7793}, 'half_oz': {'buying': 3745, 'selling': 3970}, 'quarter_oz': {'buying': 1872, 'selling': 2022}}, {'effective_date': '2021-10-07', 'one_oz': {'buying': 7515, 'selling': 7819}, 'half_oz': {'buying': 3757, 'selling': 3983}, 'quarter_oz': {'buying': 1879, 'selling': 2028}}, {'effective_date': '2021-10-08', 'one_oz': {'buying': 7478, 'selling': 7780}, 'half_oz': {'buying': 3739, 'selling': 3963}, 'quarter_oz': {'buying': 1870, 'selling': 2018}}, {'effective_date': '2021-10-11', 'one_oz': {'buying': 7473, 'selling': 7784}, 'half_oz': {'buying': 3736, 'selling': 3966}, 'quarter_oz': {'buying': 1868, 'selling': 2020}}, {'effective_date': '2021-10-12', 'one_oz': {'buying': 7451, 'selling': 7755}, 'half_oz': {'buying': 3726, 'selling': 3950}, 'quarter_oz': {'buying': 1863, 'selling': 2012}}, {'effective_date': '2021-10-13', 'one_oz': {'buying': 7485, 'selling': 7785}, 'half_oz': {'buying': 3743, 'selling': 3966}, 'quarter_oz': {'buying': 1871, 'selling': 2020}}, {'effective_date': '2021-10-14', 'one_oz': {'buying': 7583, 'selling': 7894}, 'half_oz': {'buying': 3792, 'selling': 4021}, 'quarter_oz': {'buying': 1896, 'selling': 2048}}, {'effective_date': '2021-10-15', 'one_oz': {'buying': 7608, 'selling': 7914}, 'half_oz': {'buying': 3804, 'selling': 4032}, 'quarter_oz': {'buying': 1902, 'selling': 2053}}], 'meta': {'last_updated': '2022-10-21 01:02:59', 'total_result': 11}}
```

## Source
[Official API](https://apikijangportal.bnm.gov.my/openapi)
