"""
Constants used in the Spex application.
"""

from pathlib import Path

# The name of the application
APP_NAME = "boot"

# The version of the application
__version__ = "0.1.0"

# The description of the application
DESCRIPTION = "A modern code generator for the modern age"

# The name of the directory where user-level configs are stored
CONFIGS_DIRNAME = ".boot_code"

# The header marker for files generated by Spex
FILE_HEADER_MARKER = "BOOT"

# The name of the directory where generated projects are stored
GENERATED_PATH = "generated_jobs"

# The name of the directory where prompt templates are stored
PROMPTS_DIR = "prompts"

# Environment variable to override the configs directory
ENV_CONFIGS_DIR = "BOOT_CONFIGS_DIR"

# Project root directory
PROJECT_ROOT = Path.cwd()
