//! Lookups of ordinals for some DLLs.
//!
//! Copied from
//! <https://github.com/VirusTotal/yara/blob/v4.2.2/libyara/modules/pe/pe_utils.c#L308=>
//! itself copied from pefile.

pub(super) fn ord_lookup(dll_name: &[u8], ord: u16) -> Vec<u8> {
    if dll_name.eq_ignore_ascii_case(b"WS2_32.dll") || dll_name.eq_ignore_ascii_case(b"wsock32.dll")
    {
        if let Some(v) = wsock32_ord_lookup(ord) {
            return v.to_owned();
        }
    } else if dll_name.eq_ignore_ascii_case(b"oleaut32.dll") {
        if let Some(v) = oleaut32_ord_lookup(ord) {
            return v.to_owned();
        }
    }

    format!("ord{ord}").into_bytes()
}

#[cfg_attr(coverage_nightly, coverage(off))]
fn wsock32_ord_lookup(ord: u16) -> Option<&'static [u8]> {
    match ord {
        1 => Some(b"accept"),
        2 => Some(b"bind"),
        3 => Some(b"closesocket"),
        4 => Some(b"connect"),
        5 => Some(b"getpeername"),
        6 => Some(b"getsockname"),
        7 => Some(b"getsockopt"),
        8 => Some(b"htonl"),
        9 => Some(b"htons"),
        10 => Some(b"ioctlsocket"),
        11 => Some(b"inet_addr"),
        12 => Some(b"inet_ntoa"),
        13 => Some(b"listen"),
        14 => Some(b"ntohl"),
        15 => Some(b"ntohs"),
        16 => Some(b"recv"),
        17 => Some(b"recvfrom"),
        18 => Some(b"select"),
        19 => Some(b"send"),
        20 => Some(b"sendto"),
        21 => Some(b"setsockopt"),
        22 => Some(b"shutdown"),
        23 => Some(b"socket"),
        24 => Some(b"GetAddrInfoW"),
        25 => Some(b"GetNameInfoW"),
        26 => Some(b"WSApSetPostRoutine"),
        27 => Some(b"FreeAddrInfoW"),
        28 => Some(b"WPUCompleteOverlappedRequest"),
        29 => Some(b"WSAAccept"),
        30 => Some(b"WSAAddressToStringA"),
        31 => Some(b"WSAAddressToStringW"),
        32 => Some(b"WSACloseEvent"),
        33 => Some(b"WSAConnect"),
        34 => Some(b"WSACreateEvent"),
        35 => Some(b"WSADuplicateSocketA"),
        36 => Some(b"WSADuplicateSocketW"),
        37 => Some(b"WSAEnumNameSpaceProvidersA"),
        38 => Some(b"WSAEnumNameSpaceProvidersW"),
        39 => Some(b"WSAEnumNetworkEvents"),
        40 => Some(b"WSAEnumProtocolsA"),
        41 => Some(b"WSAEnumProtocolsW"),
        42 => Some(b"WSAEventSelect"),
        43 => Some(b"WSAGetOverlappedResult"),
        44 => Some(b"WSAGetQOSByName"),
        45 => Some(b"WSAGetServiceClassInfoA"),
        46 => Some(b"WSAGetServiceClassInfoW"),
        47 => Some(b"WSAGetServiceClassNameByClassIdA"),
        48 => Some(b"WSAGetServiceClassNameByClassIdW"),
        49 => Some(b"WSAHtonl"),
        50 => Some(b"WSAHtons"),
        51 => Some(b"gethostbyaddr"),
        52 => Some(b"gethostbyname"),
        53 => Some(b"getprotobyname"),
        54 => Some(b"getprotobynumber"),
        55 => Some(b"getservbyname"),
        56 => Some(b"getservbyport"),
        57 => Some(b"gethostname"),
        58 => Some(b"WSAInstallServiceClassA"),
        59 => Some(b"WSAInstallServiceClassW"),
        60 => Some(b"WSAIoctl"),
        61 => Some(b"WSAJoinLeaf"),
        62 => Some(b"WSALookupServiceBeginA"),
        63 => Some(b"WSALookupServiceBeginW"),
        64 => Some(b"WSALookupServiceEnd"),
        65 => Some(b"WSALookupServiceNextA"),
        66 => Some(b"WSALookupServiceNextW"),
        67 => Some(b"WSANSPIoctl"),
        68 => Some(b"WSANtohl"),
        69 => Some(b"WSANtohs"),
        70 => Some(b"WSAProviderConfigChange"),
        71 => Some(b"WSARecv"),
        72 => Some(b"WSARecvDisconnect"),
        73 => Some(b"WSARecvFrom"),
        74 => Some(b"WSARemoveServiceClass"),
        75 => Some(b"WSAResetEvent"),
        76 => Some(b"WSASend"),
        77 => Some(b"WSASendDisconnect"),
        78 => Some(b"WSASendTo"),
        79 => Some(b"WSASetEvent"),
        80 => Some(b"WSASetServiceA"),
        81 => Some(b"WSASetServiceW"),
        82 => Some(b"WSASocketA"),
        83 => Some(b"WSASocketW"),
        84 => Some(b"WSAStringToAddressA"),
        85 => Some(b"WSAStringToAddressW"),
        86 => Some(b"WSAWaitForMultipleEvents"),
        87 => Some(b"WSCDeinstallProvider"),
        88 => Some(b"WSCEnableNSProvider"),
        89 => Some(b"WSCEnumProtocols"),
        90 => Some(b"WSCGetProviderPath"),
        91 => Some(b"WSCInstallNameSpace"),
        92 => Some(b"WSCInstallProvider"),
        93 => Some(b"WSCUnInstallNameSpace"),
        94 => Some(b"WSCUpdateProvider"),
        95 => Some(b"WSCWriteNameSpaceOrder"),
        96 => Some(b"WSCWriteProviderOrder"),
        97 => Some(b"freeaddrinfo"),
        98 => Some(b"getaddrinfo"),
        99 => Some(b"getnameinfo"),
        101 => Some(b"WSAAsyncSelect"),
        102 => Some(b"WSAAsyncGetHostByAddr"),
        103 => Some(b"WSAAsyncGetHostByName"),
        104 => Some(b"WSAAsyncGetProtoByNumber"),
        105 => Some(b"WSAAsyncGetProtoByName"),
        106 => Some(b"WSAAsyncGetServByPort"),
        107 => Some(b"WSAAsyncGetServByName"),
        108 => Some(b"WSACancelAsyncRequest"),
        109 => Some(b"WSASetBlockingHook"),
        110 => Some(b"WSAUnhookBlockingHook"),
        111 => Some(b"WSAGetLastError"),
        112 => Some(b"WSASetLastError"),
        113 => Some(b"WSACancelBlockingCall"),
        114 => Some(b"WSAIsBlocking"),
        115 => Some(b"WSAStartup"),
        116 => Some(b"WSACleanup"),
        151 => Some(b"__WSAFDIsSet"),
        500 => Some(b"WEP"),
        _ => None,
    }
}

#[cfg_attr(coverage_nightly, coverage(off))]
fn oleaut32_ord_lookup(ord: u16) -> Option<&'static [u8]> {
    match ord {
        2 => Some(b"SysAllocString"),
        3 => Some(b"SysReAllocString"),
        4 => Some(b"SysAllocStringLen"),
        5 => Some(b"SysReAllocStringLen"),
        6 => Some(b"SysFreeString"),
        7 => Some(b"SysStringLen"),
        8 => Some(b"VariantInit"),
        9 => Some(b"VariantClear"),
        10 => Some(b"VariantCopy"),
        11 => Some(b"VariantCopyInd"),
        12 => Some(b"VariantChangeType"),
        13 => Some(b"VariantTimeToDosDateTime"),
        14 => Some(b"DosDateTimeToVariantTime"),
        15 => Some(b"SafeArrayCreate"),
        16 => Some(b"SafeArrayDestroy"),
        17 => Some(b"SafeArrayGetDim"),
        18 => Some(b"SafeArrayGetElemsize"),
        19 => Some(b"SafeArrayGetUBound"),
        20 => Some(b"SafeArrayGetLBound"),
        21 => Some(b"SafeArrayLock"),
        22 => Some(b"SafeArrayUnlock"),
        23 => Some(b"SafeArrayAccessData"),
        24 => Some(b"SafeArrayUnaccessData"),
        25 => Some(b"SafeArrayGetElement"),
        26 => Some(b"SafeArrayPutElement"),
        27 => Some(b"SafeArrayCopy"),
        28 => Some(b"DispGetParam"),
        29 => Some(b"DispGetIDsOfNames"),
        30 => Some(b"DispInvoke"),
        31 => Some(b"CreateDispTypeInfo"),
        32 => Some(b"CreateStdDispatch"),
        33 => Some(b"RegisterActiveObject"),
        34 => Some(b"RevokeActiveObject"),
        35 => Some(b"GetActiveObject"),
        36 => Some(b"SafeArrayAllocDescriptor"),
        37 => Some(b"SafeArrayAllocData"),
        38 => Some(b"SafeArrayDestroyDescriptor"),
        39 => Some(b"SafeArrayDestroyData"),
        40 => Some(b"SafeArrayRedim"),
        41 => Some(b"SafeArrayAllocDescriptorEx"),
        42 => Some(b"SafeArrayCreateEx"),
        43 => Some(b"SafeArrayCreateVectorEx"),
        44 => Some(b"SafeArraySetRecordInfo"),
        45 => Some(b"SafeArrayGetRecordInfo"),
        46 => Some(b"VarParseNumFromStr"),
        47 => Some(b"VarNumFromParseNum"),
        48 => Some(b"VarI2FromUI1"),
        49 => Some(b"VarI2FromI4"),
        50 => Some(b"VarI2FromR4"),
        51 => Some(b"VarI2FromR8"),
        52 => Some(b"VarI2FromCy"),
        53 => Some(b"VarI2FromDate"),
        54 => Some(b"VarI2FromStr"),
        55 => Some(b"VarI2FromDisp"),
        56 => Some(b"VarI2FromBool"),
        57 => Some(b"SafeArraySetIID"),
        58 => Some(b"VarI4FromUI1"),
        59 => Some(b"VarI4FromI2"),
        60 => Some(b"VarI4FromR4"),
        61 => Some(b"VarI4FromR8"),
        62 => Some(b"VarI4FromCy"),
        63 => Some(b"VarI4FromDate"),
        64 => Some(b"VarI4FromStr"),
        65 => Some(b"VarI4FromDisp"),
        66 => Some(b"VarI4FromBool"),
        67 => Some(b"SafeArrayGetIID"),
        68 => Some(b"VarR4FromUI1"),
        69 => Some(b"VarR4FromI2"),
        70 => Some(b"VarR4FromI4"),
        71 => Some(b"VarR4FromR8"),
        72 => Some(b"VarR4FromCy"),
        73 => Some(b"VarR4FromDate"),
        74 => Some(b"VarR4FromStr"),
        75 => Some(b"VarR4FromDisp"),
        76 => Some(b"VarR4FromBool"),
        77 => Some(b"SafeArrayGetVartype"),
        78 => Some(b"VarR8FromUI1"),
        79 => Some(b"VarR8FromI2"),
        80 => Some(b"VarR8FromI4"),
        81 => Some(b"VarR8FromR4"),
        82 => Some(b"VarR8FromCy"),
        83 => Some(b"VarR8FromDate"),
        84 => Some(b"VarR8FromStr"),
        85 => Some(b"VarR8FromDisp"),
        86 => Some(b"VarR8FromBool"),
        87 => Some(b"VarFormat"),
        88 => Some(b"VarDateFromUI1"),
        89 => Some(b"VarDateFromI2"),
        90 => Some(b"VarDateFromI4"),
        91 => Some(b"VarDateFromR4"),
        92 => Some(b"VarDateFromR8"),
        93 => Some(b"VarDateFromCy"),
        94 => Some(b"VarDateFromStr"),
        95 => Some(b"VarDateFromDisp"),
        96 => Some(b"VarDateFromBool"),
        97 => Some(b"VarFormatDateTime"),
        98 => Some(b"VarCyFromUI1"),
        99 => Some(b"VarCyFromI2"),
        100 => Some(b"VarCyFromI4"),
        101 => Some(b"VarCyFromR4"),
        102 => Some(b"VarCyFromR8"),
        103 => Some(b"VarCyFromDate"),
        104 => Some(b"VarCyFromStr"),
        105 => Some(b"VarCyFromDisp"),
        106 => Some(b"VarCyFromBool"),
        107 => Some(b"VarFormatNumber"),
        108 => Some(b"VarBstrFromUI1"),
        109 => Some(b"VarBstrFromI2"),
        110 => Some(b"VarBstrFromI4"),
        111 => Some(b"VarBstrFromR4"),
        112 => Some(b"VarBstrFromR8"),
        113 => Some(b"VarBstrFromCy"),
        114 => Some(b"VarBstrFromDate"),
        115 => Some(b"VarBstrFromDisp"),
        116 => Some(b"VarBstrFromBool"),
        117 => Some(b"VarFormatPercent"),
        118 => Some(b"VarBoolFromUI1"),
        119 => Some(b"VarBoolFromI2"),
        120 => Some(b"VarBoolFromI4"),
        121 => Some(b"VarBoolFromR4"),
        122 => Some(b"VarBoolFromR8"),
        123 => Some(b"VarBoolFromDate"),
        124 => Some(b"VarBoolFromCy"),
        125 => Some(b"VarBoolFromStr"),
        126 => Some(b"VarBoolFromDisp"),
        127 => Some(b"VarFormatCurrency"),
        128 => Some(b"VarWeekdayName"),
        129 => Some(b"VarMonthName"),
        130 => Some(b"VarUI1FromI2"),
        131 => Some(b"VarUI1FromI4"),
        132 => Some(b"VarUI1FromR4"),
        133 => Some(b"VarUI1FromR8"),
        134 => Some(b"VarUI1FromCy"),
        135 => Some(b"VarUI1FromDate"),
        136 => Some(b"VarUI1FromStr"),
        137 => Some(b"VarUI1FromDisp"),
        138 => Some(b"VarUI1FromBool"),
        139 => Some(b"VarFormatFromTokens"),
        140 => Some(b"VarTokenizeFormatString"),
        141 => Some(b"VarAdd"),
        142 => Some(b"VarAnd"),
        143 => Some(b"VarDiv"),
        144 => Some(b"DllCanUnloadNow"),
        145 => Some(b"DllGetClassObject"),
        146 => Some(b"DispCallFunc"),
        147 => Some(b"VariantChangeTypeEx"),
        148 => Some(b"SafeArrayPtrOfIndex"),
        149 => Some(b"SysStringByteLen"),
        150 => Some(b"SysAllocStringByteLen"),
        151 => Some(b"DllRegisterServer"),
        152 => Some(b"VarEqv"),
        153 => Some(b"VarIdiv"),
        154 => Some(b"VarImp"),
        155 => Some(b"VarMod"),
        156 => Some(b"VarMul"),
        157 => Some(b"VarOr"),
        158 => Some(b"VarPow"),
        159 => Some(b"VarSub"),
        160 => Some(b"CreateTypeLib"),
        161 => Some(b"LoadTypeLib"),
        162 => Some(b"LoadRegTypeLib"),
        163 => Some(b"RegisterTypeLib"),
        164 => Some(b"QueryPathOfRegTypeLib"),
        165 => Some(b"LHashValOfNameSys"),
        166 => Some(b"LHashValOfNameSysA"),
        167 => Some(b"VarXor"),
        168 => Some(b"VarAbs"),
        169 => Some(b"VarFix"),
        170 => Some(b"OaBuildVersion"),
        171 => Some(b"ClearCustData"),
        172 => Some(b"VarInt"),
        173 => Some(b"VarNeg"),
        174 => Some(b"VarNot"),
        175 => Some(b"VarRound"),
        176 => Some(b"VarCmp"),
        177 => Some(b"VarDecAdd"),
        178 => Some(b"VarDecDiv"),
        179 => Some(b"VarDecMul"),
        180 => Some(b"CreateTypeLib2"),
        181 => Some(b"VarDecSub"),
        182 => Some(b"VarDecAbs"),
        183 => Some(b"LoadTypeLibEx"),
        184 => Some(b"SystemTimeToVariantTime"),
        185 => Some(b"VariantTimeToSystemTime"),
        186 => Some(b"UnRegisterTypeLib"),
        187 => Some(b"VarDecFix"),
        188 => Some(b"VarDecInt"),
        189 => Some(b"VarDecNeg"),
        190 => Some(b"VarDecFromUI1"),
        191 => Some(b"VarDecFromI2"),
        192 => Some(b"VarDecFromI4"),
        193 => Some(b"VarDecFromR4"),
        194 => Some(b"VarDecFromR8"),
        195 => Some(b"VarDecFromDate"),
        196 => Some(b"VarDecFromCy"),
        197 => Some(b"VarDecFromStr"),
        198 => Some(b"VarDecFromDisp"),
        199 => Some(b"VarDecFromBool"),
        200 => Some(b"GetErrorInfo"),
        201 => Some(b"SetErrorInfo"),
        202 => Some(b"CreateErrorInfo"),
        203 => Some(b"VarDecRound"),
        204 => Some(b"VarDecCmp"),
        205 => Some(b"VarI2FromI1"),
        206 => Some(b"VarI2FromUI2"),
        207 => Some(b"VarI2FromUI4"),
        208 => Some(b"VarI2FromDec"),
        209 => Some(b"VarI4FromI1"),
        210 => Some(b"VarI4FromUI2"),
        211 => Some(b"VarI4FromUI4"),
        212 => Some(b"VarI4FromDec"),
        213 => Some(b"VarR4FromI1"),
        214 => Some(b"VarR4FromUI2"),
        215 => Some(b"VarR4FromUI4"),
        216 => Some(b"VarR4FromDec"),
        217 => Some(b"VarR8FromI1"),
        218 => Some(b"VarR8FromUI2"),
        219 => Some(b"VarR8FromUI4"),
        220 => Some(b"VarR8FromDec"),
        221 => Some(b"VarDateFromI1"),
        222 => Some(b"VarDateFromUI2"),
        223 => Some(b"VarDateFromUI4"),
        224 => Some(b"VarDateFromDec"),
        225 => Some(b"VarCyFromI1"),
        226 => Some(b"VarCyFromUI2"),
        227 => Some(b"VarCyFromUI4"),
        228 => Some(b"VarCyFromDec"),
        229 => Some(b"VarBstrFromI1"),
        230 => Some(b"VarBstrFromUI2"),
        231 => Some(b"VarBstrFromUI4"),
        232 => Some(b"VarBstrFromDec"),
        233 => Some(b"VarBoolFromI1"),
        234 => Some(b"VarBoolFromUI2"),
        235 => Some(b"VarBoolFromUI4"),
        236 => Some(b"VarBoolFromDec"),
        237 => Some(b"VarUI1FromI1"),
        238 => Some(b"VarUI1FromUI2"),
        239 => Some(b"VarUI1FromUI4"),
        240 => Some(b"VarUI1FromDec"),
        241 => Some(b"VarDecFromI1"),
        242 => Some(b"VarDecFromUI2"),
        243 => Some(b"VarDecFromUI4"),
        244 => Some(b"VarI1FromUI1"),
        245 => Some(b"VarI1FromI2"),
        246 => Some(b"VarI1FromI4"),
        247 => Some(b"VarI1FromR4"),
        248 => Some(b"VarI1FromR8"),
        249 => Some(b"VarI1FromDate"),
        250 => Some(b"VarI1FromCy"),
        251 => Some(b"VarI1FromStr"),
        252 => Some(b"VarI1FromDisp"),
        253 => Some(b"VarI1FromBool"),
        254 => Some(b"VarI1FromUI2"),
        255 => Some(b"VarI1FromUI4"),
        256 => Some(b"VarI1FromDec"),
        257 => Some(b"VarUI2FromUI1"),
        258 => Some(b"VarUI2FromI2"),
        259 => Some(b"VarUI2FromI4"),
        260 => Some(b"VarUI2FromR4"),
        261 => Some(b"VarUI2FromR8"),
        262 => Some(b"VarUI2FromDate"),
        263 => Some(b"VarUI2FromCy"),
        264 => Some(b"VarUI2FromStr"),
        265 => Some(b"VarUI2FromDisp"),
        266 => Some(b"VarUI2FromBool"),
        267 => Some(b"VarUI2FromI1"),
        268 => Some(b"VarUI2FromUI4"),
        269 => Some(b"VarUI2FromDec"),
        270 => Some(b"VarUI4FromUI1"),
        271 => Some(b"VarUI4FromI2"),
        272 => Some(b"VarUI4FromI4"),
        273 => Some(b"VarUI4FromR4"),
        274 => Some(b"VarUI4FromR8"),
        275 => Some(b"VarUI4FromDate"),
        276 => Some(b"VarUI4FromCy"),
        277 => Some(b"VarUI4FromStr"),
        278 => Some(b"VarUI4FromDisp"),
        279 => Some(b"VarUI4FromBool"),
        280 => Some(b"VarUI4FromI1"),
        281 => Some(b"VarUI4FromUI2"),
        282 => Some(b"VarUI4FromDec"),
        283 => Some(b"BSTR_UserSize"),
        284 => Some(b"BSTR_UserMarshal"),
        285 => Some(b"BSTR_UserUnmarshal"),
        286 => Some(b"BSTR_UserFree"),
        287 => Some(b"VARIANT_UserSize"),
        288 => Some(b"VARIANT_UserMarshal"),
        289 => Some(b"VARIANT_UserUnmarshal"),
        290 => Some(b"VARIANT_UserFree"),
        291 => Some(b"LPSAFEARRAY_UserSize"),
        292 => Some(b"LPSAFEARRAY_UserMarshal"),
        293 => Some(b"LPSAFEARRAY_UserUnmarshal"),
        294 => Some(b"LPSAFEARRAY_UserFree"),
        295 => Some(b"LPSAFEARRAY_Size"),
        296 => Some(b"LPSAFEARRAY_Marshal"),
        297 => Some(b"LPSAFEARRAY_Unmarshal"),
        298 => Some(b"VarDecCmpR8"),
        299 => Some(b"VarCyAdd"),
        300 => Some(b"DllUnregisterServer"),
        301 => Some(b"OACreateTypeLib2"),
        303 => Some(b"VarCyMul"),
        304 => Some(b"VarCyMulI4"),
        305 => Some(b"VarCySub"),
        306 => Some(b"VarCyAbs"),
        307 => Some(b"VarCyFix"),
        308 => Some(b"VarCyInt"),
        309 => Some(b"VarCyNeg"),
        310 => Some(b"VarCyRound"),
        311 => Some(b"VarCyCmp"),
        312 => Some(b"VarCyCmpR8"),
        313 => Some(b"VarBstrCat"),
        314 => Some(b"VarBstrCmp"),
        315 => Some(b"VarR8Pow"),
        316 => Some(b"VarR4CmpR8"),
        317 => Some(b"VarR8Round"),
        318 => Some(b"VarCat"),
        319 => Some(b"VarDateFromUdateEx"),
        322 => Some(b"GetRecordInfoFromGuids"),
        323 => Some(b"GetRecordInfoFromTypeInfo"),
        325 => Some(b"SetVarConversionLocaleSetting"),
        326 => Some(b"GetVarConversionLocaleSetting"),
        327 => Some(b"SetOaNoCache"),
        329 => Some(b"VarCyMulI8"),
        330 => Some(b"VarDateFromUdate"),
        331 => Some(b"VarUdateFromDate"),
        332 => Some(b"GetAltMonthNames"),
        333 => Some(b"VarI8FromUI1"),
        334 => Some(b"VarI8FromI2"),
        335 => Some(b"VarI8FromR4"),
        336 => Some(b"VarI8FromR8"),
        337 => Some(b"VarI8FromCy"),
        338 => Some(b"VarI8FromDate"),
        339 => Some(b"VarI8FromStr"),
        340 => Some(b"VarI8FromDisp"),
        341 => Some(b"VarI8FromBool"),
        342 => Some(b"VarI8FromI1"),
        343 => Some(b"VarI8FromUI2"),
        344 => Some(b"VarI8FromUI4"),
        345 => Some(b"VarI8FromDec"),
        346 => Some(b"VarI2FromI8"),
        347 => Some(b"VarI2FromUI8"),
        348 => Some(b"VarI4FromI8"),
        349 => Some(b"VarI4FromUI8"),
        360 => Some(b"VarR4FromI8"),
        361 => Some(b"VarR4FromUI8"),
        362 => Some(b"VarR8FromI8"),
        363 => Some(b"VarR8FromUI8"),
        364 => Some(b"VarDateFromI8"),
        365 => Some(b"VarDateFromUI8"),
        366 => Some(b"VarCyFromI8"),
        367 => Some(b"VarCyFromUI8"),
        368 => Some(b"VarBstrFromI8"),
        369 => Some(b"VarBstrFromUI8"),
        370 => Some(b"VarBoolFromI8"),
        371 => Some(b"VarBoolFromUI8"),
        372 => Some(b"VarUI1FromI8"),
        373 => Some(b"VarUI1FromUI8"),
        374 => Some(b"VarDecFromI8"),
        375 => Some(b"VarDecFromUI8"),
        376 => Some(b"VarI1FromI8"),
        377 => Some(b"VarI1FromUI8"),
        378 => Some(b"VarUI2FromI8"),
        379 => Some(b"VarUI2FromUI8"),
        401 => Some(b"OleLoadPictureEx"),
        402 => Some(b"OleLoadPictureFileEx"),
        411 => Some(b"SafeArrayCreateVector"),
        412 => Some(b"SafeArrayCopyData"),
        413 => Some(b"VectorFromBstr"),
        414 => Some(b"BstrFromVector"),
        415 => Some(b"OleIconToCursor"),
        416 => Some(b"OleCreatePropertyFrameIndirect"),
        417 => Some(b"OleCreatePropertyFrame"),
        418 => Some(b"OleLoadPicture"),
        419 => Some(b"OleCreatePictureIndirect"),
        420 => Some(b"OleCreateFontIndirect"),
        421 => Some(b"OleTranslateColor"),
        422 => Some(b"OleLoadPictureFile"),
        423 => Some(b"OleSavePictureFile"),
        424 => Some(b"OleLoadPicturePath"),
        425 => Some(b"VarUI4FromI8"),
        426 => Some(b"VarUI4FromUI8"),
        427 => Some(b"VarI8FromUI8"),
        428 => Some(b"VarUI8FromI8"),
        429 => Some(b"VarUI8FromUI1"),
        430 => Some(b"VarUI8FromI2"),
        431 => Some(b"VarUI8FromR4"),
        432 => Some(b"VarUI8FromR8"),
        433 => Some(b"VarUI8FromCy"),
        434 => Some(b"VarUI8FromDate"),
        435 => Some(b"VarUI8FromStr"),
        436 => Some(b"VarUI8FromDisp"),
        437 => Some(b"VarUI8FromBool"),
        438 => Some(b"VarUI8FromI1"),
        439 => Some(b"VarUI8FromUI2"),
        440 => Some(b"VarUI8FromUI4"),
        441 => Some(b"VarUI8FromDec"),
        442 => Some(b"RegisterTypeLibForUser"),
        443 => Some(b"UnRegisterTypeLibForUser"),
        _ => None,
    }
}
