# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class BalanceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def begin_transaction(self, pid, body, **kwargs):  # noqa: E501
        """Create new transaction  # noqa: E501

        Creates new transaction and returns information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.begin_transaction(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateTransactionPayload body: Transaction Payload (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.begin_transaction_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.begin_transaction_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def begin_transaction_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Create new transaction  # noqa: E501

        Creates new transaction and returns information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.begin_transaction_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateTransactionPayload body: Transaction Payload (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method begin_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `begin_transaction`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `begin_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/transactions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_transaction(self, pid, tid, **kwargs):  # noqa: E501
        """Cancel transaction  # noqa: E501

        Cancels transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_transaction(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str tid: Transaction Id (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_transaction_with_http_info(pid, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_transaction_with_http_info(pid, tid, **kwargs)  # noqa: E501
            return data

    def cancel_transaction_with_http_info(self, pid, tid, **kwargs):  # noqa: E501
        """Cancel transaction  # noqa: E501

        Cancels transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_transaction_with_http_info(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str tid: Transaction Id (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `cancel_transaction`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `cancel_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/transactions/{tid}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_transaction(self, pid, tid, **kwargs):  # noqa: E501
        """Complete transaction  # noqa: E501

        Completes transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str tid: Transaction Id (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_transaction_with_http_info(pid, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_transaction_with_http_info(pid, tid, **kwargs)  # noqa: E501
            return data

    def complete_transaction_with_http_info(self, pid, tid, **kwargs):  # noqa: E501
        """Complete transaction  # noqa: E501

        Completes transaction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction_with_http_info(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str tid: Transaction Id (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `complete_transaction`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `complete_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/transactions/{tid}/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_balance_limit(self, pid, bdid, body, **kwargs):  # noqa: E501
        """Create balance limits  # noqa: E501

        Creates balance limit and sends the created UUID along with the data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_balance_limit(pid, bdid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param CreateBalanceLimitPayload body: Balance Definition Payload (required)
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_balance_limit_with_http_info(pid, bdid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_balance_limit_with_http_info(pid, bdid, body, **kwargs)  # noqa: E501
            return data

    def create_balance_limit_with_http_info(self, pid, bdid, body, **kwargs):  # noqa: E501
        """Create balance limits  # noqa: E501

        Creates balance limit and sends the created UUID along with the data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_balance_limit_with_http_info(pid, bdid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param CreateBalanceLimitPayload body: Balance Definition Payload (required)
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_balance_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `create_balance_limit`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `create_balance_limit`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_balance_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceLimit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_balance_order(self, pid, body, **kwargs):  # noqa: E501
        """Create balance order  # noqa: E501

        Returns created order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_balance_order(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateOrderPayload body: Order Payload (required)
        :return: BalanceOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_balance_order_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_balance_order_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def create_balance_order_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Create balance order  # noqa: E501

        Returns created order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_balance_order_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateOrderPayload body: Order Payload (required)
        :return: BalanceOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_balance_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `create_balance_order`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_balance_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/create-order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceOrder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_balance_definition(self, pid, bdid, **kwargs):  # noqa: E501
        """Delete balance definition  # noqa: E501

        Delete Balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_balance_definition(pid, bdid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_balance_definition_with_http_info(pid, bdid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_balance_definition_with_http_info(pid, bdid, **kwargs)  # noqa: E501
            return data

    def delete_balance_definition_with_http_info(self, pid, bdid, **kwargs):  # noqa: E501
        """Delete balance definition  # noqa: E501

        Delete Balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_balance_definition_with_http_info(pid, bdid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_balance_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_balance_definition`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `delete_balance_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_balance_limit(self, pid, bdid, blid, **kwargs):  # noqa: E501
        """Delete balance limit  # noqa: E501

        Delete balance limit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_balance_limit(pid, bdid, blid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_balance_limit_with_http_info(pid, bdid, blid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_balance_limit_with_http_info(pid, bdid, blid, **kwargs)  # noqa: E501
            return data

    def delete_balance_limit_with_http_info(self, pid, bdid, blid, **kwargs):  # noqa: E501
        """Delete balance limit  # noqa: E501

        Delete balance limit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_balance_limit_with_http_info(pid, bdid, blid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'blid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_balance_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_balance_limit`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `delete_balance_limit`")  # noqa: E501
        # verify the required parameter 'blid' is set
        if ('blid' not in params or
                params['blid'] is None):
            raise ValueError("Missing the required parameter `blid` when calling `delete_balance_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501
        if 'blid' in params:
            path_params['blid'] = params['blid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_balance_definition(self, pid, bdid, **kwargs):  # noqa: E501
        """Get balance definition  # noqa: E501

        Returns balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_definition(pid, bdid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str version: Version
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_balance_definition_with_http_info(pid, bdid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_balance_definition_with_http_info(pid, bdid, **kwargs)  # noqa: E501
            return data

    def get_balance_definition_with_http_info(self, pid, bdid, **kwargs):  # noqa: E501
        """Get balance definition  # noqa: E501

        Returns balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_definition_with_http_info(pid, bdid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str version: Version
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_balance_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_balance_definition`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `get_balance_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_balance_definition_list(self, pid, **kwargs):  # noqa: E501
        """Get balance definition list  # noqa: E501

        Returns balance definition page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_definition_list(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int limit: Limit the number of records returned
        :param int offset: Offset to paginate records
        :param str sort_field: Field to sort by
        :param str sort: Sort direction
        :param str version: Version
        :return: BalanceDefinitionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_balance_definition_list_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_balance_definition_list_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_balance_definition_list_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Get balance definition list  # noqa: E501

        Returns balance definition page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_definition_list_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int limit: Limit the number of records returned
        :param int offset: Offset to paginate records
        :param str sort_field: Field to sort by
        :param str sort: Sort direction
        :param str version: Version
        :return: BalanceDefinitionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'limit', 'offset', 'sort_field', 'sort', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_balance_definition_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_balance_definition_list`")  # noqa: E501

        if 'limit' in params and params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_balance_definition_list`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_balance_definition_list`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_balance_definition_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceDefinitionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_balance_limit(self, pid, bdid, blid, **kwargs):  # noqa: E501
        """Get balance limits  # noqa: E501

        Fetches balance limits and send the created UUID along with the data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_limit(pid, bdid, blid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :param str version: Version
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_balance_limit_with_http_info(pid, bdid, blid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_balance_limit_with_http_info(pid, bdid, blid, **kwargs)  # noqa: E501
            return data

    def get_balance_limit_with_http_info(self, pid, bdid, blid, **kwargs):  # noqa: E501
        """Get balance limits  # noqa: E501

        Fetches balance limits and send the created UUID along with the data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_balance_limit_with_http_info(pid, bdid, blid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :param str version: Version
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'blid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_balance_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_balance_limit`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `get_balance_limit`")  # noqa: E501
        # verify the required parameter 'blid' is set
        if ('blid' not in params or
                params['blid'] is None):
            raise ValueError("Missing the required parameter `blid` when calling `get_balance_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501
        if 'blid' in params:
            path_params['blid'] = params['blid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceLimit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contact_balances(self, pid, **kwargs):  # noqa: E501
        """Get balance list  # noqa: E501

        Returns balance list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact_balances(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: ContactBalancesResp
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contact_balances_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contact_balances_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_contact_balances_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Get balance list  # noqa: E501

        Returns balance list  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contact_balances_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: ContactBalancesResp
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contact_balances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_contact_balances`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/contact-balances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContactBalancesResp',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_balances(self, cid, pid, **kwargs):  # noqa: E501
        """Get subscription balances  # noqa: E501

        Returns subscription balances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_balances(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Contact Id (required)
        :param str pid: Loyalty Program Id (required)
        :return: ModelSubscriptionBalanceResp
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_balances_with_http_info(cid, pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_balances_with_http_info(cid, pid, **kwargs)  # noqa: E501
            return data

    def get_subscription_balances_with_http_info(self, cid, pid, **kwargs):  # noqa: E501
        """Get subscription balances  # noqa: E501

        Returns subscription balances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_balances_with_http_info(cid, pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cid: Contact Id (required)
        :param str pid: Loyalty Program Id (required)
        :return: ModelSubscriptionBalanceResp
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cid', 'pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_balances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_subscription_balances`")  # noqa: E501
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_subscription_balances`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelSubscriptionBalanceResp',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_balance_programs_pid_active_balance_get(self, pid, contact_id, balance_definition_id, **kwargs):  # noqa: E501
        """Get Active Balances API  # noqa: E501

        Returns Active Balances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_active_balance_get(pid, contact_id, balance_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int contact_id: Contact ID (required)
        :param str balance_definition_id: Balance Definition ID (required)
        :param int limit: Limit
        :param int offset: Offset
        :param str sort_field: Sort Field
        :param str sort: Sort Order
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_balance_programs_pid_active_balance_get_with_http_info(pid, contact_id, balance_definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_balance_programs_pid_active_balance_get_with_http_info(pid, contact_id, balance_definition_id, **kwargs)  # noqa: E501
            return data

    def loyalty_balance_programs_pid_active_balance_get_with_http_info(self, pid, contact_id, balance_definition_id, **kwargs):  # noqa: E501
        """Get Active Balances API  # noqa: E501

        Returns Active Balances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_active_balance_get_with_http_info(pid, contact_id, balance_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int contact_id: Contact ID (required)
        :param str balance_definition_id: Balance Definition ID (required)
        :param int limit: Limit
        :param int offset: Offset
        :param str sort_field: Sort Field
        :param str sort: Sort Order
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'contact_id', 'balance_definition_id', 'limit', 'offset', 'sort_field', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_balance_programs_pid_active_balance_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_balance_programs_pid_active_balance_get`")  # noqa: E501
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params or
                params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `loyalty_balance_programs_pid_active_balance_get`")  # noqa: E501
        # verify the required parameter 'balance_definition_id' is set
        if ('balance_definition_id' not in params or
                params['balance_definition_id'] is None):
            raise ValueError("Missing the required parameter `balance_definition_id` when calling `loyalty_balance_programs_pid_active_balance_get`")  # noqa: E501

        if 'contact_id' in params and params['contact_id'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `contact_id` when calling `loyalty_balance_programs_pid_active_balance_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'limit' in params and params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_balance_programs_pid_active_balance_get`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_balance_programs_pid_active_balance_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `loyalty_balance_programs_pid_active_balance_get`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sort_field', params['sort_field']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'contact_id' in params:
            query_params.append(('contact_id', params['contact_id']))  # noqa: E501
        if 'balance_definition_id' in params:
            query_params.append(('balance_definition_id', params['balance_definition_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/active-balance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceLimit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_balance_programs_pid_balance_definitions_post(self, pid, body, **kwargs):  # noqa: E501
        """Create balance definition  # noqa: E501

        Creates balance definition and returns information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_balance_definitions_post(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateBalanceDefinitionPayload body: Create Balance Definition Payload (required)
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_balance_programs_pid_balance_definitions_post_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_balance_programs_pid_balance_definitions_post_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def loyalty_balance_programs_pid_balance_definitions_post_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Create balance definition  # noqa: E501

        Creates balance definition and returns information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_balance_definitions_post_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateBalanceDefinitionPayload body: Create Balance Definition Payload (required)
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_balance_programs_pid_balance_definitions_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_balance_programs_pid_balance_definitions_post`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `loyalty_balance_programs_pid_balance_definitions_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_balance_programs_pid_subscriptions_cid_balances_post(self, pid, cid, body, **kwargs):  # noqa: E501
        """Create subscription balances  # noqa: E501

        Creates a balance for a contact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_subscriptions_cid_balances_post(pid, cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str cid: Contact Id (required)
        :param CreateBalancePayload body: Create Balnce Payload (required)
        :return: Balance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_balance_programs_pid_subscriptions_cid_balances_post_with_http_info(pid, cid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_balance_programs_pid_subscriptions_cid_balances_post_with_http_info(pid, cid, body, **kwargs)  # noqa: E501
            return data

    def loyalty_balance_programs_pid_subscriptions_cid_balances_post_with_http_info(self, pid, cid, body, **kwargs):  # noqa: E501
        """Create subscription balances  # noqa: E501

        Creates a balance for a contact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_subscriptions_cid_balances_post_with_http_info(pid, cid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str cid: Contact Id (required)
        :param CreateBalancePayload body: Create Balnce Payload (required)
        :return: Balance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'cid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_balance_programs_pid_subscriptions_cid_balances_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_balance_programs_pid_subscriptions_cid_balances_post`")  # noqa: E501
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `loyalty_balance_programs_pid_subscriptions_cid_balances_post`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `loyalty_balance_programs_pid_subscriptions_cid_balances_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Balance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_balance_programs_pid_transaction_history_get(self, pid, contact_id, balance_definition_id, **kwargs):  # noqa: E501
        """Get Transaction History API  # noqa: E501

        Returns transaction history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_transaction_history_get(pid, contact_id, balance_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int contact_id: Contact ID (required)
        :param str balance_definition_id: Balance Definition ID (required)
        :param int limit: Limit the number of records returned
        :param int offset: Skip a number of records
        :param str sort_field: Field to sort by
        :param str sort: Sort order, either asc or desc
        :param list[str] filters: Filters to apply
        :return: TransactionHistoryResp
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_balance_programs_pid_transaction_history_get_with_http_info(pid, contact_id, balance_definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_balance_programs_pid_transaction_history_get_with_http_info(pid, contact_id, balance_definition_id, **kwargs)  # noqa: E501
            return data

    def loyalty_balance_programs_pid_transaction_history_get_with_http_info(self, pid, contact_id, balance_definition_id, **kwargs):  # noqa: E501
        """Get Transaction History API  # noqa: E501

        Returns transaction history  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_balance_programs_pid_transaction_history_get_with_http_info(pid, contact_id, balance_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param int contact_id: Contact ID (required)
        :param str balance_definition_id: Balance Definition ID (required)
        :param int limit: Limit the number of records returned
        :param int offset: Skip a number of records
        :param str sort_field: Field to sort by
        :param str sort: Sort order, either asc or desc
        :param list[str] filters: Filters to apply
        :return: TransactionHistoryResp
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'contact_id', 'balance_definition_id', 'limit', 'offset', 'sort_field', 'sort', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_balance_programs_pid_transaction_history_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_balance_programs_pid_transaction_history_get`")  # noqa: E501
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params or
                params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `loyalty_balance_programs_pid_transaction_history_get`")  # noqa: E501
        # verify the required parameter 'balance_definition_id' is set
        if ('balance_definition_id' not in params or
                params['balance_definition_id'] is None):
            raise ValueError("Missing the required parameter `balance_definition_id` when calling `loyalty_balance_programs_pid_transaction_history_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sort_field', params['sort_field']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'contact_id' in params:
            query_params.append(('contact_id', params['contact_id']))  # noqa: E501
        if 'balance_definition_id' in params:
            query_params.append(('balance_definition_id', params['balance_definition_id']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
            collection_formats['filters'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/transaction-history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionHistoryResp',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_balance_definition(self, pid, bdid, body, **kwargs):  # noqa: E501
        """Update balance definition  # noqa: E501

        Updates Balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_balance_definition(pid, bdid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param UpdateBalanceDefinitionPayload body: Update Balance Definition Payload (required)
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_balance_definition_with_http_info(pid, bdid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_balance_definition_with_http_info(pid, bdid, body, **kwargs)  # noqa: E501
            return data

    def update_balance_definition_with_http_info(self, pid, bdid, body, **kwargs):  # noqa: E501
        """Update balance definition  # noqa: E501

        Updates Balance definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_balance_definition_with_http_info(pid, bdid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param UpdateBalanceDefinitionPayload body: Update Balance Definition Payload (required)
        :return: BalanceDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_balance_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `update_balance_definition`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `update_balance_definition`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_balance_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceDefinition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_balance_limit(self, pid, bdid, blid, body, **kwargs):  # noqa: E501
        """Updates balance limit  # noqa: E501

        Updates balance limit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_balance_limit(pid, bdid, blid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :param UpdateBalanceLimitPayload body: Balance Limits Payload (required)
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_balance_limit_with_http_info(pid, bdid, blid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_balance_limit_with_http_info(pid, bdid, blid, body, **kwargs)  # noqa: E501
            return data

    def update_balance_limit_with_http_info(self, pid, bdid, blid, body, **kwargs):  # noqa: E501
        """Updates balance limit  # noqa: E501

        Updates balance limit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_balance_limit_with_http_info(pid, bdid, blid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str bdid: Balance Definition Id (required)
        :param str blid: Balance Limit Id (required)
        :param UpdateBalanceLimitPayload body: Balance Limits Payload (required)
        :return: BalanceLimit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'bdid', 'blid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_balance_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `update_balance_limit`")  # noqa: E501
        # verify the required parameter 'bdid' is set
        if ('bdid' not in params or
                params['bdid'] is None):
            raise ValueError("Missing the required parameter `bdid` when calling `update_balance_limit`")  # noqa: E501
        # verify the required parameter 'blid' is set
        if ('blid' not in params or
                params['blid'] is None):
            raise ValueError("Missing the required parameter `blid` when calling `update_balance_limit`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_balance_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'bdid' in params:
            path_params['bdid'] = params['bdid']  # noqa: E501
        if 'blid' in params:
            path_params['blid'] = params['blid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalanceLimit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
