# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class CustomObjectsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def getrecords(self, object_type, limit, page_num, **kwargs):  # noqa: E501
        """Get the list of object records and total records count for an object.  # noqa: E501

        This API retrieves a list of object records along with their associated records and provides the total count of records for the specified object.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.getrecords(object_type, limit, page_num, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object object_type: object type for the attribute (required)
        :param object limit: Number of records returned per page (required)
        :param object page_num: Page number for pagination. It's used to fetch the object records on a provided page number. Must be a valid positive integer. (required)
        :param object sort: Sort order, must be 'asc' or 'desc'. Default to 'desc' if not provided.
        :param object association: Whether to include associations, must be 'true' or 'false'. Default to 'false' if not provided.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.getrecords_with_http_info(object_type, limit, page_num, **kwargs)  # noqa: E501
        else:
            (data) = self.getrecords_with_http_info(object_type, limit, page_num, **kwargs)  # noqa: E501
            return data

    def getrecords_with_http_info(self, object_type, limit, page_num, **kwargs):  # noqa: E501
        """Get the list of object records and total records count for an object.  # noqa: E501

        This API retrieves a list of object records along with their associated records and provides the total count of records for the specified object.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.getrecords_with_http_info(object_type, limit, page_num, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object object_type: object type for the attribute (required)
        :param object limit: Number of records returned per page (required)
        :param object page_num: Page number for pagination. It's used to fetch the object records on a provided page number. Must be a valid positive integer. (required)
        :param object sort: Sort order, must be 'asc' or 'desc'. Default to 'desc' if not provided.
        :param object association: Whether to include associations, must be 'true' or 'false'. Default to 'false' if not provided.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['object_type', 'limit', 'page_num', 'sort', 'association']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method getrecords" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params or
                params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `getrecords`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `getrecords`")  # noqa: E501
        # verify the required parameter 'page_num' is set
        if ('page_num' not in params or
                params['page_num'] is None):
            raise ValueError("Missing the required parameter `page_num` when calling `getrecords`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_type' in params:
            path_params['object_type'] = params['object_type']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page_num' in params:
            query_params.append(('page_num', params['page_num']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'association' in params:
            query_params.append(('association', params['association']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/objects/{object_type}/records', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsertrecords(self, object_type, **kwargs):  # noqa: E501
        """Create/Update object records in bulk  # noqa: E501

        This API allows bulk upsert of object records in a single request. Each object record may include   - Attributes   - Identifiers   - Associations  **Response:**   The API processes the request asynchronously and returns a processId that you can use to track the background process status.  **API and Schema Limitation:**   - Size:       - Max 1000 objects records per request       - Max request body size: 1 MB    - Max 500 attributes defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 500 attributes.     - Worth noting: Nothing happens If an attribute is mentioned in the request, but was not previously defined for the object schema (no error, no attribute creation)    - Max 10 associations defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 10 associations with other objects. and each object record can be linked to max 10 other records.  **Errors:**     - Make sure both object records exist before associating them, else the API will return an error.     - This route does not create objects. The object where the object records are upserted by this API must be created already else the API will return an error \"invalid object type\".   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsertrecords(object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object object_type: object type for the attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upsertrecords_with_http_info(object_type, **kwargs)  # noqa: E501
        else:
            (data) = self.upsertrecords_with_http_info(object_type, **kwargs)  # noqa: E501
            return data

    def upsertrecords_with_http_info(self, object_type, **kwargs):  # noqa: E501
        """Create/Update object records in bulk  # noqa: E501

        This API allows bulk upsert of object records in a single request. Each object record may include   - Attributes   - Identifiers   - Associations  **Response:**   The API processes the request asynchronously and returns a processId that you can use to track the background process status.  **API and Schema Limitation:**   - Size:       - Max 1000 objects records per request       - Max request body size: 1 MB    - Max 500 attributes defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 500 attributes.     - Worth noting: Nothing happens If an attribute is mentioned in the request, but was not previously defined for the object schema (no error, no attribute creation)    - Max 10 associations defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 10 associations with other objects. and each object record can be linked to max 10 other records.  **Errors:**     - Make sure both object records exist before associating them, else the API will return an error.     - This route does not create objects. The object where the object records are upserted by this API must be created already else the API will return an error \"invalid object type\".   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsertrecords_with_http_info(object_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object object_type: object type for the attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['object_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsertrecords" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params or
                params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `upsertrecords`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'object_type' in params:
            path_params['object_type'] = params['object_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/objects/{object_type}/batch/upsert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
