# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class DomainsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def authenticate_domain(self, domain_name, **kwargs):  # noqa: E501
        """Authenticate a domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_domain(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: AuthenticateDomainModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_domain_with_http_info(domain_name, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_domain_with_http_info(domain_name, **kwargs)  # noqa: E501
            return data

    def authenticate_domain_with_http_info(self, domain_name, **kwargs):  # noqa: E501
        """Authenticate a domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_domain_with_http_info(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: AuthenticateDomainModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params or
                params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `authenticate_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/domains/{domainName}/authenticate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthenticateDomainModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_domain(self, **kwargs):  # noqa: E501
        """Create a new domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_domain(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDomain domain_name: domain's name
        :return: CreateDomainModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_domain_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_domain_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_domain_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_domain_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDomain domain_name: domain's name
        :return: CreateDomainModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_domain" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'domain_name' in params:
            body_params = params['domain_name']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/domains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDomainModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_domain(self, domain_name, **kwargs):  # noqa: E501
        """Delete a domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_domain(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_domain_with_http_info(domain_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_domain_with_http_info(domain_name, **kwargs)  # noqa: E501
            return data

    def delete_domain_with_http_info(self, domain_name, **kwargs):  # noqa: E501
        """Delete a domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_domain_with_http_info(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params or
                params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `delete_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/domains/{domainName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_domain_configuration(self, domain_name, **kwargs):  # noqa: E501
        """Validate domain configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_domain_configuration(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: GetDomainConfigurationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_domain_configuration_with_http_info(domain_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_domain_configuration_with_http_info(domain_name, **kwargs)  # noqa: E501
            return data

    def get_domain_configuration_with_http_info(self, domain_name, **kwargs):  # noqa: E501
        """Validate domain configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_domain_configuration_with_http_info(domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain_name: Domain name (required)
        :return: GetDomainConfigurationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_domain_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params or
                params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `get_domain_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/domains/{domainName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDomainConfigurationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_domains(self, **kwargs):  # noqa: E501
        """Get the list of all your domains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_domains(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetDomainsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_domains_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_domains_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_domains_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of all your domains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_domains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetDomainsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_domains" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/domains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDomainsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
