# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class EcommerceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_batch_order(self, order_batch, **kwargs):  # noqa: E501
        """Create orders in batch  # noqa: E501

        Create multiple orders at one time instead of one order at a time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_batch_order(order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderBatch order_batch: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_batch_order_with_http_info(order_batch, **kwargs)  # noqa: E501
        else:
            (data) = self.create_batch_order_with_http_info(order_batch, **kwargs)  # noqa: E501
            return data

    def create_batch_order_with_http_info(self, order_batch, **kwargs):  # noqa: E501
        """Create orders in batch  # noqa: E501

        Create multiple orders at one time instead of one order at a time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_batch_order_with_http_info(order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderBatch order_batch: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_batch_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_batch' is set
        if ('order_batch' not in params or
                params['order_batch'] is None):
            raise ValueError("Missing the required parameter `order_batch` when calling `create_batch_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_batch' in params:
            body_params = params['order_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/orders/status/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_order(self, order, **kwargs):  # noqa: E501
        """Managing the status of the order  # noqa: E501

        Manages the transactional status of the order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order(order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_order_with_http_info(order, **kwargs)  # noqa: E501
        else:
            (data) = self.create_order_with_http_info(order, **kwargs)  # noqa: E501
            return data

    def create_order_with_http_info(self, order, **kwargs):  # noqa: E501
        """Managing the status of the order  # noqa: E501

        Manages the transactional status of the order  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_with_http_info(order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `create_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in params:
            body_params = params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/orders/status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_update_batch_category(self, create_update_batch_category, **kwargs):  # noqa: E501
        """Create categories in batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_batch_category(create_update_batch_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateBatchCategory create_update_batch_category: Values to create a batch of categories (required)
        :return: CreateUpdateBatchCategoryModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_update_batch_category_with_http_info(create_update_batch_category, **kwargs)  # noqa: E501
        else:
            (data) = self.create_update_batch_category_with_http_info(create_update_batch_category, **kwargs)  # noqa: E501
            return data

    def create_update_batch_category_with_http_info(self, create_update_batch_category, **kwargs):  # noqa: E501
        """Create categories in batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_batch_category_with_http_info(create_update_batch_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateBatchCategory create_update_batch_category: Values to create a batch of categories (required)
        :return: CreateUpdateBatchCategoryModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_update_batch_category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_update_batch_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_update_batch_category' is set
        if ('create_update_batch_category' not in params or
                params['create_update_batch_category'] is None):
            raise ValueError("Missing the required parameter `create_update_batch_category` when calling `create_update_batch_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_update_batch_category' in params:
            body_params = params['create_update_batch_category']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/categories/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateUpdateBatchCategoryModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_update_batch_products(self, create_update_batch_products, **kwargs):  # noqa: E501
        """Create products in batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_batch_products(create_update_batch_products, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateBatchProducts create_update_batch_products: Values to create a batch of products (required)
        :return: CreateUpdateBatchProductsModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_update_batch_products_with_http_info(create_update_batch_products, **kwargs)  # noqa: E501
        else:
            (data) = self.create_update_batch_products_with_http_info(create_update_batch_products, **kwargs)  # noqa: E501
            return data

    def create_update_batch_products_with_http_info(self, create_update_batch_products, **kwargs):  # noqa: E501
        """Create products in batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_batch_products_with_http_info(create_update_batch_products, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateBatchProducts create_update_batch_products: Values to create a batch of products (required)
        :return: CreateUpdateBatchProductsModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_update_batch_products']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_update_batch_products" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_update_batch_products' is set
        if ('create_update_batch_products' not in params or
                params['create_update_batch_products'] is None):
            raise ValueError("Missing the required parameter `create_update_batch_products` when calling `create_update_batch_products`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_update_batch_products' in params:
            body_params = params['create_update_batch_products']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/products/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateUpdateBatchProductsModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_update_category(self, create_update_category, **kwargs):  # noqa: E501
        """Create/Update a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_category(create_update_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateCategory create_update_category: Values to create/update a category (required)
        :return: CreateCategoryModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_update_category_with_http_info(create_update_category, **kwargs)  # noqa: E501
        else:
            (data) = self.create_update_category_with_http_info(create_update_category, **kwargs)  # noqa: E501
            return data

    def create_update_category_with_http_info(self, create_update_category, **kwargs):  # noqa: E501
        """Create/Update a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_category_with_http_info(create_update_category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateCategory create_update_category: Values to create/update a category (required)
        :return: CreateCategoryModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_update_category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_update_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_update_category' is set
        if ('create_update_category' not in params or
                params['create_update_category'] is None):
            raise ValueError("Missing the required parameter `create_update_category` when calling `create_update_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_update_category' in params:
            body_params = params['create_update_category']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/categories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCategoryModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_update_product(self, create_update_product, **kwargs):  # noqa: E501
        """Create/Update a product  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_product(create_update_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateProduct create_update_product: Values to create/update a product (required)
        :return: CreateProductModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_update_product_with_http_info(create_update_product, **kwargs)  # noqa: E501
        else:
            (data) = self.create_update_product_with_http_info(create_update_product, **kwargs)  # noqa: E501
            return data

    def create_update_product_with_http_info(self, create_update_product, **kwargs):  # noqa: E501
        """Create/Update a product  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_update_product_with_http_info(create_update_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUpdateProduct create_update_product: Values to create/update a product (required)
        :return: CreateProductModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_update_product']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_update_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_update_product' is set
        if ('create_update_product' not in params or
                params['create_update_product'] is None):
            raise ValueError("Missing the required parameter `create_update_product` when calling `create_update_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_update_product' in params:
            body_params = params['create_update_product']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/products', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateProductModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ecommerce_activate_post(self, **kwargs):  # noqa: E501
        """Activate the eCommerce app  # noqa: E501

        Getting access to Brevo eCommerce.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_activate_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ecommerce_activate_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ecommerce_activate_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def ecommerce_activate_post_with_http_info(self, **kwargs):  # noqa: E501
        """Activate the eCommerce app  # noqa: E501

        Getting access to Brevo eCommerce.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_activate_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ecommerce_activate_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/activate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ecommerce_attribution_metrics_conversion_source_conversion_source_id_get(self, conversion_source, conversion_source_id, **kwargs):  # noqa: E501
        """Get detailed attribution metrics for a single Brevo campaign or workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_metrics_conversion_source_conversion_source_id_get(conversion_source, conversion_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversion_source: The Brevo campaign type or workflow type for which data will be retrieved (required)
        :param str conversion_source_id: The Brevo campaign or automation workflow id for which data will be retrieved (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ecommerce_attribution_metrics_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ecommerce_attribution_metrics_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, **kwargs)  # noqa: E501
            return data

    def ecommerce_attribution_metrics_conversion_source_conversion_source_id_get_with_http_info(self, conversion_source, conversion_source_id, **kwargs):  # noqa: E501
        """Get detailed attribution metrics for a single Brevo campaign or workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_metrics_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversion_source: The Brevo campaign type or workflow type for which data will be retrieved (required)
        :param str conversion_source_id: The Brevo campaign or automation workflow id for which data will be retrieved (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversion_source', 'conversion_source_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ecommerce_attribution_metrics_conversion_source_conversion_source_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversion_source' is set
        if ('conversion_source' not in params or
                params['conversion_source'] is None):
            raise ValueError("Missing the required parameter `conversion_source` when calling `ecommerce_attribution_metrics_conversion_source_conversion_source_id_get`")  # noqa: E501
        # verify the required parameter 'conversion_source_id' is set
        if ('conversion_source_id' not in params or
                params['conversion_source_id'] is None):
            raise ValueError("Missing the required parameter `conversion_source_id` when calling `ecommerce_attribution_metrics_conversion_source_conversion_source_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversion_source' in params:
            path_params['conversionSource'] = params['conversion_source']  # noqa: E501
        if 'conversion_source_id' in params:
            path_params['conversionSourceId'] = params['conversion_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/attribution/metrics/{conversionSource}/{conversionSourceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2007',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ecommerce_attribution_metrics_get(self, **kwargs):  # noqa: E501
        """Get attribution metrics for one or more Brevo campaigns or workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_metrics_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime period_from: When getting metrics for a specific period, define the starting datetime in RFC3339 format
        :param datetime period_to: When getting metrics for a specific period, define the end datetime in RFC3339 format
        :param list[str] email_campaign_id: The email campaign ID(s) to get metrics for
        :param list[str] sms_campaign_id: The SMS campaign ID(s) to get metrics for
        :param list[str] automation_workflow_email_id: The automation workflow ID(s) to get email attribution metrics for
        :param list[str] automation_workflow_sms_id: The automation workflow ID(s) to get SMS attribution metrics for
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ecommerce_attribution_metrics_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ecommerce_attribution_metrics_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def ecommerce_attribution_metrics_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get attribution metrics for one or more Brevo campaigns or workflows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_metrics_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime period_from: When getting metrics for a specific period, define the starting datetime in RFC3339 format
        :param datetime period_to: When getting metrics for a specific period, define the end datetime in RFC3339 format
        :param list[str] email_campaign_id: The email campaign ID(s) to get metrics for
        :param list[str] sms_campaign_id: The SMS campaign ID(s) to get metrics for
        :param list[str] automation_workflow_email_id: The automation workflow ID(s) to get email attribution metrics for
        :param list[str] automation_workflow_sms_id: The automation workflow ID(s) to get SMS attribution metrics for
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['period_from', 'period_to', 'email_campaign_id', 'sms_campaign_id', 'automation_workflow_email_id', 'automation_workflow_sms_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ecommerce_attribution_metrics_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'period_from' in params:
            query_params.append(('periodFrom', params['period_from']))  # noqa: E501
        if 'period_to' in params:
            query_params.append(('periodTo', params['period_to']))  # noqa: E501
        if 'email_campaign_id' in params:
            query_params.append(('emailCampaignId[]', params['email_campaign_id']))  # noqa: E501
            collection_formats['emailCampaignId[]'] = 'csv'  # noqa: E501
        if 'sms_campaign_id' in params:
            query_params.append(('smsCampaignId[]', params['sms_campaign_id']))  # noqa: E501
            collection_formats['smsCampaignId[]'] = 'csv'  # noqa: E501
        if 'automation_workflow_email_id' in params:
            query_params.append(('automationWorkflowEmailId[]', params['automation_workflow_email_id']))  # noqa: E501
            collection_formats['automationWorkflowEmailId[]'] = 'csv'  # noqa: E501
        if 'automation_workflow_sms_id' in params:
            query_params.append(('automationWorkflowSmsId[]', params['automation_workflow_sms_id']))  # noqa: E501
            collection_formats['automationWorkflowSmsId[]'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/attribution/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ecommerce_attribution_products_conversion_source_conversion_source_id_get(self, conversion_source, conversion_source_id, **kwargs):  # noqa: E501
        """Get attributed product sales for a single Brevo campaign or workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_products_conversion_source_conversion_source_id_get(conversion_source, conversion_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversion_source: The Brevo campaign or automation workflow type for which data will be retrieved (required)
        :param str conversion_source_id: The Brevo campaign or automation workflow id for which data will be retrieved (required)
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ecommerce_attribution_products_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.ecommerce_attribution_products_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, **kwargs)  # noqa: E501
            return data

    def ecommerce_attribution_products_conversion_source_conversion_source_id_get_with_http_info(self, conversion_source, conversion_source_id, **kwargs):  # noqa: E501
        """Get attributed product sales for a single Brevo campaign or workflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_attribution_products_conversion_source_conversion_source_id_get_with_http_info(conversion_source, conversion_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversion_source: The Brevo campaign or automation workflow type for which data will be retrieved (required)
        :param str conversion_source_id: The Brevo campaign or automation workflow id for which data will be retrieved (required)
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversion_source', 'conversion_source_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ecommerce_attribution_products_conversion_source_conversion_source_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversion_source' is set
        if ('conversion_source' not in params or
                params['conversion_source'] is None):
            raise ValueError("Missing the required parameter `conversion_source` when calling `ecommerce_attribution_products_conversion_source_conversion_source_id_get`")  # noqa: E501
        # verify the required parameter 'conversion_source_id' is set
        if ('conversion_source_id' not in params or
                params['conversion_source_id'] is None):
            raise ValueError("Missing the required parameter `conversion_source_id` when calling `ecommerce_attribution_products_conversion_source_conversion_source_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversion_source' in params:
            path_params['conversionSource'] = params['conversion_source']  # noqa: E501
        if 'conversion_source_id' in params:
            path_params['conversionSourceId'] = params['conversion_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/attribution/products/{conversionSource}/{conversionSourceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2008',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ecommerce_config_display_currency_get(self, **kwargs):  # noqa: E501
        """Get the ISO 4217 compliant display currency code for your Brevo account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_config_display_currency_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ecommerce_config_display_currency_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.ecommerce_config_display_currency_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def ecommerce_config_display_currency_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get the ISO 4217 compliant display currency code for your Brevo account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ecommerce_config_display_currency_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ecommerce_config_display_currency_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/config/displayCurrency', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_categories(self, **kwargs):  # noqa: E501
        """Return all your categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param list[str] ids: Filter by category ids
        :param str name: Filter by category name
        :param str modified_since: Filter (urlencoded) the categories modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the categories created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_categories_with_http_info(self, **kwargs):  # noqa: E501
        """Return all your categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param list[str] ids: Filter by category ids
        :param str name: Filter by category name
        :param str modified_since: Filter (urlencoded) the categories modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the categories created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'sort', 'ids', 'name', 'modified_since', 'created_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_categories" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_categories`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'ids' in params:
            query_params.append(('ids', params['ids']))  # noqa: E501
            collection_formats['ids'] = 'csv'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'modified_since' in params:
            query_params.append(('modifiedSince', params['modified_since']))  # noqa: E501
        if 'created_since' in params:
            query_params.append(('createdSince', params['created_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCategories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_category_info(self, id, **kwargs):  # noqa: E501
        """Get a category details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Category ID (required)
        :return: GetCategoryDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_category_info_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_category_info_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_category_info_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a category details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_info_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Category ID (required)
        :return: GetCategoryDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_category_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_category_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/categories/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetCategoryDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_orders(self, **kwargs):  # noqa: E501
        """Get order details  # noqa: E501

        Get all the orders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param str modified_since: Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetOrders
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orders_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_orders_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Get order details  # noqa: E501

        Get all the orders  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param str modified_since: Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetOrders
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'sort', 'modified_since', 'created_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_orders`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'modified_since' in params:
            query_params.append(('modifiedSince', params['modified_since']))  # noqa: E501
        if 'created_since' in params:
            query_params.append(('createdSince', params['created_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetOrders',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_info(self, id, **kwargs):  # noqa: E501
        """Get a product's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Product ID (required)
        :return: GetProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_info_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_info_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_product_info_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a product's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_info_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Product ID (required)
        :return: GetProductDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_product_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/products/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetProductDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_products(self, **kwargs):  # noqa: E501
        """Return all your products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param list[str] ids: Filter by product ids
        :param str name: Filter by product name, minimum 3 characters should be present for search
        :param float price_lte: Price filter for products less than and equals to particular amount
        :param float price_gte: Price filter for products greater than and equals to particular amount
        :param float price_lt: Price filter for products less than particular amount
        :param float price_gt: Price filter for products greater than particular amount
        :param float price_eq: Price filter for products equals to particular amount
        :param float price_ne: Price filter for products not equals to particular amount
        :param list[str] categories: Filter by category ids
        :param str modified_since: Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetProducts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_products_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_products_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_products_with_http_info(self, **kwargs):  # noqa: E501
        """Return all your products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed
        :param list[str] ids: Filter by product ids
        :param str name: Filter by product name, minimum 3 characters should be present for search
        :param float price_lte: Price filter for products less than and equals to particular amount
        :param float price_gte: Price filter for products greater than and equals to particular amount
        :param float price_lt: Price filter for products less than particular amount
        :param float price_gt: Price filter for products greater than particular amount
        :param float price_eq: Price filter for products equals to particular amount
        :param float price_ne: Price filter for products not equals to particular amount
        :param list[str] categories: Filter by category ids
        :param str modified_since: Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :param str created_since: Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.** 
        :return: GetProducts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'sort', 'ids', 'name', 'price_lte', 'price_gte', 'price_lt', 'price_gt', 'price_eq', 'price_ne', 'categories', 'modified_since', 'created_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_products" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_products`, must be a value less than or equal to `1000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'ids' in params:
            query_params.append(('ids', params['ids']))  # noqa: E501
            collection_formats['ids'] = 'csv'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'price_lte' in params:
            query_params.append(('price[lte]', params['price_lte']))  # noqa: E501
        if 'price_gte' in params:
            query_params.append(('price[gte]', params['price_gte']))  # noqa: E501
        if 'price_lt' in params:
            query_params.append(('price[lt]', params['price_lt']))  # noqa: E501
        if 'price_gt' in params:
            query_params.append(('price[gt]', params['price_gt']))  # noqa: E501
        if 'price_eq' in params:
            query_params.append(('price[eq]', params['price_eq']))  # noqa: E501
        if 'price_ne' in params:
            query_params.append(('price[ne]', params['price_ne']))  # noqa: E501
        if 'categories' in params:
            query_params.append(('categories', params['categories']))  # noqa: E501
            collection_formats['categories'] = 'csv'  # noqa: E501
        if 'modified_since' in params:
            query_params.append(('modifiedSince', params['modified_since']))  # noqa: E501
        if 'created_since' in params:
            query_params.append(('createdSince', params['created_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetProducts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_config_display_currency(self, set_config_display_currency, **kwargs):  # noqa: E501
        """Set the ISO 4217 compliant display currency code for your Brevo account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_config_display_currency(set_config_display_currency, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetConfigDisplayCurrency set_config_display_currency: set ISO 4217 compliant display currency code payload (required)
        :return: SetConfigDisplayCurrency
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_config_display_currency_with_http_info(set_config_display_currency, **kwargs)  # noqa: E501
        else:
            (data) = self.set_config_display_currency_with_http_info(set_config_display_currency, **kwargs)  # noqa: E501
            return data

    def set_config_display_currency_with_http_info(self, set_config_display_currency, **kwargs):  # noqa: E501
        """Set the ISO 4217 compliant display currency code for your Brevo account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_config_display_currency_with_http_info(set_config_display_currency, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SetConfigDisplayCurrency set_config_display_currency: set ISO 4217 compliant display currency code payload (required)
        :return: SetConfigDisplayCurrency
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['set_config_display_currency']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_config_display_currency" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'set_config_display_currency' is set
        if ('set_config_display_currency' not in params or
                params['set_config_display_currency'] is None):
            raise ValueError("Missing the required parameter `set_config_display_currency` when calling `set_config_display_currency`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_config_display_currency' in params:
            body_params = params['set_config_display_currency']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/ecommerce/config/displayCurrency', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SetConfigDisplayCurrency',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
