# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class ProgramApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_new_lp(self, body, **kwargs):  # noqa: E501
        """Create loyalty program  # noqa: E501

        Creates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_new_lp(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateLoyaltyProgramPayload body: Create Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_new_lp_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_new_lp_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_new_lp_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create loyalty program  # noqa: E501

        Creates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_new_lp_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateLoyaltyProgramPayload body: Create Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_lp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_new_lp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_contact_members(self, pid, member_contact_ids, **kwargs):  # noqa: E501
        """Delete subscription member  # noqa: E501

        Deletes member from a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_contact_members(pid, member_contact_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str member_contact_ids: Member Contact Ids (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_contact_members_with_http_info(pid, member_contact_ids, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_contact_members_with_http_info(pid, member_contact_ids, **kwargs)  # noqa: E501
            return data

    def delete_contact_members_with_http_info(self, pid, member_contact_ids, **kwargs):  # noqa: E501
        """Delete subscription member  # noqa: E501

        Deletes member from a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_contact_members_with_http_info(pid, member_contact_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str member_contact_ids: Member Contact Ids (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'member_contact_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contact_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_contact_members`")  # noqa: E501
        # verify the required parameter 'member_contact_ids' is set
        if ('member_contact_ids' not in params or
                params['member_contact_ids'] is None):
            raise ValueError("Missing the required parameter `member_contact_ids` when calling `delete_contact_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'member_contact_ids' in params:
            query_params.append(('memberContactIds', params['member_contact_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}/subscription-members', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_loyalty_program(self, pid, **kwargs):  # noqa: E501
        """Delete Loyalty Program  # noqa: E501

        Deletes Loyalty Program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loyalty_program(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_loyalty_program_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_loyalty_program_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def delete_loyalty_program_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Delete Loyalty Program  # noqa: E501

        Deletes Loyalty Program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_loyalty_program_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_loyalty_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_loyalty_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_loyalty_program_info(self, pid, **kwargs):  # noqa: E501
        """Get loyalty program Info  # noqa: E501

        Returns loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loyalty_program_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_loyalty_program_info_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_loyalty_program_info_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_loyalty_program_info_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Get loyalty program Info  # noqa: E501

        Returns loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loyalty_program_info_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_loyalty_program_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_loyalty_program_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lp_list(self, **kwargs):  # noqa: E501
        """Get loyalty program list  # noqa: E501

        Returns list of loyalty programs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lp_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort_field: Sort documents by field
        :param str sort: Sort the documents in the ascending or descending order
        :return: LoyaltyProgramPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lp_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_lp_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_lp_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get loyalty program list  # noqa: E501

        Returns list of loyalty programs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lp_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents per page
        :param int offset: Index of the first document in the page
        :param str sort_field: Sort documents by field
        :param str sort: Sort the documents in the ascending or descending order
        :return: LoyaltyProgramPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'sort_field', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lp_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sort_field', params['sort_field']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyProgramPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_parameter_subscription_info(self, pid, **kwargs):  # noqa: E501
        """Get Subscription Data  # noqa: E501

        Get Information of balances, tiers, rewards and subscription members for a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_parameter_subscription_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str contact_id: Contact Id
        :param str params: Filter List
        :param str loyalty_subscription_id: Loyalty Subscription Id
        :return: SubscriptionHandlerInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_parameter_subscription_info_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_parameter_subscription_info_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_parameter_subscription_info_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Get Subscription Data  # noqa: E501

        Get Information of balances, tiers, rewards and subscription members for a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_parameter_subscription_info_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param str contact_id: Contact Id
        :param str params: Filter List
        :param str loyalty_subscription_id: Loyalty Subscription Id
        :return: SubscriptionHandlerInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'contact_id', 'params', 'loyalty_subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_parameter_subscription_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_parameter_subscription_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'contact_id' in params:
            query_params.append(('contactId', params['contact_id']))  # noqa: E501
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
        if 'loyalty_subscription_id' in params:
            query_params.append(('loyaltySubscriptionId', params['loyalty_subscription_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}/account-info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionHandlerInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partially_update_loyalty_program(self, pid, body, **kwargs):  # noqa: E501
        """Partially update loyalty program  # noqa: E501

        Partially updates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partially_update_loyalty_program(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param PatchLoyaltyProgramPayload body: Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partially_update_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.partially_update_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def partially_update_loyalty_program_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Partially update loyalty program  # noqa: E501

        Partially updates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partially_update_loyalty_program_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param PatchLoyaltyProgramPayload body: Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partially_update_loyalty_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `partially_update_loyalty_program`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `partially_update_loyalty_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish_loyalty_program(self, pid, **kwargs):  # noqa: E501
        """Publish loyalty program  # noqa: E501

        Publishes loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_loyalty_program(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_loyalty_program_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.publish_loyalty_program_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def publish_loyalty_program_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Publish loyalty program  # noqa: E501

        Publishes loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_loyalty_program_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_loyalty_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `publish_loyalty_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}/publish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscribe_member_to_a_subscription(self, pid, body, **kwargs):  # noqa: E501
        """Create subscription member  # noqa: E501

        Add member to a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_member_to_a_subscription(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param AddSubscriptionMemberPayload body: Add Subscription Member Payload (required)
        :return: SubscriptionMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscribe_member_to_a_subscription_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.subscribe_member_to_a_subscription_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def subscribe_member_to_a_subscription_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Create subscription member  # noqa: E501

        Add member to a subscription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_member_to_a_subscription_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param AddSubscriptionMemberPayload body: Add Subscription Member Payload (required)
        :return: SubscriptionMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_member_to_a_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `subscribe_member_to_a_subscription`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscribe_member_to_a_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}/subscription-members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscribe_to_loyalty_program(self, pid, body, **kwargs):  # noqa: E501
        """Create subscription  # noqa: E501

        Subscribes to a loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_to_loyalty_program(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateSubscriptionPayload body: Create Subscription Payload (required)
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscribe_to_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.subscribe_to_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def subscribe_to_loyalty_program_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Create subscription  # noqa: E501

        Subscribes to a loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_to_loyalty_program_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param CreateSubscriptionPayload body: Create Subscription Payload (required)
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_to_loyalty_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `subscribe_to_loyalty_program`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscribe_to_loyalty_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Subscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_loyalty_program(self, pid, body, **kwargs):  # noqa: E501
        """Update loyalty program  # noqa: E501

        Updates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_loyalty_program(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param UpdateLoyaltyProgramPayload body: Update Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_loyalty_program_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def update_loyalty_program_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Update loyalty program  # noqa: E501

        Updates loyalty program  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_loyalty_program_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program Id (required)
        :param UpdateLoyaltyProgramPayload body: Update Loyalty Program Payload (required)
        :return: LoyaltyProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_loyalty_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `update_loyalty_program`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_loyalty_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/config/programs/{pid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
