# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class RewardApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_code_count(self, pid, cpid, **kwargs):  # noqa: E501
        """Get code count  # noqa: E501

        Get code count  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_code_count(pid, cpid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str cpid: Code Pool ID (required)
        :return: MainCodeCountHttpResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_code_count_with_http_info(pid, cpid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_code_count_with_http_info(pid, cpid, **kwargs)  # noqa: E501
            return data

    def get_code_count_with_http_info(self, pid, cpid, **kwargs):  # noqa: E501
        """Get code count  # noqa: E501

        Get code count  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_code_count_with_http_info(pid, cpid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str cpid: Code Pool ID (required)
        :return: MainCodeCountHttpResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'cpid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_code_count" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_code_count`")  # noqa: E501
        # verify the required parameter 'cpid' is set
        if ('cpid' not in params or
                params['cpid'] is None):
            raise ValueError("Missing the required parameter `cpid` when calling `get_code_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'cpid' in params:
            path_params['cpid'] = params['cpid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/code-pools/{cpid}/codes-count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainCodeCountHttpResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_offers_get(self, pid, **kwargs):  # noqa: E501
        """Get Reward Page API  # noqa: E501

        Returns a reward page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_offers_get(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param int limit: Page size
        :param int offset: Pagination offset
        :param str state: State of the reward
        :param str version: Version
        :return: MainRewardPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_offers_get_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_offers_get_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_offers_get_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Get Reward Page API  # noqa: E501

        Returns a reward page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_offers_get_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param int limit: Page size
        :param int offset: Pagination offset
        :param str state: State of the reward
        :param str version: Version
        :return: MainRewardPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'limit', 'offset', 'state', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_offers_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_offers_get`")  # noqa: E501

        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_offer_programs_pid_offers_get`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_offer_programs_pid_offers_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/offers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainRewardPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_offers_post(self, pid, payload, **kwargs):  # noqa: E501
        """Create a reward  # noqa: E501

        Creates a new reward in loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_offers_post(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainCreateRewardPayload payload: Reward creation payload (required)
        :return: MainCreateRewardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_offers_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_offers_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_offers_post_with_http_info(self, pid, payload, **kwargs):  # noqa: E501
        """Create a reward  # noqa: E501

        Creates a new reward in loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_offers_post_with_http_info(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainCreateRewardPayload payload: Reward creation payload (required)
        :return: MainCreateRewardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_offers_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_offers_post`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `loyalty_offer_programs_pid_offers_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/offers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainCreateRewardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_attribute_post(self, pid, payload, **kwargs):  # noqa: E501
        """Create a voucher  # noqa: E501

        Create a voucher and attribute it to a specific membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_attribute_post(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainAttributeRewardPayload payload: Voucher creation payload (required)
        :return: MainRewardAttribution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_attribute_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_attribute_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_attribute_post_with_http_info(self, pid, payload, **kwargs):  # noqa: E501
        """Create a voucher  # noqa: E501

        Create a voucher and attribute it to a specific membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_attribute_post_with_http_info(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainAttributeRewardPayload payload: Voucher creation payload (required)
        :return: MainRewardAttribution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_attribute_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_attribute_post`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `loyalty_offer_programs_pid_rewards_attribute_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/attribute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainRewardAttribution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_redeem_post(self, pid, payload, **kwargs):  # noqa: E501
        """Create redeem voucher request  # noqa: E501

        Creates a request to redeem a voucher.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_redeem_post(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainCreateRedeemPayload payload: Redeem transaction creation payload (required)
        :return: MainRedeem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_redeem_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_redeem_post_with_http_info(pid, payload, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_redeem_post_with_http_info(self, pid, payload, **kwargs):  # noqa: E501
        """Create redeem voucher request  # noqa: E501

        Creates a request to redeem a voucher.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_redeem_post_with_http_info(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainCreateRedeemPayload payload: Redeem transaction creation payload (required)
        :return: MainRedeem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_redeem_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_redeem_post`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `loyalty_offer_programs_pid_rewards_redeem_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/redeem', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainRedeem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_redeem_tid_complete_post(self, pid, tid, **kwargs):  # noqa: E501
        """Complete redeem voucher request  # noqa: E501

        Completes voucher redeem request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_redeem_tid_complete_post(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Redeem transaction ID (required)
        :return: MainRedeem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_redeem_tid_complete_post_with_http_info(pid, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_redeem_tid_complete_post_with_http_info(pid, tid, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_redeem_tid_complete_post_with_http_info(self, pid, tid, **kwargs):  # noqa: E501
        """Complete redeem voucher request  # noqa: E501

        Completes voucher redeem request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_redeem_tid_complete_post_with_http_info(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Redeem transaction ID (required)
        :return: MainRedeem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_redeem_tid_complete_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_redeem_tid_complete_post`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `loyalty_offer_programs_pid_rewards_redeem_tid_complete_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/redeem/{tid}/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainRedeem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_revoke_delete(self, pid, **kwargs):  # noqa: E501
        """Revoke vouchers  # noqa: E501

        Revoke attributed vouchers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_revoke_delete(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str attributed_reward_ids: Reward Attribution IDs (comma seperated)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_revoke_delete_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_revoke_delete_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_revoke_delete_with_http_info(self, pid, **kwargs):  # noqa: E501
        """Revoke vouchers  # noqa: E501

        Revoke attributed vouchers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_revoke_delete_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str attributed_reward_ids: Reward Attribution IDs (comma seperated)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'attributed_reward_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_revoke_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_revoke_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'attributed_reward_ids' in params:
            query_params.append(('attributedRewardIds', params['attributed_reward_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/revoke', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_rid_get(self, pid, rid, **kwargs):  # noqa: E501
        """Get reward information  # noqa: E501

        Returns reward information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_rid_get(pid, rid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str rid: Reward ID (required)
        :param str version: Version
        :return: MainReward
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_rid_get_with_http_info(pid, rid, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_rid_get_with_http_info(pid, rid, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_rid_get_with_http_info(self, pid, rid, **kwargs):  # noqa: E501
        """Get reward information  # noqa: E501

        Returns reward information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_rid_get_with_http_info(pid, rid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str rid: Reward ID (required)
        :param str version: Version
        :return: MainReward
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'rid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_rid_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_rid_get`")  # noqa: E501
        # verify the required parameter 'rid' is set
        if ('rid' not in params or
                params['rid'] is None):
            raise ValueError("Missing the required parameter `rid` when calling `loyalty_offer_programs_pid_rewards_rid_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'rid' in params:
            path_params['rid'] = params['rid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/{rid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainReward',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_rewards_validate_post(self, pid, body, **kwargs):  # noqa: E501
        """Validate a reward  # noqa: E501

        Validates a reward.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_validate_post(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainValidateRewardPayload body: Reward validation payload (required)
        :return: MainRewardValidate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_rewards_validate_post_with_http_info(pid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_rewards_validate_post_with_http_info(pid, body, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_rewards_validate_post_with_http_info(self, pid, body, **kwargs):  # noqa: E501
        """Validate a reward  # noqa: E501

        Validates a reward.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_rewards_validate_post_with_http_info(pid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param MainValidateRewardPayload body: Reward validation payload (required)
        :return: MainRewardValidate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_rewards_validate_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_rewards_validate_post`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `loyalty_offer_programs_pid_rewards_validate_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/rewards/validate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainRewardValidate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def loyalty_offer_programs_pid_vouchers_get(self, pid, contact_id, **kwargs):  # noqa: E501
        """Get voucher for a contact  # noqa: E501

        Get voucher for a contact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_vouchers_get(pid, contact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param int contact_id: Contact ID (required)
        :param int limit: Page size
        :param int offset: Pagination offset
        :param str sort: Sort order
        :param str sort_field: Sort field
        :param str metadata_key_value: Metadata value for a Key filter
        :param str reward_id: Reward ID
        :return: MainModelContactRewardsResp
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.loyalty_offer_programs_pid_vouchers_get_with_http_info(pid, contact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.loyalty_offer_programs_pid_vouchers_get_with_http_info(pid, contact_id, **kwargs)  # noqa: E501
            return data

    def loyalty_offer_programs_pid_vouchers_get_with_http_info(self, pid, contact_id, **kwargs):  # noqa: E501
        """Get voucher for a contact  # noqa: E501

        Get voucher for a contact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loyalty_offer_programs_pid_vouchers_get_with_http_info(pid, contact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param int contact_id: Contact ID (required)
        :param int limit: Page size
        :param int offset: Pagination offset
        :param str sort: Sort order
        :param str sort_field: Sort field
        :param str metadata_key_value: Metadata value for a Key filter
        :param str reward_id: Reward ID
        :return: MainModelContactRewardsResp
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'contact_id', 'limit', 'offset', 'sort', 'sort_field', 'metadata_key_value', 'reward_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loyalty_offer_programs_pid_vouchers_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `loyalty_offer_programs_pid_vouchers_get`")  # noqa: E501
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params or
                params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `loyalty_offer_programs_pid_vouchers_get`")  # noqa: E501

        if 'contact_id' in params and params['contact_id'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `contact_id` when calling `loyalty_offer_programs_pid_vouchers_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_offer_programs_pid_vouchers_get`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `loyalty_offer_programs_pid_vouchers_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `loyalty_offer_programs_pid_vouchers_get`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))  # noqa: E501
        if 'contact_id' in params:
            query_params.append(('contactId', params['contact_id']))  # noqa: E501
        if 'metadata_key_value' in params:
            query_params.append(('metadata[key][value]', params['metadata_key_value']))  # noqa: E501
        if 'reward_id' in params:
            query_params.append(('rewardId', params['reward_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/offer/programs/{pid}/vouchers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MainModelContactRewardsResp',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
