# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class SendersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_sender(self, **kwargs):  # noqa: E501
        """Create a new sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sender(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSender sender: sender's name
        :return: CreateSenderModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sender_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_sender_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_sender_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sender_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSender sender: sender's name
        :return: CreateSenderModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sender']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sender" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sender' in params:
            body_params = params['sender']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSenderModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sender(self, sender_id, **kwargs):  # noqa: E501
        """Delete a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sender(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
            return data

    def delete_sender_with_http_info(self, sender_id, **kwargs):  # noqa: E501
        """Delete a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sender_with_http_info(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sender_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sender" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sender_id' is set
        if ('sender_id' not in params or
                params['sender_id'] is None):
            raise ValueError("Missing the required parameter `sender_id` when calling `delete_sender`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sender_id' in params:
            path_params['senderId'] = params['sender_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/{senderId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ips(self, **kwargs):  # noqa: E501
        """Get all the dedicated IPs for your account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ips(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetIps
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ips_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ips_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ips_with_http_info(self, **kwargs):  # noqa: E501
        """Get all the dedicated IPs for your account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ips_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetIps
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ips" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/ips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIps',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ips_from_sender(self, sender_id, **kwargs):  # noqa: E501
        """Get all the dedicated IPs for a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ips_from_sender(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :return: GetIpsFromSender
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ips_from_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ips_from_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
            return data

    def get_ips_from_sender_with_http_info(self, sender_id, **kwargs):  # noqa: E501
        """Get all the dedicated IPs for a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ips_from_sender_with_http_info(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :return: GetIpsFromSender
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sender_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ips_from_sender" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sender_id' is set
        if ('sender_id' not in params or
                params['sender_id'] is None):
            raise ValueError("Missing the required parameter `sender_id` when calling `get_ips_from_sender`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sender_id' in params:
            path_params['senderId'] = params['sender_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/{senderId}/ips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetIpsFromSender',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_senders(self, **kwargs):  # noqa: E501
        """Get the list of all your senders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_senders(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: Filter your senders for a specific ip (available for dedicated IP usage only)
        :param str domain: Filter your senders for a specific domain
        :return: GetSendersList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_senders_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_senders_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_senders_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of all your senders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_senders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: Filter your senders for a specific ip (available for dedicated IP usage only)
        :param str domain: Filter your senders for a specific domain
        :return: GetSendersList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip', 'domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_senders" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ip' in params:
            query_params.append(('ip', params['ip']))  # noqa: E501
        if 'domain' in params:
            query_params.append(('domain', params['domain']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSendersList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sender(self, sender_id, **kwargs):  # noqa: E501
        """Update a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sender(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :param UpdateSender sender: sender's name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sender_with_http_info(sender_id, **kwargs)  # noqa: E501
            return data

    def update_sender_with_http_info(self, sender_id, **kwargs):  # noqa: E501
        """Update a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sender_with_http_info(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :param UpdateSender sender: sender's name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sender_id', 'sender']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sender" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sender_id' is set
        if ('sender_id' not in params or
                params['sender_id'] is None):
            raise ValueError("Missing the required parameter `sender_id` when calling `update_sender`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sender_id' in params:
            path_params['senderId'] = params['sender_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sender' in params:
            body_params = params['sender']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/{senderId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_sender_by_otp(self, sender_id, **kwargs):  # noqa: E501
        """Update a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_sender_by_otp(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :param Otp otp: otp
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_sender_by_otp_with_http_info(sender_id, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_sender_by_otp_with_http_info(sender_id, **kwargs)  # noqa: E501
            return data

    def validate_sender_by_otp_with_http_info(self, sender_id, **kwargs):  # noqa: E501
        """Update a sender  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_sender_by_otp_with_http_info(sender_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sender_id: Id of the sender (required)
        :param Otp otp: otp
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sender_id', 'otp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_sender_by_otp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sender_id' is set
        if ('sender_id' not in params or
                params['sender_id'] is None):
            raise ValueError("Missing the required parameter `sender_id` when calling `validate_sender_by_otp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sender_id' in params:
            path_params['senderId'] = params['sender_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'otp' in params:
            body_params = params['otp']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/senders/{senderId}/validate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
