# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from brevo_python.api_client import ApiClient


class TierApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_subscription_to_tier(self, pid, cid, tid, **kwargs):  # noqa: E501
        """Assign a tier  # noqa: E501

        Manually assigns a tier to a specific membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscription_to_tier(pid, cid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str cid: Contact ID (required)
        :param str tid: Tier ID (required)
        :return: TierForContact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_subscription_to_tier_with_http_info(pid, cid, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_subscription_to_tier_with_http_info(pid, cid, tid, **kwargs)  # noqa: E501
            return data

    def add_subscription_to_tier_with_http_info(self, pid, cid, tid, **kwargs):  # noqa: E501
        """Assign a tier  # noqa: E501

        Manually assigns a tier to a specific membership.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscription_to_tier_with_http_info(pid, cid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str cid: Contact ID (required)
        :param str tid: Tier ID (required)
        :return: TierForContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'cid', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_subscription_to_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `add_subscription_to_tier`")  # noqa: E501
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `add_subscription_to_tier`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `add_subscription_to_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/contacts/{cid}/tiers/{tid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TierForContact',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tier_for_tier_group(self, pid, gid, payload, **kwargs):  # noqa: E501
        """Create a tier  # noqa: E501

        Creates a new tier in a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tier_for_tier_group(pid, gid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param TierRequest payload: (required)
        :return: Tier
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tier_for_tier_group_with_http_info(pid, gid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tier_for_tier_group_with_http_info(pid, gid, payload, **kwargs)  # noqa: E501
            return data

    def create_tier_for_tier_group_with_http_info(self, pid, gid, payload, **kwargs):  # noqa: E501
        """Create a tier  # noqa: E501

        Creates a new tier in a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tier_for_tier_group_with_http_info(pid, gid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param TierRequest payload: (required)
        :return: Tier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'gid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tier_for_tier_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `create_tier_for_tier_group`")  # noqa: E501
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `create_tier_for_tier_group`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `create_tier_for_tier_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups/{gid}/tiers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tier',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tier_group(self, pid, payload, **kwargs):  # noqa: E501
        """Create a tier group  # noqa: E501

        Creates a new tier group in a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tier_group(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param CreateTierGroupRequest payload: Tier group creation payload (required)
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tier_group_with_http_info(pid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tier_group_with_http_info(pid, payload, **kwargs)  # noqa: E501
            return data

    def create_tier_group_with_http_info(self, pid, payload, **kwargs):  # noqa: E501
        """Create a tier group  # noqa: E501

        Creates a new tier group in a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tier_group_with_http_info(pid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param CreateTierGroupRequest payload: Tier group creation payload (required)
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tier_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `create_tier_group`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `create_tier_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TierGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tier(self, pid, tid, **kwargs):  # noqa: E501
        """Delete tier  # noqa: E501

        Deletes a tier from a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tier(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Tier ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tier_with_http_info(pid, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tier_with_http_info(pid, tid, **kwargs)  # noqa: E501
            return data

    def delete_tier_with_http_info(self, pid, tid, **kwargs):  # noqa: E501
        """Delete tier  # noqa: E501

        Deletes a tier from a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tier_with_http_info(pid, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Tier ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_tier`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `delete_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tiers/{tid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tier_group(self, pid, gid, **kwargs):  # noqa: E501
        """Delete tier group  # noqa: E501

        Deletes a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tier_group(pid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tier_group_with_http_info(pid, gid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tier_group_with_http_info(pid, gid, **kwargs)  # noqa: E501
            return data

    def delete_tier_group_with_http_info(self, pid, gid, **kwargs):  # noqa: E501
        """Delete tier group  # noqa: E501

        Deletes a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tier_group_with_http_info(pid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'gid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tier_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `delete_tier_group`")  # noqa: E501
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `delete_tier_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups/{gid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_of_tier_groups(self, pid, **kwargs):  # noqa: E501
        """List tier groups  # noqa: E501

        Returns the list of tier groups defined within the loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_tier_groups(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str version: Select 'active' to retrieve list of all tier groups which are live for clients. Select draft to retrieve list of all non deleted tier groups.
        :return: TierGroupPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_of_tier_groups_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_of_tier_groups_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_list_of_tier_groups_with_http_info(self, pid, **kwargs):  # noqa: E501
        """List tier groups  # noqa: E501

        Returns the list of tier groups defined within the loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_tier_groups_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str version: Select 'active' to retrieve list of all tier groups which are live for clients. Select draft to retrieve list of all non deleted tier groups.
        :return: TierGroupPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_of_tier_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_list_of_tier_groups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TierGroupPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_loyalty_program_tier(self, pid, **kwargs):  # noqa: E501
        """List tiers  # noqa: E501

        Returns the list of tiers defined within the loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loyalty_program_tier(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str version: Select 'active' to retrieve list of all tiers which are live for clients. Select draft to retrieve list of all non deleted tiers.
        :return: LoyaltyTierPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_loyalty_program_tier_with_http_info(pid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_loyalty_program_tier_with_http_info(pid, **kwargs)  # noqa: E501
            return data

    def get_loyalty_program_tier_with_http_info(self, pid, **kwargs):  # noqa: E501
        """List tiers  # noqa: E501

        Returns the list of tiers defined within the loyalty program.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loyalty_program_tier_with_http_info(pid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str version: Select 'active' to retrieve list of all tiers which are live for clients. Select draft to retrieve list of all non deleted tiers.
        :return: LoyaltyTierPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_loyalty_program_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_loyalty_program_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoyaltyTierPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tier_group(self, pid, gid, **kwargs):  # noqa: E501
        """Get tier group  # noqa: E501

        Returns tier group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tier_group(pid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param str version: Select active to retrieve active version of tier group. Select draft to retrieve latest changes in tier group.
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tier_group_with_http_info(pid, gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tier_group_with_http_info(pid, gid, **kwargs)  # noqa: E501
            return data

    def get_tier_group_with_http_info(self, pid, gid, **kwargs):  # noqa: E501
        """Get tier group  # noqa: E501

        Returns tier group information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tier_group_with_http_info(pid, gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param str version: Select active to retrieve active version of tier group. Select draft to retrieve latest changes in tier group.
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'gid', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tier_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `get_tier_group`")  # noqa: E501
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `get_tier_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups/{gid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TierGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tier(self, pid, tid, payload, **kwargs):  # noqa: E501
        """Update tier  # noqa: E501

        Modifies an existing tier for the specified tier group *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tier(pid, tid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Tier ID (required)
        :param TierRequestPutPayload payload: (required)
        :return: Tier
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tier_with_http_info(pid, tid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tier_with_http_info(pid, tid, payload, **kwargs)  # noqa: E501
            return data

    def update_tier_with_http_info(self, pid, tid, payload, **kwargs):  # noqa: E501
        """Update tier  # noqa: E501

        Modifies an existing tier for the specified tier group *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tier_with_http_info(pid, tid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str tid: Tier ID (required)
        :param TierRequestPutPayload payload: (required)
        :return: Tier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'tid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `update_tier`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `update_tier`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `update_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tiers/{tid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tier',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tier_group(self, pid, gid, payload, **kwargs):  # noqa: E501
        """Update tier group  # noqa: E501

        Updates a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tier_group(pid, gid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param UpdateTierGroupRequest payload: Tier group update payload (required)
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tier_group_with_http_info(pid, gid, payload, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tier_group_with_http_info(pid, gid, payload, **kwargs)  # noqa: E501
            return data

    def update_tier_group_with_http_info(self, pid, gid, payload, **kwargs):  # noqa: E501
        """Update tier group  # noqa: E501

        Updates a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tier_group_with_http_info(pid, gid, payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pid: Loyalty Program ID (required)
        :param str gid: Tier group ID (required)
        :param UpdateTierGroupRequest payload: Tier group update payload (required)
        :return: TierGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pid', 'gid', 'payload']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tier_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pid' is set
        if ('pid' not in params or
                params['pid'] is None):
            raise ValueError("Missing the required parameter `pid` when calling `update_tier_group`")  # noqa: E501
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `update_tier_group`")  # noqa: E501
        # verify the required parameter 'payload' is set
        if ('payload' not in params or
                params['payload'] is None):
            raise ValueError("Missing the required parameter `payload` when calling `update_tier_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pid' in params:
            path_params['pid'] = params['pid']  # noqa: E501
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload' in params:
            body_params = params['payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/loyalty/tier/programs/{pid}/tier-groups/{gid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TierGroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
