# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class BalanceLimit(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'balance_definition_id': 'str',
        'constraint_type': 'str',
        'created_at': 'str',
        'duration_unit': 'str',
        'duration_value': 'int',
        'id': 'str',
        'sliding_schedule': 'bool',
        'transaction_type': 'str',
        'updated_at': 'str',
        'value': 'int'
    }

    attribute_map = {
        'balance_definition_id': 'balanceDefinitionId',
        'constraint_type': 'constraintType',
        'created_at': 'createdAt',
        'duration_unit': 'durationUnit',
        'duration_value': 'durationValue',
        'id': 'id',
        'sliding_schedule': 'slidingSchedule',
        'transaction_type': 'transactionType',
        'updated_at': 'updatedAt',
        'value': 'value'
    }

    def __init__(self, balance_definition_id=None, constraint_type=None, created_at=None, duration_unit=None, duration_value=None, id=None, sliding_schedule=None, transaction_type=None, updated_at=None, value=None):  # noqa: E501
        """BalanceLimit - a model defined in Swagger"""  # noqa: E501

        self._balance_definition_id = None
        self._constraint_type = None
        self._created_at = None
        self._duration_unit = None
        self._duration_value = None
        self._id = None
        self._sliding_schedule = None
        self._transaction_type = None
        self._updated_at = None
        self._value = None
        self.discriminator = None

        if balance_definition_id is not None:
            self.balance_definition_id = balance_definition_id
        if constraint_type is not None:
            self.constraint_type = constraint_type
        self.created_at = created_at
        if duration_unit is not None:
            self.duration_unit = duration_unit
        if duration_value is not None:
            self.duration_value = duration_value
        if id is not None:
            self.id = id
        if sliding_schedule is not None:
            self.sliding_schedule = sliding_schedule
        if transaction_type is not None:
            self.transaction_type = transaction_type
        self.updated_at = updated_at
        if value is not None:
            self.value = value

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this BalanceLimit.  # noqa: E501

        balance definition ID  # noqa: E501

        :return: The balance_definition_id of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this BalanceLimit.

        balance definition ID  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this BalanceLimit.  # noqa: E501
        :type: str
        """

        self._balance_definition_id = balance_definition_id

    @property
    def constraint_type(self):
        """Gets the constraint_type of this BalanceLimit.  # noqa: E501

        Defines the type of constraint (e.g., transaction-based or amount-based).  # noqa: E501

        :return: The constraint_type of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._constraint_type

    @constraint_type.setter
    def constraint_type(self, constraint_type):
        """Sets the constraint_type of this BalanceLimit.

        Defines the type of constraint (e.g., transaction-based or amount-based).  # noqa: E501

        :param constraint_type: The constraint_type of this BalanceLimit.  # noqa: E501
        :type: str
        """

        self._constraint_type = constraint_type

    @property
    def created_at(self):
        """Gets the created_at of this BalanceLimit.  # noqa: E501

        Timestamp of when the balance limit was created.  # noqa: E501

        :return: The created_at of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BalanceLimit.

        Timestamp of when the balance limit was created.  # noqa: E501

        :param created_at: The created_at of this BalanceLimit.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def duration_unit(self):
        """Gets the duration_unit of this BalanceLimit.  # noqa: E501

        Time unit for the balance limit (day, week, month, year).  # noqa: E501

        :return: The duration_unit of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._duration_unit

    @duration_unit.setter
    def duration_unit(self, duration_unit):
        """Sets the duration_unit of this BalanceLimit.

        Time unit for the balance limit (day, week, month, year).  # noqa: E501

        :param duration_unit: The duration_unit of this BalanceLimit.  # noqa: E501
        :type: str
        """

        self._duration_unit = duration_unit

    @property
    def duration_value(self):
        """Gets the duration_value of this BalanceLimit.  # noqa: E501

        Number of time units the balance limit applies to.  # noqa: E501

        :return: The duration_value of this BalanceLimit.  # noqa: E501
        :rtype: int
        """
        return self._duration_value

    @duration_value.setter
    def duration_value(self, duration_value):
        """Sets the duration_value of this BalanceLimit.

        Number of time units the balance limit applies to.  # noqa: E501

        :param duration_value: The duration_value of this BalanceLimit.  # noqa: E501
        :type: int
        """

        self._duration_value = duration_value

    @property
    def id(self):
        """Gets the id of this BalanceLimit.  # noqa: E501

        Unique identifier for the balance limit.  # noqa: E501

        :return: The id of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BalanceLimit.

        Unique identifier for the balance limit.  # noqa: E501

        :param id: The id of this BalanceLimit.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def sliding_schedule(self):
        """Gets the sliding_schedule of this BalanceLimit.  # noqa: E501

        Indicates if the limit resets periodically based on a sliding schedule.  # noqa: E501

        :return: The sliding_schedule of this BalanceLimit.  # noqa: E501
        :rtype: bool
        """
        return self._sliding_schedule

    @sliding_schedule.setter
    def sliding_schedule(self, sliding_schedule):
        """Sets the sliding_schedule of this BalanceLimit.

        Indicates if the limit resets periodically based on a sliding schedule.  # noqa: E501

        :param sliding_schedule: The sliding_schedule of this BalanceLimit.  # noqa: E501
        :type: bool
        """

        self._sliding_schedule = sliding_schedule

    @property
    def transaction_type(self):
        """Gets the transaction_type of this BalanceLimit.  # noqa: E501

        Specifies whether the limit applies to credit or debit transactions.  # noqa: E501

        :return: The transaction_type of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this BalanceLimit.

        Specifies whether the limit applies to credit or debit transactions.  # noqa: E501

        :param transaction_type: The transaction_type of this BalanceLimit.  # noqa: E501
        :type: str
        """

        self._transaction_type = transaction_type

    @property
    def updated_at(self):
        """Gets the updated_at of this BalanceLimit.  # noqa: E501

        Timestamp of the last update to the balance limit.  # noqa: E501

        :return: The updated_at of this BalanceLimit.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this BalanceLimit.

        Timestamp of the last update to the balance limit.  # noqa: E501

        :param updated_at: The updated_at of this BalanceLimit.  # noqa: E501
        :type: str
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def value(self):
        """Gets the value of this BalanceLimit.  # noqa: E501

        The maximum allowed value for the defined constraint.  # noqa: E501

        :return: The value of this BalanceLimit.  # noqa: E501
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this BalanceLimit.

        The maximum allowed value for the defined constraint.  # noqa: E501

        :param value: The value of this BalanceLimit.  # noqa: E501
        :type: int
        """

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BalanceLimit, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BalanceLimit):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
