# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class BalanceOrder(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'balance_definition_id': 'str',
        'contact_id': 'int',
        'created_at': 'str',
        'due_at': 'str',
        'expires_at': 'str',
        'id': 'str',
        'loyalty_program_id': 'str',
        'meta': 'object',
        'processed_at': 'str',
        'transactionid': 'str',
        'updated_at': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'balance_definition_id': 'balanceDefinitionId',
        'contact_id': 'contactId',
        'created_at': 'createdAt',
        'due_at': 'dueAt',
        'expires_at': 'expiresAt',
        'id': 'id',
        'loyalty_program_id': 'loyaltyProgramId',
        'meta': 'meta',
        'processed_at': 'processedAt',
        'transactionid': 'transactionid',
        'updated_at': 'updatedAt'
    }

    def __init__(self, amount=None, balance_definition_id=None, contact_id=None, created_at=None, due_at=None, expires_at=None, id=None, loyalty_program_id=None, meta=None, processed_at=None, transactionid=None, updated_at=None):  # noqa: E501
        """BalanceOrder - a model defined in Swagger"""  # noqa: E501

        self._amount = None
        self._balance_definition_id = None
        self._contact_id = None
        self._created_at = None
        self._due_at = None
        self._expires_at = None
        self._id = None
        self._loyalty_program_id = None
        self._meta = None
        self._processed_at = None
        self._transactionid = None
        self._updated_at = None
        self.discriminator = None

        self.amount = amount
        if balance_definition_id is not None:
            self.balance_definition_id = balance_definition_id
        self.contact_id = contact_id
        self.created_at = created_at
        self.due_at = due_at
        if expires_at is not None:
            self.expires_at = expires_at
        if id is not None:
            self.id = id
        self.loyalty_program_id = loyalty_program_id
        if meta is not None:
            self.meta = meta
        if processed_at is not None:
            self.processed_at = processed_at
        if transactionid is not None:
            self.transactionid = transactionid
        self.updated_at = updated_at

    @property
    def amount(self):
        """Gets the amount of this BalanceOrder.  # noqa: E501

        Order amount (must not be zero).  # noqa: E501

        :return: The amount of this BalanceOrder.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BalanceOrder.

        Order amount (must not be zero).  # noqa: E501

        :param amount: The amount of this BalanceOrder.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this BalanceOrder.  # noqa: E501

        Optional unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :return: The balance_definition_id of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this BalanceOrder.

        Optional unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this BalanceOrder.  # noqa: E501
        :type: str
        """

        self._balance_definition_id = balance_definition_id

    @property
    def contact_id(self):
        """Gets the contact_id of this BalanceOrder.  # noqa: E501

        Unique identifier of the contact placing the order (must be ≥ 1).  # noqa: E501

        :return: The contact_id of this BalanceOrder.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this BalanceOrder.

        Unique identifier of the contact placing the order (must be ≥ 1).  # noqa: E501

        :param contact_id: The contact_id of this BalanceOrder.  # noqa: E501
        :type: int
        """
        if contact_id is None:
            raise ValueError("Invalid value for `contact_id`, must not be `None`")  # noqa: E501
        if contact_id is not None and contact_id < 1:  # noqa: E501
            raise ValueError("Invalid value for `contact_id`, must be a value greater than or equal to `1`")  # noqa: E501

        self._contact_id = contact_id

    @property
    def created_at(self):
        """Gets the created_at of this BalanceOrder.  # noqa: E501

        RFC3339 timestamp indicating when the order was created.  # noqa: E501

        :return: The created_at of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BalanceOrder.

        RFC3339 timestamp indicating when the order was created.  # noqa: E501

        :param created_at: The created_at of this BalanceOrder.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def due_at(self):
        """Gets the due_at of this BalanceOrder.  # noqa: E501

        RFC3339 timestamp specifying when the order is due in the future.  # noqa: E501

        :return: The due_at of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """Sets the due_at of this BalanceOrder.

        RFC3339 timestamp specifying when the order is due in the future.  # noqa: E501

        :param due_at: The due_at of this BalanceOrder.  # noqa: E501
        :type: str
        """
        if due_at is None:
            raise ValueError("Invalid value for `due_at`, must not be `None`")  # noqa: E501

        self._due_at = due_at

    @property
    def expires_at(self):
        """Gets the expires_at of this BalanceOrder.  # noqa: E501

        Optional RFC3339 timestamp defining order expiration in the future.  # noqa: E501

        :return: The expires_at of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this BalanceOrder.

        Optional RFC3339 timestamp defining order expiration in the future.  # noqa: E501

        :param expires_at: The expires_at of this BalanceOrder.  # noqa: E501
        :type: str
        """

        self._expires_at = expires_at

    @property
    def id(self):
        """Gets the id of this BalanceOrder.  # noqa: E501

        Unique identifier for the balance order.  # noqa: E501

        :return: The id of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BalanceOrder.

        Unique identifier for the balance order.  # noqa: E501

        :param id: The id of this BalanceOrder.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this BalanceOrder.  # noqa: E501

        Unique identifier of the loyalty program associated with the order.  # noqa: E501

        :return: The loyalty_program_id of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this BalanceOrder.

        Unique identifier of the loyalty program associated with the order.  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this BalanceOrder.  # noqa: E501
        :type: str
        """
        if loyalty_program_id is None:
            raise ValueError("Invalid value for `loyalty_program_id`, must not be `None`")  # noqa: E501

        self._loyalty_program_id = loyalty_program_id

    @property
    def meta(self):
        """Gets the meta of this BalanceOrder.  # noqa: E501

        Optional metadata associated with the order.  # noqa: E501

        :return: The meta of this BalanceOrder.  # noqa: E501
        :rtype: object
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this BalanceOrder.

        Optional metadata associated with the order.  # noqa: E501

        :param meta: The meta of this BalanceOrder.  # noqa: E501
        :type: object
        """

        self._meta = meta

    @property
    def processed_at(self):
        """Gets the processed_at of this BalanceOrder.  # noqa: E501

        Optional RFC3339 timestamp indicating when the order was processed.  # noqa: E501

        :return: The processed_at of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._processed_at

    @processed_at.setter
    def processed_at(self, processed_at):
        """Sets the processed_at of this BalanceOrder.

        Optional RFC3339 timestamp indicating when the order was processed.  # noqa: E501

        :param processed_at: The processed_at of this BalanceOrder.  # noqa: E501
        :type: str
        """

        self._processed_at = processed_at

    @property
    def transactionid(self):
        """Gets the transactionid of this BalanceOrder.  # noqa: E501

        Optional reference to the associated transaction ID.  # noqa: E501

        :return: The transactionid of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._transactionid

    @transactionid.setter
    def transactionid(self, transactionid):
        """Sets the transactionid of this BalanceOrder.

        Optional reference to the associated transaction ID.  # noqa: E501

        :param transactionid: The transactionid of this BalanceOrder.  # noqa: E501
        :type: str
        """

        self._transactionid = transactionid

    @property
    def updated_at(self):
        """Gets the updated_at of this BalanceOrder.  # noqa: E501

        RFC3339 timestamp indicating the last update to the order.  # noqa: E501

        :return: The updated_at of this BalanceOrder.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this BalanceOrder.

        RFC3339 timestamp indicating the last update to the order.  # noqa: E501

        :param updated_at: The updated_at of this BalanceOrder.  # noqa: E501
        :type: str
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BalanceOrder, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BalanceOrder):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
