# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateBalanceLimitPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'constraint_type': 'str',
        'duration_unit': 'str',
        'duration_value': 'int',
        'sliding_schedule': 'bool',
        'transaction_type': 'str',
        'value': 'int'
    }

    attribute_map = {
        'constraint_type': 'constraintType',
        'duration_unit': 'durationUnit',
        'duration_value': 'durationValue',
        'sliding_schedule': 'slidingSchedule',
        'transaction_type': 'transactionType',
        'value': 'value'
    }

    def __init__(self, constraint_type=None, duration_unit=None, duration_value=None, sliding_schedule=None, transaction_type=None, value=None):  # noqa: E501
        """CreateBalanceLimitPayload - a model defined in Swagger"""  # noqa: E501

        self._constraint_type = None
        self._duration_unit = None
        self._duration_value = None
        self._sliding_schedule = None
        self._transaction_type = None
        self._value = None
        self.discriminator = None

        self.constraint_type = constraint_type
        self.duration_unit = duration_unit
        self.duration_value = duration_value
        if sliding_schedule is not None:
            self.sliding_schedule = sliding_schedule
        self.transaction_type = transaction_type
        self.value = value

    @property
    def constraint_type(self):
        """Gets the constraint_type of this CreateBalanceLimitPayload.  # noqa: E501

        Defines whether the limit applies to transaction count or amount.  # noqa: E501

        :return: The constraint_type of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: str
        """
        return self._constraint_type

    @constraint_type.setter
    def constraint_type(self, constraint_type):
        """Sets the constraint_type of this CreateBalanceLimitPayload.

        Defines whether the limit applies to transaction count or amount.  # noqa: E501

        :param constraint_type: The constraint_type of this CreateBalanceLimitPayload.  # noqa: E501
        :type: str
        """
        if constraint_type is None:
            raise ValueError("Invalid value for `constraint_type`, must not be `None`")  # noqa: E501
        allowed_values = ["transaction", "amount"]  # noqa: E501
        if constraint_type not in allowed_values:
            raise ValueError(
                "Invalid value for `constraint_type` ({0}), must be one of {1}"  # noqa: E501
                .format(constraint_type, allowed_values)
            )

        self._constraint_type = constraint_type

    @property
    def duration_unit(self):
        """Gets the duration_unit of this CreateBalanceLimitPayload.  # noqa: E501

        Unit of time for which the limit is applicable.  # noqa: E501

        :return: The duration_unit of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: str
        """
        return self._duration_unit

    @duration_unit.setter
    def duration_unit(self, duration_unit):
        """Sets the duration_unit of this CreateBalanceLimitPayload.

        Unit of time for which the limit is applicable.  # noqa: E501

        :param duration_unit: The duration_unit of this CreateBalanceLimitPayload.  # noqa: E501
        :type: str
        """
        if duration_unit is None:
            raise ValueError("Invalid value for `duration_unit`, must not be `None`")  # noqa: E501
        allowed_values = ["day", "week", "month", "year"]  # noqa: E501
        if duration_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `duration_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(duration_unit, allowed_values)
            )

        self._duration_unit = duration_unit

    @property
    def duration_value(self):
        """Gets the duration_value of this CreateBalanceLimitPayload.  # noqa: E501

        Number of time units for the balance limit.  # noqa: E501

        :return: The duration_value of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: int
        """
        return self._duration_value

    @duration_value.setter
    def duration_value(self, duration_value):
        """Sets the duration_value of this CreateBalanceLimitPayload.

        Number of time units for the balance limit.  # noqa: E501

        :param duration_value: The duration_value of this CreateBalanceLimitPayload.  # noqa: E501
        :type: int
        """
        if duration_value is None:
            raise ValueError("Invalid value for `duration_value`, must not be `None`")  # noqa: E501

        self._duration_value = duration_value

    @property
    def sliding_schedule(self):
        """Gets the sliding_schedule of this CreateBalanceLimitPayload.  # noqa: E501

        Determines if the limit resets on a rolling schedule.  # noqa: E501

        :return: The sliding_schedule of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: bool
        """
        return self._sliding_schedule

    @sliding_schedule.setter
    def sliding_schedule(self, sliding_schedule):
        """Sets the sliding_schedule of this CreateBalanceLimitPayload.

        Determines if the limit resets on a rolling schedule.  # noqa: E501

        :param sliding_schedule: The sliding_schedule of this CreateBalanceLimitPayload.  # noqa: E501
        :type: bool
        """

        self._sliding_schedule = sliding_schedule

    @property
    def transaction_type(self):
        """Gets the transaction_type of this CreateBalanceLimitPayload.  # noqa: E501

        Specifies whether the limit applies to credit or debit transactions.  # noqa: E501

        :return: The transaction_type of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this CreateBalanceLimitPayload.

        Specifies whether the limit applies to credit or debit transactions.  # noqa: E501

        :param transaction_type: The transaction_type of this CreateBalanceLimitPayload.  # noqa: E501
        :type: str
        """
        if transaction_type is None:
            raise ValueError("Invalid value for `transaction_type`, must not be `None`")  # noqa: E501
        allowed_values = ["credit", "debit"]  # noqa: E501
        if transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def value(self):
        """Gets the value of this CreateBalanceLimitPayload.  # noqa: E501

        Maximum allowed value for the specified constraint type.  # noqa: E501

        :return: The value of this CreateBalanceLimitPayload.  # noqa: E501
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this CreateBalanceLimitPayload.

        Maximum allowed value for the specified constraint type.  # noqa: E501

        :param value: The value of this CreateBalanceLimitPayload.  # noqa: E501
        :type: int
        """
        if value is None:
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateBalanceLimitPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateBalanceLimitPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
