# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateOrderPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'balance_definition_id': 'str',
        'contact_id': 'int',
        'due_at': 'str',
        'expires_at': 'str',
        'meta': 'object',
        'source': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'balance_definition_id': 'balanceDefinitionId',
        'contact_id': 'contactId',
        'due_at': 'dueAt',
        'expires_at': 'expiresAt',
        'meta': 'meta',
        'source': 'source'
    }

    def __init__(self, amount=None, balance_definition_id=None, contact_id=None, due_at=None, expires_at=None, meta=None, source=None):  # noqa: E501
        """CreateOrderPayload - a model defined in Swagger"""  # noqa: E501

        self._amount = None
        self._balance_definition_id = None
        self._contact_id = None
        self._due_at = None
        self._expires_at = None
        self._meta = None
        self._source = None
        self.discriminator = None

        self.amount = amount
        self.balance_definition_id = balance_definition_id
        self.contact_id = contact_id
        self.due_at = due_at
        if expires_at is not None:
            self.expires_at = expires_at
        if meta is not None:
            self.meta = meta
        self.source = source

    @property
    def amount(self):
        """Gets the amount of this CreateOrderPayload.  # noqa: E501

        Order amount (must be non-zero).  # noqa: E501

        :return: The amount of this CreateOrderPayload.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this CreateOrderPayload.

        Order amount (must be non-zero).  # noqa: E501

        :param amount: The amount of this CreateOrderPayload.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this CreateOrderPayload.  # noqa: E501

        Unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :return: The balance_definition_id of this CreateOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this CreateOrderPayload.

        Unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this CreateOrderPayload.  # noqa: E501
        :type: str
        """
        if balance_definition_id is None:
            raise ValueError("Invalid value for `balance_definition_id`, must not be `None`")  # noqa: E501

        self._balance_definition_id = balance_definition_id

    @property
    def contact_id(self):
        """Gets the contact_id of this CreateOrderPayload.  # noqa: E501

        Unique identifier of the contact placing the order (must be ≥ 1).  # noqa: E501

        :return: The contact_id of this CreateOrderPayload.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this CreateOrderPayload.

        Unique identifier of the contact placing the order (must be ≥ 1).  # noqa: E501

        :param contact_id: The contact_id of this CreateOrderPayload.  # noqa: E501
        :type: int
        """
        if contact_id is None:
            raise ValueError("Invalid value for `contact_id`, must not be `None`")  # noqa: E501
        if contact_id is not None and contact_id < 1:  # noqa: E501
            raise ValueError("Invalid value for `contact_id`, must be a value greater than or equal to `1`")  # noqa: E501

        self._contact_id = contact_id

    @property
    def due_at(self):
        """Gets the due_at of this CreateOrderPayload.  # noqa: E501

        RFC3339 timestamp specifying when the order is due.  # noqa: E501

        :return: The due_at of this CreateOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """Sets the due_at of this CreateOrderPayload.

        RFC3339 timestamp specifying when the order is due.  # noqa: E501

        :param due_at: The due_at of this CreateOrderPayload.  # noqa: E501
        :type: str
        """
        if due_at is None:
            raise ValueError("Invalid value for `due_at`, must not be `None`")  # noqa: E501

        self._due_at = due_at

    @property
    def expires_at(self):
        """Gets the expires_at of this CreateOrderPayload.  # noqa: E501

        Optional RFC3339 timestamp defining order expiration.  # noqa: E501

        :return: The expires_at of this CreateOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this CreateOrderPayload.

        Optional RFC3339 timestamp defining order expiration.  # noqa: E501

        :param expires_at: The expires_at of this CreateOrderPayload.  # noqa: E501
        :type: str
        """

        self._expires_at = expires_at

    @property
    def meta(self):
        """Gets the meta of this CreateOrderPayload.  # noqa: E501

        Optional metadata associated with the order.  # noqa: E501

        :return: The meta of this CreateOrderPayload.  # noqa: E501
        :rtype: object
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this CreateOrderPayload.

        Optional metadata associated with the order.  # noqa: E501

        :param meta: The meta of this CreateOrderPayload.  # noqa: E501
        :type: object
        """

        self._meta = meta

    @property
    def source(self):
        """Gets the source of this CreateOrderPayload.  # noqa: E501

        Specifies the origin of the order (`engine` or `user`).  # noqa: E501

        :return: The source of this CreateOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this CreateOrderPayload.

        Specifies the origin of the order (`engine` or `user`).  # noqa: E501

        :param source: The source of this CreateOrderPayload.  # noqa: E501
        :type: str
        """
        if source is None:
            raise ValueError("Invalid value for `source`, must not be `None`")  # noqa: E501

        self._source = source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateOrderPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOrderPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
