# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateSmsCampaign(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'sender': 'str',
        'content': 'str',
        'recipients': 'CreateSmsCampaignRecipients',
        'scheduled_at': 'str',
        'unicode_enabled': 'bool',
        'organisation_prefix': 'str',
        'unsubscribe_instruction': 'str'
    }

    attribute_map = {
        'name': 'name',
        'sender': 'sender',
        'content': 'content',
        'recipients': 'recipients',
        'scheduled_at': 'scheduledAt',
        'unicode_enabled': 'unicodeEnabled',
        'organisation_prefix': 'organisationPrefix',
        'unsubscribe_instruction': 'unsubscribeInstruction'
    }

    def __init__(self, name=None, sender=None, content=None, recipients=None, scheduled_at=None, unicode_enabled=False, organisation_prefix=None, unsubscribe_instruction=None):  # noqa: E501
        """CreateSmsCampaign - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._sender = None
        self._content = None
        self._recipients = None
        self._scheduled_at = None
        self._unicode_enabled = None
        self._organisation_prefix = None
        self._unsubscribe_instruction = None
        self.discriminator = None

        self.name = name
        self.sender = sender
        self.content = content
        if recipients is not None:
            self.recipients = recipients
        if scheduled_at is not None:
            self.scheduled_at = scheduled_at
        if unicode_enabled is not None:
            self.unicode_enabled = unicode_enabled
        if organisation_prefix is not None:
            self.organisation_prefix = organisation_prefix
        if unsubscribe_instruction is not None:
            self.unsubscribe_instruction = unsubscribe_instruction

    @property
    def name(self):
        """Gets the name of this CreateSmsCampaign.  # noqa: E501

        Name of the campaign  # noqa: E501

        :return: The name of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateSmsCampaign.

        Name of the campaign  # noqa: E501

        :param name: The name of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def sender(self):
        """Gets the sender of this CreateSmsCampaign.  # noqa: E501

        Name of the sender. **The number of characters is limited to 11 for alphanumeric characters and 15 for numeric characters**  # noqa: E501

        :return: The sender of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this CreateSmsCampaign.

        Name of the sender. **The number of characters is limited to 11 for alphanumeric characters and 15 for numeric characters**  # noqa: E501

        :param sender: The sender of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """
        if sender is None:
            raise ValueError("Invalid value for `sender`, must not be `None`")  # noqa: E501
        if sender is not None and len(sender) > 15:
            raise ValueError("Invalid value for `sender`, length must be less than or equal to `15`")  # noqa: E501

        self._sender = sender

    @property
    def content(self):
        """Gets the content of this CreateSmsCampaign.  # noqa: E501

        Content of the message. The maximum characters used per SMS is 160, if used more than that, it will be counted as more than one SMS  # noqa: E501

        :return: The content of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this CreateSmsCampaign.

        Content of the message. The maximum characters used per SMS is 160, if used more than that, it will be counted as more than one SMS  # noqa: E501

        :param content: The content of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """
        if content is None:
            raise ValueError("Invalid value for `content`, must not be `None`")  # noqa: E501

        self._content = content

    @property
    def recipients(self):
        """Gets the recipients of this CreateSmsCampaign.  # noqa: E501


        :return: The recipients of this CreateSmsCampaign.  # noqa: E501
        :rtype: CreateSmsCampaignRecipients
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """Sets the recipients of this CreateSmsCampaign.


        :param recipients: The recipients of this CreateSmsCampaign.  # noqa: E501
        :type: CreateSmsCampaignRecipients
        """

        self._recipients = recipients

    @property
    def scheduled_at(self):
        """Gets the scheduled_at of this CreateSmsCampaign.  # noqa: E501

        UTC date-time on which the campaign has to run (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.  # noqa: E501

        :return: The scheduled_at of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._scheduled_at

    @scheduled_at.setter
    def scheduled_at(self, scheduled_at):
        """Sets the scheduled_at of this CreateSmsCampaign.

        UTC date-time on which the campaign has to run (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.  # noqa: E501

        :param scheduled_at: The scheduled_at of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """

        self._scheduled_at = scheduled_at

    @property
    def unicode_enabled(self):
        """Gets the unicode_enabled of this CreateSmsCampaign.  # noqa: E501

        Format of the message. It indicates whether the content should be treated as unicode or not.  # noqa: E501

        :return: The unicode_enabled of this CreateSmsCampaign.  # noqa: E501
        :rtype: bool
        """
        return self._unicode_enabled

    @unicode_enabled.setter
    def unicode_enabled(self, unicode_enabled):
        """Sets the unicode_enabled of this CreateSmsCampaign.

        Format of the message. It indicates whether the content should be treated as unicode or not.  # noqa: E501

        :param unicode_enabled: The unicode_enabled of this CreateSmsCampaign.  # noqa: E501
        :type: bool
        """

        self._unicode_enabled = unicode_enabled

    @property
    def organisation_prefix(self):
        """Gets the organisation_prefix of this CreateSmsCampaign.  # noqa: E501

        A recognizable prefix will ensure your audience knows who you are. Recommended by U.S. carriers. This will be added as your Brand Name before the message content. **Prefer verifying maximum length of 160 characters including this prefix in message content to avoid multiple sending of same sms.**  # noqa: E501

        :return: The organisation_prefix of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._organisation_prefix

    @organisation_prefix.setter
    def organisation_prefix(self, organisation_prefix):
        """Sets the organisation_prefix of this CreateSmsCampaign.

        A recognizable prefix will ensure your audience knows who you are. Recommended by U.S. carriers. This will be added as your Brand Name before the message content. **Prefer verifying maximum length of 160 characters including this prefix in message content to avoid multiple sending of same sms.**  # noqa: E501

        :param organisation_prefix: The organisation_prefix of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """

        self._organisation_prefix = organisation_prefix

    @property
    def unsubscribe_instruction(self):
        """Gets the unsubscribe_instruction of this CreateSmsCampaign.  # noqa: E501

        Instructions to unsubscribe from future communications. Recommended by U.S. carriers. Must include **STOP** keyword. This will be added as instructions after the end of message content. **Prefer verifying maximum length of 160 characters including this instructions in message content to avoid multiple sending of same sms.**  # noqa: E501

        :return: The unsubscribe_instruction of this CreateSmsCampaign.  # noqa: E501
        :rtype: str
        """
        return self._unsubscribe_instruction

    @unsubscribe_instruction.setter
    def unsubscribe_instruction(self, unsubscribe_instruction):
        """Sets the unsubscribe_instruction of this CreateSmsCampaign.

        Instructions to unsubscribe from future communications. Recommended by U.S. carriers. Must include **STOP** keyword. This will be added as instructions after the end of message content. **Prefer verifying maximum length of 160 characters including this instructions in message content to avoid multiple sending of same sms.**  # noqa: E501

        :param unsubscribe_instruction: The unsubscribe_instruction of this CreateSmsCampaign.  # noqa: E501
        :type: str
        """

        self._unsubscribe_instruction = unsubscribe_instruction

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateSmsCampaign, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateSmsCampaign):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
