# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateSubscriptionPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'contact_id': 'int',
        'creation_date': 'str',
        'loyalty_subscription_id': 'str'
    }

    attribute_map = {
        'contact_id': 'contactId',
        'creation_date': 'creationDate',
        'loyalty_subscription_id': 'loyaltySubscriptionId'
    }

    def __init__(self, contact_id=None, creation_date=None, loyalty_subscription_id=None):  # noqa: E501
        """CreateSubscriptionPayload - a model defined in Swagger"""  # noqa: E501

        self._contact_id = None
        self._creation_date = None
        self._loyalty_subscription_id = None
        self.discriminator = None

        self.contact_id = contact_id
        if creation_date is not None:
            self.creation_date = creation_date
        if loyalty_subscription_id is not None:
            self.loyalty_subscription_id = loyalty_subscription_id

    @property
    def contact_id(self):
        """Gets the contact_id of this CreateSubscriptionPayload.  # noqa: E501

        Required contact ID; must be greater than 0.  # noqa: E501

        :return: The contact_id of this CreateSubscriptionPayload.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this CreateSubscriptionPayload.

        Required contact ID; must be greater than 0.  # noqa: E501

        :param contact_id: The contact_id of this CreateSubscriptionPayload.  # noqa: E501
        :type: int
        """
        if contact_id is None:
            raise ValueError("Invalid value for `contact_id`, must not be `None`")  # noqa: E501

        self._contact_id = contact_id

    @property
    def creation_date(self):
        """Gets the creation_date of this CreateSubscriptionPayload.  # noqa: E501

        Optional custom date-time format.  # noqa: E501

        :return: The creation_date of this CreateSubscriptionPayload.  # noqa: E501
        :rtype: str
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this CreateSubscriptionPayload.

        Optional custom date-time format.  # noqa: E501

        :param creation_date: The creation_date of this CreateSubscriptionPayload.  # noqa: E501
        :type: str
        """

        self._creation_date = creation_date

    @property
    def loyalty_subscription_id(self):
        """Gets the loyalty_subscription_id of this CreateSubscriptionPayload.  # noqa: E501

        Optional subscription ID (max length 64).  # noqa: E501

        :return: The loyalty_subscription_id of this CreateSubscriptionPayload.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_subscription_id

    @loyalty_subscription_id.setter
    def loyalty_subscription_id(self, loyalty_subscription_id):
        """Sets the loyalty_subscription_id of this CreateSubscriptionPayload.

        Optional subscription ID (max length 64).  # noqa: E501

        :param loyalty_subscription_id: The loyalty_subscription_id of this CreateSubscriptionPayload.  # noqa: E501
        :type: str
        """
        if loyalty_subscription_id is not None and len(loyalty_subscription_id) > 64:
            raise ValueError("Invalid value for `loyalty_subscription_id`, length must be less than or equal to `64`")  # noqa: E501

        self._loyalty_subscription_id = loyalty_subscription_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateSubscriptionPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateSubscriptionPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
