# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateTransactionPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'loyalty_subscription_id': 'str',
        'amount': 'float',
        'auto_complete': 'bool',
        'balance_definition_id': 'str',
        'balance_expiry_in_minutes': 'int',
        'contact_id': 'int',
        'event_time': 'str',
        'meta': 'object',
        'ttl': 'int'
    }

    attribute_map = {
        'loyalty_subscription_id': 'LoyaltySubscriptionId',
        'amount': 'amount',
        'auto_complete': 'autoComplete',
        'balance_definition_id': 'balanceDefinitionId',
        'balance_expiry_in_minutes': 'balanceExpiryInMinutes',
        'contact_id': 'contactId',
        'event_time': 'eventTime',
        'meta': 'meta',
        'ttl': 'ttl'
    }

    def __init__(self, loyalty_subscription_id=None, amount=None, auto_complete=None, balance_definition_id=None, balance_expiry_in_minutes=None, contact_id=None, event_time=None, meta=None, ttl=None):  # noqa: E501
        """CreateTransactionPayload - a model defined in Swagger"""  # noqa: E501

        self._loyalty_subscription_id = None
        self._amount = None
        self._auto_complete = None
        self._balance_definition_id = None
        self._balance_expiry_in_minutes = None
        self._contact_id = None
        self._event_time = None
        self._meta = None
        self._ttl = None
        self.discriminator = None

        if loyalty_subscription_id is not None:
            self.loyalty_subscription_id = loyalty_subscription_id
        self.amount = amount
        if auto_complete is not None:
            self.auto_complete = auto_complete
        self.balance_definition_id = balance_definition_id
        if balance_expiry_in_minutes is not None:
            self.balance_expiry_in_minutes = balance_expiry_in_minutes
        if contact_id is not None:
            self.contact_id = contact_id
        if event_time is not None:
            self.event_time = event_time
        if meta is not None:
            self.meta = meta
        if ttl is not None:
            self.ttl = ttl

    @property
    def loyalty_subscription_id(self):
        """Gets the loyalty_subscription_id of this CreateTransactionPayload.  # noqa: E501

        Unique identifier for the loyalty subscription (required unless `contactId` is provided).  # noqa: E501

        :return: The loyalty_subscription_id of this CreateTransactionPayload.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_subscription_id

    @loyalty_subscription_id.setter
    def loyalty_subscription_id(self, loyalty_subscription_id):
        """Sets the loyalty_subscription_id of this CreateTransactionPayload.

        Unique identifier for the loyalty subscription (required unless `contactId` is provided).  # noqa: E501

        :param loyalty_subscription_id: The loyalty_subscription_id of this CreateTransactionPayload.  # noqa: E501
        :type: str
        """

        self._loyalty_subscription_id = loyalty_subscription_id

    @property
    def amount(self):
        """Gets the amount of this CreateTransactionPayload.  # noqa: E501

        Transaction amount (must be provided).  # noqa: E501

        :return: The amount of this CreateTransactionPayload.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this CreateTransactionPayload.

        Transaction amount (must be provided).  # noqa: E501

        :param amount: The amount of this CreateTransactionPayload.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def auto_complete(self):
        """Gets the auto_complete of this CreateTransactionPayload.  # noqa: E501

        Whether the transaction should be automatically completed.  # noqa: E501

        :return: The auto_complete of this CreateTransactionPayload.  # noqa: E501
        :rtype: bool
        """
        return self._auto_complete

    @auto_complete.setter
    def auto_complete(self, auto_complete):
        """Sets the auto_complete of this CreateTransactionPayload.

        Whether the transaction should be automatically completed.  # noqa: E501

        :param auto_complete: The auto_complete of this CreateTransactionPayload.  # noqa: E501
        :type: bool
        """

        self._auto_complete = auto_complete

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this CreateTransactionPayload.  # noqa: E501

        Unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :return: The balance_definition_id of this CreateTransactionPayload.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this CreateTransactionPayload.

        Unique identifier (UUID) of the associated balance definition.  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this CreateTransactionPayload.  # noqa: E501
        :type: str
        """
        if balance_definition_id is None:
            raise ValueError("Invalid value for `balance_definition_id`, must not be `None`")  # noqa: E501

        self._balance_definition_id = balance_definition_id

    @property
    def balance_expiry_in_minutes(self):
        """Gets the balance_expiry_in_minutes of this CreateTransactionPayload.  # noqa: E501

        Optional expiry time for the balance in minutes (must be greater than 0 if provided).  # noqa: E501

        :return: The balance_expiry_in_minutes of this CreateTransactionPayload.  # noqa: E501
        :rtype: int
        """
        return self._balance_expiry_in_minutes

    @balance_expiry_in_minutes.setter
    def balance_expiry_in_minutes(self, balance_expiry_in_minutes):
        """Sets the balance_expiry_in_minutes of this CreateTransactionPayload.

        Optional expiry time for the balance in minutes (must be greater than 0 if provided).  # noqa: E501

        :param balance_expiry_in_minutes: The balance_expiry_in_minutes of this CreateTransactionPayload.  # noqa: E501
        :type: int
        """

        self._balance_expiry_in_minutes = balance_expiry_in_minutes

    @property
    def contact_id(self):
        """Gets the contact_id of this CreateTransactionPayload.  # noqa: E501

        Unique identifier of the contact involved in the transaction (required unless `LoyaltySubscriptionId` is provided).  # noqa: E501

        :return: The contact_id of this CreateTransactionPayload.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this CreateTransactionPayload.

        Unique identifier of the contact involved in the transaction (required unless `LoyaltySubscriptionId` is provided).  # noqa: E501

        :param contact_id: The contact_id of this CreateTransactionPayload.  # noqa: E501
        :type: int
        """
        if contact_id is not None and contact_id < 1:  # noqa: E501
            raise ValueError("Invalid value for `contact_id`, must be a value greater than or equal to `1`")  # noqa: E501

        self._contact_id = contact_id

    @property
    def event_time(self):
        """Gets the event_time of this CreateTransactionPayload.  # noqa: E501

        Optional timestamp specifying when the transaction occurred.  # noqa: E501

        :return: The event_time of this CreateTransactionPayload.  # noqa: E501
        :rtype: str
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time):
        """Sets the event_time of this CreateTransactionPayload.

        Optional timestamp specifying when the transaction occurred.  # noqa: E501

        :param event_time: The event_time of this CreateTransactionPayload.  # noqa: E501
        :type: str
        """

        self._event_time = event_time

    @property
    def meta(self):
        """Gets the meta of this CreateTransactionPayload.  # noqa: E501

        Optional metadata associated with the transaction.  # noqa: E501

        :return: The meta of this CreateTransactionPayload.  # noqa: E501
        :rtype: object
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this CreateTransactionPayload.

        Optional metadata associated with the transaction.  # noqa: E501

        :param meta: The meta of this CreateTransactionPayload.  # noqa: E501
        :type: object
        """

        self._meta = meta

    @property
    def ttl(self):
        """Gets the ttl of this CreateTransactionPayload.  # noqa: E501

        Optional time-to-live for the transaction (must be greater than 0 if provided).  # noqa: E501

        :return: The ttl of this CreateTransactionPayload.  # noqa: E501
        :rtype: int
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """Sets the ttl of this CreateTransactionPayload.

        Optional time-to-live for the transaction (must be greater than 0 if provided).  # noqa: E501

        :param ttl: The ttl of this CreateTransactionPayload.  # noqa: E501
        :type: int
        """

        self._ttl = ttl

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateTransactionPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateTransactionPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
