# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateWhatsAppTemplate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'language': 'str',
        'category': 'str',
        'media_url': 'str',
        'body_text': 'str',
        'header_text': 'str',
        'source': 'str'
    }

    attribute_map = {
        'name': 'name',
        'language': 'language',
        'category': 'category',
        'media_url': 'mediaUrl',
        'body_text': 'bodyText',
        'header_text': 'headerText',
        'source': 'source'
    }

    def __init__(self, name=None, language=None, category=None, media_url=None, body_text=None, header_text=None, source=None):  # noqa: E501
        """CreateWhatsAppTemplate - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._language = None
        self._category = None
        self._media_url = None
        self._body_text = None
        self._header_text = None
        self._source = None
        self.discriminator = None

        self.name = name
        self.language = language
        self.category = category
        if media_url is not None:
            self.media_url = media_url
        self.body_text = body_text
        if header_text is not None:
            self.header_text = header_text
        if source is not None:
            self.source = source

    @property
    def name(self):
        """Gets the name of this CreateWhatsAppTemplate.  # noqa: E501

        Name of the template  # noqa: E501

        :return: The name of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateWhatsAppTemplate.

        Name of the template  # noqa: E501

        :param name: The name of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def language(self):
        """Gets the language of this CreateWhatsAppTemplate.  # noqa: E501

        Language of the template. For Example : **en** for English   # noqa: E501

        :return: The language of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this CreateWhatsAppTemplate.

        Language of the template. For Example : **en** for English   # noqa: E501

        :param language: The language of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """
        if language is None:
            raise ValueError("Invalid value for `language`, must not be `None`")  # noqa: E501

        self._language = language

    @property
    def category(self):
        """Gets the category of this CreateWhatsAppTemplate.  # noqa: E501

        Category of the template  # noqa: E501

        :return: The category of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this CreateWhatsAppTemplate.

        Category of the template  # noqa: E501

        :param category: The category of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """
        if category is None:
            raise ValueError("Invalid value for `category`, must not be `None`")  # noqa: E501
        allowed_values = ["MARKETING", "UTILITY"]  # noqa: E501
        if category not in allowed_values:
            raise ValueError(
                "Invalid value for `category` ({0}), must be one of {1}"  # noqa: E501
                .format(category, allowed_values)
            )

        self._category = category

    @property
    def media_url(self):
        """Gets the media_url of this CreateWhatsAppTemplate.  # noqa: E501

        Absolute url of the media file **(no local file)** for the header. **Use this field in you want to add media in Template header and headerText is empty.** Allowed extensions for media files are: #### jpeg | png | mp4 | pdf   # noqa: E501

        :return: The media_url of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._media_url

    @media_url.setter
    def media_url(self, media_url):
        """Sets the media_url of this CreateWhatsAppTemplate.

        Absolute url of the media file **(no local file)** for the header. **Use this field in you want to add media in Template header and headerText is empty.** Allowed extensions for media files are: #### jpeg | png | mp4 | pdf   # noqa: E501

        :param media_url: The media_url of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """

        self._media_url = media_url

    @property
    def body_text(self):
        """Gets the body_text of this CreateWhatsAppTemplate.  # noqa: E501

        Body of the template. **Maximum allowed characters are 1024**  # noqa: E501

        :return: The body_text of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._body_text

    @body_text.setter
    def body_text(self, body_text):
        """Sets the body_text of this CreateWhatsAppTemplate.

        Body of the template. **Maximum allowed characters are 1024**  # noqa: E501

        :param body_text: The body_text of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """
        if body_text is None:
            raise ValueError("Invalid value for `body_text`, must not be `None`")  # noqa: E501

        self._body_text = body_text

    @property
    def header_text(self):
        """Gets the header_text of this CreateWhatsAppTemplate.  # noqa: E501

        Text content of the header in the template.  **Maximum allowed characters are 45** **Use this field to add text content in template header and if mediaUrl is empty**   # noqa: E501

        :return: The header_text of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._header_text

    @header_text.setter
    def header_text(self, header_text):
        """Sets the header_text of this CreateWhatsAppTemplate.

        Text content of the header in the template.  **Maximum allowed characters are 45** **Use this field to add text content in template header and if mediaUrl is empty**   # noqa: E501

        :param header_text: The header_text of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """

        self._header_text = header_text

    @property
    def source(self):
        """Gets the source of this CreateWhatsAppTemplate.  # noqa: E501

        source of the template  # noqa: E501

        :return: The source of this CreateWhatsAppTemplate.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this CreateWhatsAppTemplate.

        source of the template  # noqa: E501

        :param source: The source of this CreateWhatsAppTemplate.  # noqa: E501
        :type: str
        """
        allowed_values = ["Automation", "Conversations"]  # noqa: E501
        if source not in allowed_values:
            raise ValueError(
                "Invalid value for `source` ({0}), must be one of {1}"  # noqa: E501
                .format(source, allowed_values)
            )

        self._source = source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateWhatsAppTemplate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateWhatsAppTemplate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
