# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Event(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'event_name': 'str',
        'event_date': 'str',
        'identifiers': 'EventIdentifiers',
        'contact_properties': 'object',
        'event_properties': 'object'
    }

    attribute_map = {
        'event_name': 'event_name',
        'event_date': 'event_date',
        'identifiers': 'identifiers',
        'contact_properties': 'contact_properties',
        'event_properties': 'event_properties'
    }

    def __init__(self, event_name=None, event_date=None, identifiers=None, contact_properties=None, event_properties=None):  # noqa: E501
        """Event - a model defined in Swagger"""  # noqa: E501

        self._event_name = None
        self._event_date = None
        self._identifiers = None
        self._contact_properties = None
        self._event_properties = None
        self.discriminator = None

        self.event_name = event_name
        if event_date is not None:
            self.event_date = event_date
        self.identifiers = identifiers
        if contact_properties is not None:
            self.contact_properties = contact_properties
        if event_properties is not None:
            self.event_properties = event_properties

    @property
    def event_name(self):
        """Gets the event_name of this Event.  # noqa: E501

        The name of the event that occurred. This is how you will find your event in Brevo. Limited to 255 characters, alphanumerical characters and - _ only.  # noqa: E501

        :return: The event_name of this Event.  # noqa: E501
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """Sets the event_name of this Event.

        The name of the event that occurred. This is how you will find your event in Brevo. Limited to 255 characters, alphanumerical characters and - _ only.  # noqa: E501

        :param event_name: The event_name of this Event.  # noqa: E501
        :type: str
        """
        if event_name is None:
            raise ValueError("Invalid value for `event_name`, must not be `None`")  # noqa: E501

        self._event_name = event_name

    @property
    def event_date(self):
        """Gets the event_date of this Event.  # noqa: E501

        Timestamp of when the event occurred (e.g. \"2024-01-24T17:39:57+01:00\"). If no value is passed, the timestamp of the event creation is used.  # noqa: E501

        :return: The event_date of this Event.  # noqa: E501
        :rtype: str
        """
        return self._event_date

    @event_date.setter
    def event_date(self, event_date):
        """Sets the event_date of this Event.

        Timestamp of when the event occurred (e.g. \"2024-01-24T17:39:57+01:00\"). If no value is passed, the timestamp of the event creation is used.  # noqa: E501

        :param event_date: The event_date of this Event.  # noqa: E501
        :type: str
        """

        self._event_date = event_date

    @property
    def identifiers(self):
        """Gets the identifiers of this Event.  # noqa: E501


        :return: The identifiers of this Event.  # noqa: E501
        :rtype: EventIdentifiers
        """
        return self._identifiers

    @identifiers.setter
    def identifiers(self, identifiers):
        """Sets the identifiers of this Event.


        :param identifiers: The identifiers of this Event.  # noqa: E501
        :type: EventIdentifiers
        """
        if identifiers is None:
            raise ValueError("Invalid value for `identifiers`, must not be `None`")  # noqa: E501

        self._identifiers = identifiers

    @property
    def contact_properties(self):
        """Gets the contact_properties of this Event.  # noqa: E501

        Properties defining the state of the contact associated to this event. Useful to update contact attributes defined in your contacts database while passing the event. For example: **\"FIRSTNAME\": \"Jane\" , \"AGE\": 37**  # noqa: E501

        :return: The contact_properties of this Event.  # noqa: E501
        :rtype: object
        """
        return self._contact_properties

    @contact_properties.setter
    def contact_properties(self, contact_properties):
        """Sets the contact_properties of this Event.

        Properties defining the state of the contact associated to this event. Useful to update contact attributes defined in your contacts database while passing the event. For example: **\"FIRSTNAME\": \"Jane\" , \"AGE\": 37**  # noqa: E501

        :param contact_properties: The contact_properties of this Event.  # noqa: E501
        :type: object
        """

        self._contact_properties = contact_properties

    @property
    def event_properties(self):
        """Gets the event_properties of this Event.  # noqa: E501

        Properties of the event. Top level properties and nested properties can be used to better segment contacts and personalise workflow conditions. The following field type are supported: string, number, boolean (true/false), date (Timestamp e.g. \"2024-01-24T17:39:57+01:00\"). Keys are limited to 255 characters, alphanumerical characters and - _ only. Size is limited to 50Kb.  # noqa: E501

        :return: The event_properties of this Event.  # noqa: E501
        :rtype: object
        """
        return self._event_properties

    @event_properties.setter
    def event_properties(self, event_properties):
        """Sets the event_properties of this Event.

        Properties of the event. Top level properties and nested properties can be used to better segment contacts and personalise workflow conditions. The following field type are supported: string, number, boolean (true/false), date (Timestamp e.g. \"2024-01-24T17:39:57+01:00\"). Keys are limited to 255 characters, alphanumerical characters and - _ only. Size is limited to 50Kb.  # noqa: E501

        :param event_properties: The event_properties of this Event.  # noqa: E501
        :type: object
        """

        self._event_properties = event_properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Event, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Event):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
