# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ExportWebhooksHistory(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'days': 'int',
        'start_date': 'str',
        'end_date': 'str',
        'sort': 'str',
        'type': 'str',
        'event': 'str',
        'notify_url': 'str',
        'webhook_id': 'int',
        'email': 'str',
        'message_id': 'int'
    }

    attribute_map = {
        'days': 'days',
        'start_date': 'startDate',
        'end_date': 'endDate',
        'sort': 'sort',
        'type': 'type',
        'event': 'event',
        'notify_url': 'notifyURL',
        'webhook_id': 'webhookId',
        'email': 'email',
        'message_id': 'messageId'
    }

    def __init__(self, days=None, start_date=None, end_date=None, sort=None, type=None, event=None, notify_url=None, webhook_id=None, email=None, message_id=None):  # noqa: E501
        """ExportWebhooksHistory - a model defined in Swagger"""  # noqa: E501

        self._days = None
        self._start_date = None
        self._end_date = None
        self._sort = None
        self._type = None
        self._event = None
        self._notify_url = None
        self._webhook_id = None
        self._email = None
        self._message_id = None
        self.discriminator = None

        if days is not None:
            self.days = days
        if start_date is not None:
            self.start_date = start_date
        if end_date is not None:
            self.end_date = end_date
        if sort is not None:
            self.sort = sort
        self.type = type
        self.event = event
        self.notify_url = notify_url
        if webhook_id is not None:
            self.webhook_id = webhook_id
        if email is not None:
            self.email = email
        if message_id is not None:
            self.message_id = message_id

    @property
    def days(self):
        """Gets the days of this ExportWebhooksHistory.  # noqa: E501

        Number of days in the past including today (positive integer). _Not compatible with 'startDate' and 'endDate'_  # noqa: E501

        :return: The days of this ExportWebhooksHistory.  # noqa: E501
        :rtype: int
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this ExportWebhooksHistory.

        Number of days in the past including today (positive integer). _Not compatible with 'startDate' and 'endDate'_  # noqa: E501

        :param days: The days of this ExportWebhooksHistory.  # noqa: E501
        :type: int
        """

        self._days = days

    @property
    def start_date(self):
        """Gets the start_date of this ExportWebhooksHistory.  # noqa: E501

        Mandatory if endDate is used. Starting date of the history (YYYY-MM-DD). Must be lower than equal to endDate  # noqa: E501

        :return: The start_date of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this ExportWebhooksHistory.

        Mandatory if endDate is used. Starting date of the history (YYYY-MM-DD). Must be lower than equal to endDate  # noqa: E501

        :param start_date: The start_date of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this ExportWebhooksHistory.  # noqa: E501

        Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  # noqa: E501

        :return: The end_date of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this ExportWebhooksHistory.

        Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  # noqa: E501

        :param end_date: The end_date of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """

        self._end_date = end_date

    @property
    def sort(self):
        """Gets the sort of this ExportWebhooksHistory.  # noqa: E501

        Sorting order of records (asc or desc)  # noqa: E501

        :return: The sort of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this ExportWebhooksHistory.

        Sorting order of records (asc or desc)  # noqa: E501

        :param sort: The sort of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """

        self._sort = sort

    @property
    def type(self):
        """Gets the type of this ExportWebhooksHistory.  # noqa: E501

        Filter the history based on webhook type  # noqa: E501

        :return: The type of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ExportWebhooksHistory.

        Filter the history based on webhook type  # noqa: E501

        :param type: The type of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["transactional", "marketing"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def event(self):
        """Gets the event of this ExportWebhooksHistory.  # noqa: E501

        Filter the history for a specific event type  # noqa: E501

        :return: The event of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this ExportWebhooksHistory.

        Filter the history for a specific event type  # noqa: E501

        :param event: The event of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """
        if event is None:
            raise ValueError("Invalid value for `event`, must not be `None`")  # noqa: E501
        allowed_values = ["invalid_parameter", "missing_parameter", "hardBounce", "softBounce", "delivered", "spam", "request", "opened", "click", "invalid", "deferred", "blocked", "unsubscribed", "error", "uniqueOpened", "loadedByProxy", "allEvents"]  # noqa: E501
        if event not in allowed_values:
            raise ValueError(
                "Invalid value for `event` ({0}), must be one of {1}"  # noqa: E501
                .format(event, allowed_values)
            )

        self._event = event

    @property
    def notify_url(self):
        """Gets the notify_url of this ExportWebhooksHistory.  # noqa: E501

        Webhook URL to receive CSV file link  # noqa: E501

        :return: The notify_url of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._notify_url

    @notify_url.setter
    def notify_url(self, notify_url):
        """Sets the notify_url of this ExportWebhooksHistory.

        Webhook URL to receive CSV file link  # noqa: E501

        :param notify_url: The notify_url of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """
        if notify_url is None:
            raise ValueError("Invalid value for `notify_url`, must not be `None`")  # noqa: E501

        self._notify_url = notify_url

    @property
    def webhook_id(self):
        """Gets the webhook_id of this ExportWebhooksHistory.  # noqa: E501

        Filter the history for a specific webhook id  # noqa: E501

        :return: The webhook_id of this ExportWebhooksHistory.  # noqa: E501
        :rtype: int
        """
        return self._webhook_id

    @webhook_id.setter
    def webhook_id(self, webhook_id):
        """Sets the webhook_id of this ExportWebhooksHistory.

        Filter the history for a specific webhook id  # noqa: E501

        :param webhook_id: The webhook_id of this ExportWebhooksHistory.  # noqa: E501
        :type: int
        """

        self._webhook_id = webhook_id

    @property
    def email(self):
        """Gets the email of this ExportWebhooksHistory.  # noqa: E501

        Filter the history for a specific email  # noqa: E501

        :return: The email of this ExportWebhooksHistory.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ExportWebhooksHistory.

        Filter the history for a specific email  # noqa: E501

        :param email: The email of this ExportWebhooksHistory.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def message_id(self):
        """Gets the message_id of this ExportWebhooksHistory.  # noqa: E501

        Filter the history for a specific message id. Applicable only for transactional webhooks.  # noqa: E501

        :return: The message_id of this ExportWebhooksHistory.  # noqa: E501
        :rtype: int
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this ExportWebhooksHistory.

        Filter the history for a specific message id. Applicable only for transactional webhooks.  # noqa: E501

        :param message_id: The message_id of this ExportWebhooksHistory.  # noqa: E501
        :type: int
        """

        self._message_id = message_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExportWebhooksHistory, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExportWebhooksHistory):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
