# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetInboundEmailEventsByUuid(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'received_at': 'datetime',
        'delivered_at': 'datetime',
        'recipient': 'str',
        'sender': 'str',
        'message_id': 'str',
        'subject': 'str',
        'attachments': 'list[GetInboundEmailEventsByUuidAttachments]',
        'logs': 'list[GetInboundEmailEventsByUuidLogs]'
    }

    attribute_map = {
        'received_at': 'receivedAt',
        'delivered_at': 'deliveredAt',
        'recipient': 'recipient',
        'sender': 'sender',
        'message_id': 'messageId',
        'subject': 'subject',
        'attachments': 'attachments',
        'logs': 'logs'
    }

    def __init__(self, received_at=None, delivered_at=None, recipient=None, sender=None, message_id=None, subject=None, attachments=None, logs=None):  # noqa: E501
        """GetInboundEmailEventsByUuid - a model defined in Swagger"""  # noqa: E501

        self._received_at = None
        self._delivered_at = None
        self._recipient = None
        self._sender = None
        self._message_id = None
        self._subject = None
        self._attachments = None
        self._logs = None
        self.discriminator = None

        if received_at is not None:
            self.received_at = received_at
        if delivered_at is not None:
            self.delivered_at = delivered_at
        if recipient is not None:
            self.recipient = recipient
        if sender is not None:
            self.sender = sender
        if message_id is not None:
            self.message_id = message_id
        if subject is not None:
            self.subject = subject
        if attachments is not None:
            self.attachments = attachments
        if logs is not None:
            self.logs = logs

    @property
    def received_at(self):
        """Gets the received_at of this GetInboundEmailEventsByUuid.  # noqa: E501

        Date when email was received on SMTP relay  # noqa: E501

        :return: The received_at of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: datetime
        """
        return self._received_at

    @received_at.setter
    def received_at(self, received_at):
        """Sets the received_at of this GetInboundEmailEventsByUuid.

        Date when email was received on SMTP relay  # noqa: E501

        :param received_at: The received_at of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: datetime
        """

        self._received_at = received_at

    @property
    def delivered_at(self):
        """Gets the delivered_at of this GetInboundEmailEventsByUuid.  # noqa: E501

        Date when email was delivered successfully to client’s webhook  # noqa: E501

        :return: The delivered_at of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: datetime
        """
        return self._delivered_at

    @delivered_at.setter
    def delivered_at(self, delivered_at):
        """Sets the delivered_at of this GetInboundEmailEventsByUuid.

        Date when email was delivered successfully to client’s webhook  # noqa: E501

        :param delivered_at: The delivered_at of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: datetime
        """

        self._delivered_at = delivered_at

    @property
    def recipient(self):
        """Gets the recipient of this GetInboundEmailEventsByUuid.  # noqa: E501

        Recipient’s email address  # noqa: E501

        :return: The recipient of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this GetInboundEmailEventsByUuid.

        Recipient’s email address  # noqa: E501

        :param recipient: The recipient of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: str
        """

        self._recipient = recipient

    @property
    def sender(self):
        """Gets the sender of this GetInboundEmailEventsByUuid.  # noqa: E501

        Sender’s email address  # noqa: E501

        :return: The sender of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: str
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this GetInboundEmailEventsByUuid.

        Sender’s email address  # noqa: E501

        :param sender: The sender of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: str
        """

        self._sender = sender

    @property
    def message_id(self):
        """Gets the message_id of this GetInboundEmailEventsByUuid.  # noqa: E501

        Value of the Message-ID header. This will be present only after the processing is done.  # noqa: E501

        :return: The message_id of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this GetInboundEmailEventsByUuid.

        Value of the Message-ID header. This will be present only after the processing is done.  # noqa: E501

        :param message_id: The message_id of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def subject(self):
        """Gets the subject of this GetInboundEmailEventsByUuid.  # noqa: E501

        Value of the Subject header. This will be present only after the processing is done.   # noqa: E501

        :return: The subject of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this GetInboundEmailEventsByUuid.

        Value of the Subject header. This will be present only after the processing is done.   # noqa: E501

        :param subject: The subject of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def attachments(self):
        """Gets the attachments of this GetInboundEmailEventsByUuid.  # noqa: E501

        List of attachments of the email. This will be present only after the processing is done.  # noqa: E501

        :return: The attachments of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: list[GetInboundEmailEventsByUuidAttachments]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this GetInboundEmailEventsByUuid.

        List of attachments of the email. This will be present only after the processing is done.  # noqa: E501

        :param attachments: The attachments of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: list[GetInboundEmailEventsByUuidAttachments]
        """

        self._attachments = attachments

    @property
    def logs(self):
        """Gets the logs of this GetInboundEmailEventsByUuid.  # noqa: E501

        List of events/logs that describe the lifecycle of the email on SIB platform  # noqa: E501

        :return: The logs of this GetInboundEmailEventsByUuid.  # noqa: E501
        :rtype: list[GetInboundEmailEventsByUuidLogs]
        """
        return self._logs

    @logs.setter
    def logs(self, logs):
        """Sets the logs of this GetInboundEmailEventsByUuid.

        List of events/logs that describe the lifecycle of the email on SIB platform  # noqa: E501

        :param logs: The logs of this GetInboundEmailEventsByUuid.  # noqa: E501
        :type: list[GetInboundEmailEventsByUuidLogs]
        """

        self._logs = logs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetInboundEmailEventsByUuid, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetInboundEmailEventsByUuid):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
