# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetPaymentRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'reference': 'str',
        'status': 'str',
        'configuration': 'Configuration',
        'contact_id': 'int',
        'number_of_reminders_sent': 'int',
        'cart': 'Cart',
        'notification': 'Notification'
    }

    attribute_map = {
        'reference': 'reference',
        'status': 'status',
        'configuration': 'configuration',
        'contact_id': 'contactId',
        'number_of_reminders_sent': 'numberOfRemindersSent',
        'cart': 'cart',
        'notification': 'notification'
    }

    def __init__(self, reference=None, status=None, configuration=None, contact_id=None, number_of_reminders_sent=None, cart=None, notification=None):  # noqa: E501
        """GetPaymentRequest - a model defined in Swagger"""  # noqa: E501

        self._reference = None
        self._status = None
        self._configuration = None
        self._contact_id = None
        self._number_of_reminders_sent = None
        self._cart = None
        self._notification = None
        self.discriminator = None

        self.reference = reference
        self.status = status
        if configuration is not None:
            self.configuration = configuration
        if contact_id is not None:
            self.contact_id = contact_id
        if number_of_reminders_sent is not None:
            self.number_of_reminders_sent = number_of_reminders_sent
        self.cart = cart
        self.notification = notification

    @property
    def reference(self):
        """Gets the reference of this GetPaymentRequest.  # noqa: E501

        Reference of the payment request, it will appear on the payment page.   # noqa: E501

        :return: The reference of this GetPaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this GetPaymentRequest.

        Reference of the payment request, it will appear on the payment page.   # noqa: E501

        :param reference: The reference of this GetPaymentRequest.  # noqa: E501
        :type: str
        """
        if reference is None:
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501

        self._reference = reference

    @property
    def status(self):
        """Gets the status of this GetPaymentRequest.  # noqa: E501

        Status of the payment request.  # noqa: E501

        :return: The status of this GetPaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this GetPaymentRequest.

        Status of the payment request.  # noqa: E501

        :param status: The status of this GetPaymentRequest.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["created", "sent", "reminderSent - paid"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def configuration(self):
        """Gets the configuration of this GetPaymentRequest.  # noqa: E501


        :return: The configuration of this GetPaymentRequest.  # noqa: E501
        :rtype: Configuration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this GetPaymentRequest.


        :param configuration: The configuration of this GetPaymentRequest.  # noqa: E501
        :type: Configuration
        """

        self._configuration = configuration

    @property
    def contact_id(self):
        """Gets the contact_id of this GetPaymentRequest.  # noqa: E501

        Brevo ID of the contact requested to pay.   # noqa: E501

        :return: The contact_id of this GetPaymentRequest.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this GetPaymentRequest.

        Brevo ID of the contact requested to pay.   # noqa: E501

        :param contact_id: The contact_id of this GetPaymentRequest.  # noqa: E501
        :type: int
        """

        self._contact_id = contact_id

    @property
    def number_of_reminders_sent(self):
        """Gets the number_of_reminders_sent of this GetPaymentRequest.  # noqa: E501

        number of reminders sent.   # noqa: E501

        :return: The number_of_reminders_sent of this GetPaymentRequest.  # noqa: E501
        :rtype: int
        """
        return self._number_of_reminders_sent

    @number_of_reminders_sent.setter
    def number_of_reminders_sent(self, number_of_reminders_sent):
        """Sets the number_of_reminders_sent of this GetPaymentRequest.

        number of reminders sent.   # noqa: E501

        :param number_of_reminders_sent: The number_of_reminders_sent of this GetPaymentRequest.  # noqa: E501
        :type: int
        """

        self._number_of_reminders_sent = number_of_reminders_sent

    @property
    def cart(self):
        """Gets the cart of this GetPaymentRequest.  # noqa: E501


        :return: The cart of this GetPaymentRequest.  # noqa: E501
        :rtype: Cart
        """
        return self._cart

    @cart.setter
    def cart(self, cart):
        """Sets the cart of this GetPaymentRequest.


        :param cart: The cart of this GetPaymentRequest.  # noqa: E501
        :type: Cart
        """
        if cart is None:
            raise ValueError("Invalid value for `cart`, must not be `None`")  # noqa: E501

        self._cart = cart

    @property
    def notification(self):
        """Gets the notification of this GetPaymentRequest.  # noqa: E501


        :return: The notification of this GetPaymentRequest.  # noqa: E501
        :rtype: Notification
        """
        return self._notification

    @notification.setter
    def notification(self, notification):
        """Sets the notification of this GetPaymentRequest.


        :param notification: The notification of this GetPaymentRequest.  # noqa: E501
        :type: Notification
        """
        if notification is None:
            raise ValueError("Invalid value for `notification`, must not be `None`")  # noqa: E501

        self._notification = notification

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetPaymentRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetPaymentRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
