# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetProductDetails(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'url': 'str',
        'image_url': 'str',
        'sku': 'str',
        'price': 'float',
        'categories': 'list[str]',
        'parent_id': 'str',
        's3_original': 'str',
        's3_thumb_analytics': 'str',
        'meta_info': 'object',
        's3_thumb_editor': 'str',
        'is_deleted': 'bool',
        'stock': 'float'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'created_at': 'createdAt',
        'modified_at': 'modifiedAt',
        'url': 'url',
        'image_url': 'imageUrl',
        'sku': 'sku',
        'price': 'price',
        'categories': 'categories',
        'parent_id': 'parentId',
        's3_original': 's3Original',
        's3_thumb_analytics': 's3ThumbAnalytics',
        'meta_info': 'metaInfo',
        's3_thumb_editor': 's3ThumbEditor',
        'is_deleted': 'isDeleted',
        'stock': 'stock'
    }

    def __init__(self, id=None, name=None, created_at=None, modified_at=None, url=None, image_url=None, sku=None, price=None, categories=None, parent_id=None, s3_original=None, s3_thumb_analytics=None, meta_info=None, s3_thumb_editor=None, is_deleted=None, stock=None):  # noqa: E501
        """GetProductDetails - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._created_at = None
        self._modified_at = None
        self._url = None
        self._image_url = None
        self._sku = None
        self._price = None
        self._categories = None
        self._parent_id = None
        self._s3_original = None
        self._s3_thumb_analytics = None
        self._meta_info = None
        self._s3_thumb_editor = None
        self._is_deleted = None
        self._stock = None
        self.discriminator = None

        self.id = id
        self.name = name
        self.created_at = created_at
        self.modified_at = modified_at
        if url is not None:
            self.url = url
        if image_url is not None:
            self.image_url = image_url
        if sku is not None:
            self.sku = sku
        if price is not None:
            self.price = price
        if categories is not None:
            self.categories = categories
        if parent_id is not None:
            self.parent_id = parent_id
        if s3_original is not None:
            self.s3_original = s3_original
        self.s3_thumb_analytics = s3_thumb_analytics
        if meta_info is not None:
            self.meta_info = meta_info
        self.s3_thumb_editor = s3_thumb_editor
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if stock is not None:
            self.stock = stock

    @property
    def id(self):
        """Gets the id of this GetProductDetails.  # noqa: E501

        Product ID for which you requested the details  # noqa: E501

        :return: The id of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GetProductDetails.

        Product ID for which you requested the details  # noqa: E501

        :param id: The id of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this GetProductDetails.  # noqa: E501

        Name of the product for which you requested the details  # noqa: E501

        :return: The name of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GetProductDetails.

        Name of the product for which you requested the details  # noqa: E501

        :param name: The name of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this GetProductDetails.  # noqa: E501

        Creation UTC date-time of the product (YYYY-MM-DDTHH:mm:ss.SSSZ)  # noqa: E501

        :return: The created_at of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this GetProductDetails.

        Creation UTC date-time of the product (YYYY-MM-DDTHH:mm:ss.SSSZ)  # noqa: E501

        :param created_at: The created_at of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this GetProductDetails.  # noqa: E501

        Last modification UTC date-time of the product (YYYY-MM-DDTHH:mm:ss.SSSZ)  # noqa: E501

        :return: The modified_at of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this GetProductDetails.

        Last modification UTC date-time of the product (YYYY-MM-DDTHH:mm:ss.SSSZ)  # noqa: E501

        :param modified_at: The modified_at of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if modified_at is None:
            raise ValueError("Invalid value for `modified_at`, must not be `None`")  # noqa: E501

        self._modified_at = modified_at

    @property
    def url(self):
        """Gets the url of this GetProductDetails.  # noqa: E501

        URL to the product  # noqa: E501

        :return: The url of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this GetProductDetails.

        URL to the product  # noqa: E501

        :param url: The url of this GetProductDetails.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def image_url(self):
        """Gets the image_url of this GetProductDetails.  # noqa: E501

        Absolute URL to the cover image of the product  # noqa: E501

        :return: The image_url of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """Sets the image_url of this GetProductDetails.

        Absolute URL to the cover image of the product  # noqa: E501

        :param image_url: The image_url of this GetProductDetails.  # noqa: E501
        :type: str
        """

        self._image_url = image_url

    @property
    def sku(self):
        """Gets the sku of this GetProductDetails.  # noqa: E501

        Product identifier from the shop  # noqa: E501

        :return: The sku of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """Sets the sku of this GetProductDetails.

        Product identifier from the shop  # noqa: E501

        :param sku: The sku of this GetProductDetails.  # noqa: E501
        :type: str
        """

        self._sku = sku

    @property
    def price(self):
        """Gets the price of this GetProductDetails.  # noqa: E501

        Price of the product  # noqa: E501

        :return: The price of this GetProductDetails.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this GetProductDetails.

        Price of the product  # noqa: E501

        :param price: The price of this GetProductDetails.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def categories(self):
        """Gets the categories of this GetProductDetails.  # noqa: E501

        Category ID-s of the product  # noqa: E501

        :return: The categories of this GetProductDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this GetProductDetails.

        Category ID-s of the product  # noqa: E501

        :param categories: The categories of this GetProductDetails.  # noqa: E501
        :type: list[str]
        """

        self._categories = categories

    @property
    def parent_id(self):
        """Gets the parent_id of this GetProductDetails.  # noqa: E501

        Parent product id of the product  # noqa: E501

        :return: The parent_id of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this GetProductDetails.

        Parent product id of the product  # noqa: E501

        :param parent_id: The parent_id of this GetProductDetails.  # noqa: E501
        :type: str
        """

        self._parent_id = parent_id

    @property
    def s3_original(self):
        """Gets the s3_original of this GetProductDetails.  # noqa: E501

        S3 url of original image  # noqa: E501

        :return: The s3_original of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._s3_original

    @s3_original.setter
    def s3_original(self, s3_original):
        """Sets the s3_original of this GetProductDetails.

        S3 url of original image  # noqa: E501

        :param s3_original: The s3_original of this GetProductDetails.  # noqa: E501
        :type: str
        """

        self._s3_original = s3_original

    @property
    def s3_thumb_analytics(self):
        """Gets the s3_thumb_analytics of this GetProductDetails.  # noqa: E501

        S3 thumbnail url of original image in 120x120 dimension for analytics section  # noqa: E501

        :return: The s3_thumb_analytics of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._s3_thumb_analytics

    @s3_thumb_analytics.setter
    def s3_thumb_analytics(self, s3_thumb_analytics):
        """Sets the s3_thumb_analytics of this GetProductDetails.

        S3 thumbnail url of original image in 120x120 dimension for analytics section  # noqa: E501

        :param s3_thumb_analytics: The s3_thumb_analytics of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if s3_thumb_analytics is None:
            raise ValueError("Invalid value for `s3_thumb_analytics`, must not be `None`")  # noqa: E501

        self._s3_thumb_analytics = s3_thumb_analytics

    @property
    def meta_info(self):
        """Gets the meta_info of this GetProductDetails.  # noqa: E501

        Meta data of product such as description, vendor, producer, stock level, etc.  # noqa: E501

        :return: The meta_info of this GetProductDetails.  # noqa: E501
        :rtype: object
        """
        return self._meta_info

    @meta_info.setter
    def meta_info(self, meta_info):
        """Sets the meta_info of this GetProductDetails.

        Meta data of product such as description, vendor, producer, stock level, etc.  # noqa: E501

        :param meta_info: The meta_info of this GetProductDetails.  # noqa: E501
        :type: object
        """

        self._meta_info = meta_info

    @property
    def s3_thumb_editor(self):
        """Gets the s3_thumb_editor of this GetProductDetails.  # noqa: E501

        S3 thumbnail url of original image in 600x400 dimension for editor section  # noqa: E501

        :return: The s3_thumb_editor of this GetProductDetails.  # noqa: E501
        :rtype: str
        """
        return self._s3_thumb_editor

    @s3_thumb_editor.setter
    def s3_thumb_editor(self, s3_thumb_editor):
        """Sets the s3_thumb_editor of this GetProductDetails.

        S3 thumbnail url of original image in 600x400 dimension for editor section  # noqa: E501

        :param s3_thumb_editor: The s3_thumb_editor of this GetProductDetails.  # noqa: E501
        :type: str
        """
        if s3_thumb_editor is None:
            raise ValueError("Invalid value for `s3_thumb_editor`, must not be `None`")  # noqa: E501

        self._s3_thumb_editor = s3_thumb_editor

    @property
    def is_deleted(self):
        """Gets the is_deleted of this GetProductDetails.  # noqa: E501

        product deleted from the shop's database  # noqa: E501

        :return: The is_deleted of this GetProductDetails.  # noqa: E501
        :rtype: bool
        """
        return self._is_deleted

    @is_deleted.setter
    def is_deleted(self, is_deleted):
        """Sets the is_deleted of this GetProductDetails.

        product deleted from the shop's database  # noqa: E501

        :param is_deleted: The is_deleted of this GetProductDetails.  # noqa: E501
        :type: bool
        """

        self._is_deleted = is_deleted

    @property
    def stock(self):
        """Gets the stock of this GetProductDetails.  # noqa: E501

        Current stock value of the product from the shop's database  # noqa: E501

        :return: The stock of this GetProductDetails.  # noqa: E501
        :rtype: float
        """
        return self._stock

    @stock.setter
    def stock(self, stock):
        """Sets the stock of this GetProductDetails.

        Current stock value of the product from the shop's database  # noqa: E501

        :param stock: The stock of this GetProductDetails.  # noqa: E501
        :type: float
        """

        self._stock = stock

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetProductDetails, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetProductDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
