# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class InviteuserPrivileges(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'feature': 'str',
        'permissions': 'list[str]'
    }

    attribute_map = {
        'feature': 'feature',
        'permissions': 'permissions'
    }

    def __init__(self, feature=None, permissions=None):  # noqa: E501
        """InviteuserPrivileges - a model defined in Swagger"""  # noqa: E501

        self._feature = None
        self._permissions = None
        self.discriminator = None

        if feature is not None:
            self.feature = feature
        if permissions is not None:
            self.permissions = permissions

    @property
    def feature(self):
        """Gets the feature of this InviteuserPrivileges.  # noqa: E501

        Feature name  # noqa: E501

        :return: The feature of this InviteuserPrivileges.  # noqa: E501
        :rtype: str
        """
        return self._feature

    @feature.setter
    def feature(self, feature):
        """Sets the feature of this InviteuserPrivileges.

        Feature name  # noqa: E501

        :param feature: The feature of this InviteuserPrivileges.  # noqa: E501
        :type: str
        """
        allowed_values = ["email_campaigns", "sms_campaigns", "contacts", "templates", "workflows", "landing_pages", "transactional_emails", "smtp_api", "user_management", "sales_platform", "phone", "conversations", "senders_domains_dedicated_ips", "push_notifications"]  # noqa: E501
        if feature not in allowed_values:
            raise ValueError(
                "Invalid value for `feature` ({0}), must be one of {1}"  # noqa: E501
                .format(feature, allowed_values)
            )

        self._feature = feature

    @property
    def permissions(self):
        """Gets the permissions of this InviteuserPrivileges.  # noqa: E501

        Permissions for a given feature  # noqa: E501

        :return: The permissions of this InviteuserPrivileges.  # noqa: E501
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this InviteuserPrivileges.

        Permissions for a given feature  # noqa: E501

        :param permissions: The permissions of this InviteuserPrivileges.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["create_edit_delete", "send_schedule_suspend", "view", "import", "export", "list_and_attributes", "forms", "activate_deactivate", "activate_deactivate_pause", "settings", "schedule_pause", "all", "logs", "access", "assign", "configure", "create_edit_deals", "delete_deals", "manage_others_deals_tasks", "manage_owned_companies", "manage_others_companies", "reports", "senders_management", "domains_management", "dedicated_ips_management", "send", "smtp", "api_keys", "authorized_ips", "none"]  # noqa: E501
        if not set(permissions).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `permissions` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(permissions) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._permissions = permissions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InviteuserPrivileges, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InviteuserPrivileges):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
