# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MainOrderPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'billing': 'object',
        'contact_id': 'int',
        'coupons': 'list[str]',
        'created_at': 'datetime',
        'email': 'str',
        'id': 'str',
        'identifiers': 'object',
        'products': 'list[MainProductPayload]',
        'status': 'str',
        'store_id': 'str',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'amount': 'amount',
        'billing': 'billing',
        'contact_id': 'contact_id',
        'coupons': 'coupons',
        'created_at': 'createdAt',
        'email': 'email',
        'id': 'id',
        'identifiers': 'identifiers',
        'products': 'products',
        'status': 'status',
        'store_id': 'storeId',
        'updated_at': 'updatedAt'
    }

    def __init__(self, amount=None, billing=None, contact_id=None, coupons=None, created_at=None, email=None, id=None, identifiers=None, products=None, status=None, store_id=None, updated_at=None):  # noqa: E501
        """MainOrderPayload - a model defined in Swagger"""  # noqa: E501

        self._amount = None
        self._billing = None
        self._contact_id = None
        self._coupons = None
        self._created_at = None
        self._email = None
        self._id = None
        self._identifiers = None
        self._products = None
        self._status = None
        self._store_id = None
        self._updated_at = None
        self.discriminator = None

        if amount is not None:
            self.amount = amount
        if billing is not None:
            self.billing = billing
        if contact_id is not None:
            self.contact_id = contact_id
        if coupons is not None:
            self.coupons = coupons
        if created_at is not None:
            self.created_at = created_at
        if email is not None:
            self.email = email
        if id is not None:
            self.id = id
        if identifiers is not None:
            self.identifiers = identifiers
        if products is not None:
            self.products = products
        if status is not None:
            self.status = status
        if store_id is not None:
            self.store_id = store_id
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def amount(self):
        """Gets the amount of this MainOrderPayload.  # noqa: E501

        Total amount of the order  # noqa: E501

        :return: The amount of this MainOrderPayload.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this MainOrderPayload.

        Total amount of the order  # noqa: E501

        :param amount: The amount of this MainOrderPayload.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def billing(self):
        """Gets the billing of this MainOrderPayload.  # noqa: E501

        Billing information for the order  # noqa: E501

        :return: The billing of this MainOrderPayload.  # noqa: E501
        :rtype: object
        """
        return self._billing

    @billing.setter
    def billing(self, billing):
        """Sets the billing of this MainOrderPayload.

        Billing information for the order  # noqa: E501

        :param billing: The billing of this MainOrderPayload.  # noqa: E501
        :type: object
        """

        self._billing = billing

    @property
    def contact_id(self):
        """Gets the contact_id of this MainOrderPayload.  # noqa: E501

        Unique identifier for the contact  # noqa: E501

        :return: The contact_id of this MainOrderPayload.  # noqa: E501
        :rtype: int
        """
        return self._contact_id

    @contact_id.setter
    def contact_id(self, contact_id):
        """Sets the contact_id of this MainOrderPayload.

        Unique identifier for the contact  # noqa: E501

        :param contact_id: The contact_id of this MainOrderPayload.  # noqa: E501
        :type: int
        """

        self._contact_id = contact_id

    @property
    def coupons(self):
        """Gets the coupons of this MainOrderPayload.  # noqa: E501

        List of coupon codes applied to the order  # noqa: E501

        :return: The coupons of this MainOrderPayload.  # noqa: E501
        :rtype: list[str]
        """
        return self._coupons

    @coupons.setter
    def coupons(self, coupons):
        """Sets the coupons of this MainOrderPayload.

        List of coupon codes applied to the order  # noqa: E501

        :param coupons: The coupons of this MainOrderPayload.  # noqa: E501
        :type: list[str]
        """

        self._coupons = coupons

    @property
    def created_at(self):
        """Gets the created_at of this MainOrderPayload.  # noqa: E501

        Timestamp when the order was created  # noqa: E501

        :return: The created_at of this MainOrderPayload.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this MainOrderPayload.

        Timestamp when the order was created  # noqa: E501

        :param created_at: The created_at of this MainOrderPayload.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def email(self):
        """Gets the email of this MainOrderPayload.  # noqa: E501

        Email address associated with the order  # noqa: E501

        :return: The email of this MainOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this MainOrderPayload.

        Email address associated with the order  # noqa: E501

        :param email: The email of this MainOrderPayload.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def id(self):
        """Gets the id of this MainOrderPayload.  # noqa: E501

        Unique identifier for the order  # noqa: E501

        :return: The id of this MainOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MainOrderPayload.

        Unique identifier for the order  # noqa: E501

        :param id: The id of this MainOrderPayload.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def identifiers(self):
        """Gets the identifiers of this MainOrderPayload.  # noqa: E501

        Additional identifiers for the order  # noqa: E501

        :return: The identifiers of this MainOrderPayload.  # noqa: E501
        :rtype: object
        """
        return self._identifiers

    @identifiers.setter
    def identifiers(self, identifiers):
        """Sets the identifiers of this MainOrderPayload.

        Additional identifiers for the order  # noqa: E501

        :param identifiers: The identifiers of this MainOrderPayload.  # noqa: E501
        :type: object
        """

        self._identifiers = identifiers

    @property
    def products(self):
        """Gets the products of this MainOrderPayload.  # noqa: E501

        List of products in the order  # noqa: E501

        :return: The products of this MainOrderPayload.  # noqa: E501
        :rtype: list[MainProductPayload]
        """
        return self._products

    @products.setter
    def products(self, products):
        """Sets the products of this MainOrderPayload.

        List of products in the order  # noqa: E501

        :param products: The products of this MainOrderPayload.  # noqa: E501
        :type: list[MainProductPayload]
        """

        self._products = products

    @property
    def status(self):
        """Gets the status of this MainOrderPayload.  # noqa: E501

        Current status of the order  # noqa: E501

        :return: The status of this MainOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MainOrderPayload.

        Current status of the order  # noqa: E501

        :param status: The status of this MainOrderPayload.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def store_id(self):
        """Gets the store_id of this MainOrderPayload.  # noqa: E501

        Identifier for the store where the order was placed  # noqa: E501

        :return: The store_id of this MainOrderPayload.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this MainOrderPayload.

        Identifier for the store where the order was placed  # noqa: E501

        :param store_id: The store_id of this MainOrderPayload.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def updated_at(self):
        """Gets the updated_at of this MainOrderPayload.  # noqa: E501

        Timestamp when the order was last updated  # noqa: E501

        :return: The updated_at of this MainOrderPayload.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this MainOrderPayload.

        Timestamp when the order was last updated  # noqa: E501

        :param updated_at: The updated_at of this MainOrderPayload.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MainOrderPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MainOrderPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
