# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MainReward(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attribution_per_consumer': 'int',
        'balance_definition_id': 'str',
        'code': 'str',
        'code_count': 'int',
        'code_generator_id': 'str',
        'code_pool_id': 'str',
        'config': 'str',
        'created_at': 'datetime',
        'disabled_at': 'datetime',
        'end_date': 'datetime',
        'expiration_date': 'datetime',
        'expiration_modifier': 'str',
        'expiration_unit': 'str',
        'expiration_value': 'int',
        'generator': 'object',
        'id': 'str',
        'limits': 'list[MainLimit]',
        'loyalty_program_id': 'str',
        'meta': 'dict(str, object)',
        'name': 'str',
        'products': 'list[MainProduct]',
        'public_description': 'str',
        'public_image': 'str',
        'public_name': 'str',
        'redeem_per_consumer': 'int',
        'redeem_rules': 'list[str]',
        'reward_configs': 'object',
        'rule': 'object',
        'start_date': 'datetime',
        'subtract_balance_definition_id': 'str',
        'subtract_balance_strategy': 'str',
        'subtract_balance_value': 'int',
        'subtract_total_balance': 'bool',
        'total_attribution': 'int',
        'total_redeem': 'int',
        'trigger_id': 'str',
        'unit': 'str',
        'updated_at': 'str',
        'value': 'float',
        'value_type': 'str'
    }

    attribute_map = {
        'attribution_per_consumer': 'attributionPerConsumer',
        'balance_definition_id': 'balanceDefinitionId',
        'code': 'code',
        'code_count': 'codeCount',
        'code_generator_id': 'codeGeneratorId',
        'code_pool_id': 'codePoolId',
        'config': 'config',
        'created_at': 'createdAt',
        'disabled_at': 'disabledAt',
        'end_date': 'endDate',
        'expiration_date': 'expirationDate',
        'expiration_modifier': 'expirationModifier',
        'expiration_unit': 'expirationUnit',
        'expiration_value': 'expirationValue',
        'generator': 'generator',
        'id': 'id',
        'limits': 'limits',
        'loyalty_program_id': 'loyaltyProgramId',
        'meta': 'meta',
        'name': 'name',
        'products': 'products',
        'public_description': 'publicDescription',
        'public_image': 'publicImage',
        'public_name': 'publicName',
        'redeem_per_consumer': 'redeemPerConsumer',
        'redeem_rules': 'redeemRules',
        'reward_configs': 'rewardConfigs',
        'rule': 'rule',
        'start_date': 'startDate',
        'subtract_balance_definition_id': 'subtractBalanceDefinitionId',
        'subtract_balance_strategy': 'subtractBalanceStrategy',
        'subtract_balance_value': 'subtractBalanceValue',
        'subtract_total_balance': 'subtractTotalBalance',
        'total_attribution': 'totalAttribution',
        'total_redeem': 'totalRedeem',
        'trigger_id': 'triggerId',
        'unit': 'unit',
        'updated_at': 'updatedAt',
        'value': 'value',
        'value_type': 'valueType'
    }

    def __init__(self, attribution_per_consumer=None, balance_definition_id=None, code=None, code_count=None, code_generator_id=None, code_pool_id=None, config=None, created_at=None, disabled_at=None, end_date=None, expiration_date=None, expiration_modifier='noModification', expiration_unit=None, expiration_value=None, generator=None, id=None, limits=None, loyalty_program_id=None, meta=None, name=None, products=None, public_description=None, public_image=None, public_name=None, redeem_per_consumer=None, redeem_rules=None, reward_configs=None, rule=None, start_date=None, subtract_balance_definition_id=None, subtract_balance_strategy=None, subtract_balance_value=None, subtract_total_balance=None, total_attribution=None, total_redeem=None, trigger_id=None, unit=None, updated_at=None, value=None, value_type=None):  # noqa: E501
        """MainReward - a model defined in Swagger"""  # noqa: E501

        self._attribution_per_consumer = None
        self._balance_definition_id = None
        self._code = None
        self._code_count = None
        self._code_generator_id = None
        self._code_pool_id = None
        self._config = None
        self._created_at = None
        self._disabled_at = None
        self._end_date = None
        self._expiration_date = None
        self._expiration_modifier = None
        self._expiration_unit = None
        self._expiration_value = None
        self._generator = None
        self._id = None
        self._limits = None
        self._loyalty_program_id = None
        self._meta = None
        self._name = None
        self._products = None
        self._public_description = None
        self._public_image = None
        self._public_name = None
        self._redeem_per_consumer = None
        self._redeem_rules = None
        self._reward_configs = None
        self._rule = None
        self._start_date = None
        self._subtract_balance_definition_id = None
        self._subtract_balance_strategy = None
        self._subtract_balance_value = None
        self._subtract_total_balance = None
        self._total_attribution = None
        self._total_redeem = None
        self._trigger_id = None
        self._unit = None
        self._updated_at = None
        self._value = None
        self._value_type = None
        self.discriminator = None

        if attribution_per_consumer is not None:
            self.attribution_per_consumer = attribution_per_consumer
        if balance_definition_id is not None:
            self.balance_definition_id = balance_definition_id
        if code is not None:
            self.code = code
        if code_count is not None:
            self.code_count = code_count
        if code_generator_id is not None:
            self.code_generator_id = code_generator_id
        if code_pool_id is not None:
            self.code_pool_id = code_pool_id
        if config is not None:
            self.config = config
        if created_at is not None:
            self.created_at = created_at
        if disabled_at is not None:
            self.disabled_at = disabled_at
        if end_date is not None:
            self.end_date = end_date
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if expiration_modifier is not None:
            self.expiration_modifier = expiration_modifier
        if expiration_unit is not None:
            self.expiration_unit = expiration_unit
        if expiration_value is not None:
            self.expiration_value = expiration_value
        if generator is not None:
            self.generator = generator
        if id is not None:
            self.id = id
        if limits is not None:
            self.limits = limits
        if loyalty_program_id is not None:
            self.loyalty_program_id = loyalty_program_id
        if meta is not None:
            self.meta = meta
        if name is not None:
            self.name = name
        if products is not None:
            self.products = products
        if public_description is not None:
            self.public_description = public_description
        if public_image is not None:
            self.public_image = public_image
        if public_name is not None:
            self.public_name = public_name
        if redeem_per_consumer is not None:
            self.redeem_per_consumer = redeem_per_consumer
        if redeem_rules is not None:
            self.redeem_rules = redeem_rules
        if reward_configs is not None:
            self.reward_configs = reward_configs
        if rule is not None:
            self.rule = rule
        if start_date is not None:
            self.start_date = start_date
        if subtract_balance_definition_id is not None:
            self.subtract_balance_definition_id = subtract_balance_definition_id
        if subtract_balance_strategy is not None:
            self.subtract_balance_strategy = subtract_balance_strategy
        if subtract_balance_value is not None:
            self.subtract_balance_value = subtract_balance_value
        if subtract_total_balance is not None:
            self.subtract_total_balance = subtract_total_balance
        if total_attribution is not None:
            self.total_attribution = total_attribution
        if total_redeem is not None:
            self.total_redeem = total_redeem
        if trigger_id is not None:
            self.trigger_id = trigger_id
        if unit is not None:
            self.unit = unit
        if updated_at is not None:
            self.updated_at = updated_at
        if value is not None:
            self.value = value
        if value_type is not None:
            self.value_type = value_type

    @property
    def attribution_per_consumer(self):
        """Gets the attribution_per_consumer of this MainReward.  # noqa: E501

        Maximum number of times a consumer can be attributed this reward  # noqa: E501

        :return: The attribution_per_consumer of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._attribution_per_consumer

    @attribution_per_consumer.setter
    def attribution_per_consumer(self, attribution_per_consumer):
        """Sets the attribution_per_consumer of this MainReward.

        Maximum number of times a consumer can be attributed this reward  # noqa: E501

        :param attribution_per_consumer: The attribution_per_consumer of this MainReward.  # noqa: E501
        :type: int
        """

        self._attribution_per_consumer = attribution_per_consumer

    @property
    def balance_definition_id(self):
        """Gets the balance_definition_id of this MainReward.  # noqa: E501

        Unique identifier for the balance definition  # noqa: E501

        :return: The balance_definition_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._balance_definition_id

    @balance_definition_id.setter
    def balance_definition_id(self, balance_definition_id):
        """Sets the balance_definition_id of this MainReward.

        Unique identifier for the balance definition  # noqa: E501

        :param balance_definition_id: The balance_definition_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._balance_definition_id = balance_definition_id

    @property
    def code(self):
        """Gets the code of this MainReward.  # noqa: E501

        Unique code for the reward  # noqa: E501

        :return: The code of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this MainReward.

        Unique code for the reward  # noqa: E501

        :param code: The code of this MainReward.  # noqa: E501
        :type: str
        """

        self._code = code

    @property
    def code_count(self):
        """Gets the code_count of this MainReward.  # noqa: E501

        Total number of codes generated  # noqa: E501

        :return: The code_count of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._code_count

    @code_count.setter
    def code_count(self, code_count):
        """Sets the code_count of this MainReward.

        Total number of codes generated  # noqa: E501

        :param code_count: The code_count of this MainReward.  # noqa: E501
        :type: int
        """

        self._code_count = code_count

    @property
    def code_generator_id(self):
        """Gets the code_generator_id of this MainReward.  # noqa: E501

        Unique identifier for the code generator  # noqa: E501

        :return: The code_generator_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._code_generator_id

    @code_generator_id.setter
    def code_generator_id(self, code_generator_id):
        """Sets the code_generator_id of this MainReward.

        Unique identifier for the code generator  # noqa: E501

        :param code_generator_id: The code_generator_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._code_generator_id = code_generator_id

    @property
    def code_pool_id(self):
        """Gets the code_pool_id of this MainReward.  # noqa: E501

        Unique identifier for the code pool  # noqa: E501

        :return: The code_pool_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._code_pool_id

    @code_pool_id.setter
    def code_pool_id(self, code_pool_id):
        """Sets the code_pool_id of this MainReward.

        Unique identifier for the code pool  # noqa: E501

        :param code_pool_id: The code_pool_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._code_pool_id = code_pool_id

    @property
    def config(self):
        """Gets the config of this MainReward.  # noqa: E501

        Configuration settings for the reward  # noqa: E501

        :return: The config of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this MainReward.

        Configuration settings for the reward  # noqa: E501

        :param config: The config of this MainReward.  # noqa: E501
        :type: str
        """

        self._config = config

    @property
    def created_at(self):
        """Gets the created_at of this MainReward.  # noqa: E501

        Timestamp when the reward was created  # noqa: E501

        :return: The created_at of this MainReward.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this MainReward.

        Timestamp when the reward was created  # noqa: E501

        :param created_at: The created_at of this MainReward.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def disabled_at(self):
        """Gets the disabled_at of this MainReward.  # noqa: E501

        Disabled date of the reward  # noqa: E501

        :return: The disabled_at of this MainReward.  # noqa: E501
        :rtype: datetime
        """
        return self._disabled_at

    @disabled_at.setter
    def disabled_at(self, disabled_at):
        """Sets the disabled_at of this MainReward.

        Disabled date of the reward  # noqa: E501

        :param disabled_at: The disabled_at of this MainReward.  # noqa: E501
        :type: datetime
        """

        self._disabled_at = disabled_at

    @property
    def end_date(self):
        """Gets the end_date of this MainReward.  # noqa: E501

        End date of the reward validity  # noqa: E501

        :return: The end_date of this MainReward.  # noqa: E501
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this MainReward.

        End date of the reward validity  # noqa: E501

        :param end_date: The end_date of this MainReward.  # noqa: E501
        :type: datetime
        """

        self._end_date = end_date

    @property
    def expiration_date(self):
        """Gets the expiration_date of this MainReward.  # noqa: E501

        Expiration date of the reward  # noqa: E501

        :return: The expiration_date of this MainReward.  # noqa: E501
        :rtype: datetime
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this MainReward.

        Expiration date of the reward  # noqa: E501

        :param expiration_date: The expiration_date of this MainReward.  # noqa: E501
        :type: datetime
        """

        self._expiration_date = expiration_date

    @property
    def expiration_modifier(self):
        """Gets the expiration_modifier of this MainReward.  # noqa: E501

        Select startOfPeriod to configure rewards expiry on start of day/week/month/year. Select endOfPeriod to configure reward expiry on end of day/week/month/year, else select noModification  # noqa: E501

        :return: The expiration_modifier of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._expiration_modifier

    @expiration_modifier.setter
    def expiration_modifier(self, expiration_modifier):
        """Sets the expiration_modifier of this MainReward.

        Select startOfPeriod to configure rewards expiry on start of day/week/month/year. Select endOfPeriod to configure reward expiry on end of day/week/month/year, else select noModification  # noqa: E501

        :param expiration_modifier: The expiration_modifier of this MainReward.  # noqa: E501
        :type: str
        """
        allowed_values = ["startOfPeriod", "endOfPeriod", "noModification"]  # noqa: E501
        if expiration_modifier not in allowed_values:
            raise ValueError(
                "Invalid value for `expiration_modifier` ({0}), must be one of {1}"  # noqa: E501
                .format(expiration_modifier, allowed_values)
            )

        self._expiration_modifier = expiration_modifier

    @property
    def expiration_unit(self):
        """Gets the expiration_unit of this MainReward.  # noqa: E501

        Unit of time for the rewards's availability (e.g., day/week/month/year).  # noqa: E501

        :return: The expiration_unit of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._expiration_unit

    @expiration_unit.setter
    def expiration_unit(self, expiration_unit):
        """Sets the expiration_unit of this MainReward.

        Unit of time for the rewards's availability (e.g., day/week/month/year).  # noqa: E501

        :param expiration_unit: The expiration_unit of this MainReward.  # noqa: E501
        :type: str
        """

        self._expiration_unit = expiration_unit

    @property
    def expiration_value(self):
        """Gets the expiration_value of this MainReward.  # noqa: E501

        Number of days/weeks/month/year for reward expiry  # noqa: E501

        :return: The expiration_value of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._expiration_value

    @expiration_value.setter
    def expiration_value(self, expiration_value):
        """Sets the expiration_value of this MainReward.

        Number of days/weeks/month/year for reward expiry  # noqa: E501

        :param expiration_value: The expiration_value of this MainReward.  # noqa: E501
        :type: int
        """

        self._expiration_value = expiration_value

    @property
    def generator(self):
        """Gets the generator of this MainReward.  # noqa: E501

        object  # noqa: E501

        :return: The generator of this MainReward.  # noqa: E501
        :rtype: object
        """
        return self._generator

    @generator.setter
    def generator(self, generator):
        """Sets the generator of this MainReward.

        object  # noqa: E501

        :param generator: The generator of this MainReward.  # noqa: E501
        :type: object
        """

        self._generator = generator

    @property
    def id(self):
        """Gets the id of this MainReward.  # noqa: E501

        Unique identifier for the reward  # noqa: E501

        :return: The id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MainReward.

        Unique identifier for the reward  # noqa: E501

        :param id: The id of this MainReward.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def limits(self):
        """Gets the limits of this MainReward.  # noqa: E501

        Attribution / Redeem Limits for the reward  # noqa: E501

        :return: The limits of this MainReward.  # noqa: E501
        :rtype: list[MainLimit]
        """
        return self._limits

    @limits.setter
    def limits(self, limits):
        """Sets the limits of this MainReward.

        Attribution / Redeem Limits for the reward  # noqa: E501

        :param limits: The limits of this MainReward.  # noqa: E501
        :type: list[MainLimit]
        """

        self._limits = limits

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this MainReward.  # noqa: E501

        Id of the loyalty program to which the current reward belongs to  # noqa: E501

        :return: The loyalty_program_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this MainReward.

        Id of the loyalty program to which the current reward belongs to  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._loyalty_program_id = loyalty_program_id

    @property
    def meta(self):
        """Gets the meta of this MainReward.  # noqa: E501

        Additional data for reward definition  # noqa: E501

        :return: The meta of this MainReward.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this MainReward.

        Additional data for reward definition  # noqa: E501

        :param meta: The meta of this MainReward.  # noqa: E501
        :type: dict(str, object)
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this MainReward.  # noqa: E501

        Name of the reward  # noqa: E501

        :return: The name of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MainReward.

        Name of the reward  # noqa: E501

        :param name: The name of this MainReward.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def products(self):
        """Gets the products of this MainReward.  # noqa: E501

        Selected products for reward definition  # noqa: E501

        :return: The products of this MainReward.  # noqa: E501
        :rtype: list[MainProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """Sets the products of this MainReward.

        Selected products for reward definition  # noqa: E501

        :param products: The products of this MainReward.  # noqa: E501
        :type: list[MainProduct]
        """

        self._products = products

    @property
    def public_description(self):
        """Gets the public_description of this MainReward.  # noqa: E501

        Public description for the reward  # noqa: E501

        :return: The public_description of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._public_description

    @public_description.setter
    def public_description(self, public_description):
        """Sets the public_description of this MainReward.

        Public description for the reward  # noqa: E501

        :param public_description: The public_description of this MainReward.  # noqa: E501
        :type: str
        """

        self._public_description = public_description

    @property
    def public_image(self):
        """Gets the public_image of this MainReward.  # noqa: E501

        Public Image for the reward  # noqa: E501

        :return: The public_image of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._public_image

    @public_image.setter
    def public_image(self, public_image):
        """Sets the public_image of this MainReward.

        Public Image for the reward  # noqa: E501

        :param public_image: The public_image of this MainReward.  # noqa: E501
        :type: str
        """

        self._public_image = public_image

    @property
    def public_name(self):
        """Gets the public_name of this MainReward.  # noqa: E501

        Public name for the reward  # noqa: E501

        :return: The public_name of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._public_name

    @public_name.setter
    def public_name(self, public_name):
        """Sets the public_name of this MainReward.

        Public name for the reward  # noqa: E501

        :param public_name: The public_name of this MainReward.  # noqa: E501
        :type: str
        """

        self._public_name = public_name

    @property
    def redeem_per_consumer(self):
        """Gets the redeem_per_consumer of this MainReward.  # noqa: E501

        Defines the redeem limit for the consumer  # noqa: E501

        :return: The redeem_per_consumer of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._redeem_per_consumer

    @redeem_per_consumer.setter
    def redeem_per_consumer(self, redeem_per_consumer):
        """Sets the redeem_per_consumer of this MainReward.

        Defines the redeem limit for the consumer  # noqa: E501

        :param redeem_per_consumer: The redeem_per_consumer of this MainReward.  # noqa: E501
        :type: int
        """

        self._redeem_per_consumer = redeem_per_consumer

    @property
    def redeem_rules(self):
        """Gets the redeem_rules of this MainReward.  # noqa: E501

        Rules defined to redeem a reward  # noqa: E501

        :return: The redeem_rules of this MainReward.  # noqa: E501
        :rtype: list[str]
        """
        return self._redeem_rules

    @redeem_rules.setter
    def redeem_rules(self, redeem_rules):
        """Sets the redeem_rules of this MainReward.

        Rules defined to redeem a reward  # noqa: E501

        :param redeem_rules: The redeem_rules of this MainReward.  # noqa: E501
        :type: list[str]
        """

        self._redeem_rules = redeem_rules

    @property
    def reward_configs(self):
        """Gets the reward_configs of this MainReward.  # noqa: E501

        object  # noqa: E501

        :return: The reward_configs of this MainReward.  # noqa: E501
        :rtype: object
        """
        return self._reward_configs

    @reward_configs.setter
    def reward_configs(self, reward_configs):
        """Sets the reward_configs of this MainReward.

        object  # noqa: E501

        :param reward_configs: The reward_configs of this MainReward.  # noqa: E501
        :type: object
        """

        self._reward_configs = reward_configs

    @property
    def rule(self):
        """Gets the rule of this MainReward.  # noqa: E501

        Rule to define the reward  # noqa: E501

        :return: The rule of this MainReward.  # noqa: E501
        :rtype: object
        """
        return self._rule

    @rule.setter
    def rule(self, rule):
        """Sets the rule of this MainReward.

        Rule to define the reward  # noqa: E501

        :param rule: The rule of this MainReward.  # noqa: E501
        :type: object
        """

        self._rule = rule

    @property
    def start_date(self):
        """Gets the start_date of this MainReward.  # noqa: E501

        Start date of attribution of the reward  # noqa: E501

        :return: The start_date of this MainReward.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this MainReward.

        Start date of attribution of the reward  # noqa: E501

        :param start_date: The start_date of this MainReward.  # noqa: E501
        :type: datetime
        """

        self._start_date = start_date

    @property
    def subtract_balance_definition_id(self):
        """Gets the subtract_balance_definition_id of this MainReward.  # noqa: E501

        Id of the selected balance while redeeming / attributing a reward  # noqa: E501

        :return: The subtract_balance_definition_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._subtract_balance_definition_id

    @subtract_balance_definition_id.setter
    def subtract_balance_definition_id(self, subtract_balance_definition_id):
        """Sets the subtract_balance_definition_id of this MainReward.

        Id of the selected balance while redeeming / attributing a reward  # noqa: E501

        :param subtract_balance_definition_id: The subtract_balance_definition_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._subtract_balance_definition_id = subtract_balance_definition_id

    @property
    def subtract_balance_strategy(self):
        """Gets the subtract_balance_strategy of this MainReward.  # noqa: E501

        Strategy of the Balance while redeeming / attributing a reward  # noqa: E501

        :return: The subtract_balance_strategy of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._subtract_balance_strategy

    @subtract_balance_strategy.setter
    def subtract_balance_strategy(self, subtract_balance_strategy):
        """Sets the subtract_balance_strategy of this MainReward.

        Strategy of the Balance while redeeming / attributing a reward  # noqa: E501

        :param subtract_balance_strategy: The subtract_balance_strategy of this MainReward.  # noqa: E501
        :type: str
        """

        self._subtract_balance_strategy = subtract_balance_strategy

    @property
    def subtract_balance_value(self):
        """Gets the subtract_balance_value of this MainReward.  # noqa: E501

        Amount of balance to be selected while redeeming / attributing a reward  # noqa: E501

        :return: The subtract_balance_value of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._subtract_balance_value

    @subtract_balance_value.setter
    def subtract_balance_value(self, subtract_balance_value):
        """Sets the subtract_balance_value of this MainReward.

        Amount of balance to be selected while redeeming / attributing a reward  # noqa: E501

        :param subtract_balance_value: The subtract_balance_value of this MainReward.  # noqa: E501
        :type: int
        """

        self._subtract_balance_value = subtract_balance_value

    @property
    def subtract_total_balance(self):
        """Gets the subtract_total_balance of this MainReward.  # noqa: E501

        Value to indicate to subtract full balance or not  # noqa: E501

        :return: The subtract_total_balance of this MainReward.  # noqa: E501
        :rtype: bool
        """
        return self._subtract_total_balance

    @subtract_total_balance.setter
    def subtract_total_balance(self, subtract_total_balance):
        """Sets the subtract_total_balance of this MainReward.

        Value to indicate to subtract full balance or not  # noqa: E501

        :param subtract_total_balance: The subtract_total_balance of this MainReward.  # noqa: E501
        :type: bool
        """

        self._subtract_total_balance = subtract_total_balance

    @property
    def total_attribution(self):
        """Gets the total_attribution of this MainReward.  # noqa: E501

        Defines the limit to which a consumer can attribute a reward  # noqa: E501

        :return: The total_attribution of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._total_attribution

    @total_attribution.setter
    def total_attribution(self, total_attribution):
        """Sets the total_attribution of this MainReward.

        Defines the limit to which a consumer can attribute a reward  # noqa: E501

        :param total_attribution: The total_attribution of this MainReward.  # noqa: E501
        :type: int
        """

        self._total_attribution = total_attribution

    @property
    def total_redeem(self):
        """Gets the total_redeem of this MainReward.  # noqa: E501

        Defines the limit to which a consumer can redeem a reward  # noqa: E501

        :return: The total_redeem of this MainReward.  # noqa: E501
        :rtype: int
        """
        return self._total_redeem

    @total_redeem.setter
    def total_redeem(self, total_redeem):
        """Sets the total_redeem of this MainReward.

        Defines the limit to which a consumer can redeem a reward  # noqa: E501

        :param total_redeem: The total_redeem of this MainReward.  # noqa: E501
        :type: int
        """

        self._total_redeem = total_redeem

    @property
    def trigger_id(self):
        """Gets the trigger_id of this MainReward.  # noqa: E501

        Id of the Rule to be updated for that reward  # noqa: E501

        :return: The trigger_id of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._trigger_id

    @trigger_id.setter
    def trigger_id(self, trigger_id):
        """Sets the trigger_id of this MainReward.

        Id of the Rule to be updated for that reward  # noqa: E501

        :param trigger_id: The trigger_id of this MainReward.  # noqa: E501
        :type: str
        """

        self._trigger_id = trigger_id

    @property
    def unit(self):
        """Gets the unit of this MainReward.  # noqa: E501

        Selected unit of the balance  # noqa: E501

        :return: The unit of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """Sets the unit of this MainReward.

        Selected unit of the balance  # noqa: E501

        :param unit: The unit of this MainReward.  # noqa: E501
        :type: str
        """

        self._unit = unit

    @property
    def updated_at(self):
        """Gets the updated_at of this MainReward.  # noqa: E501

        Timestamp for when this reward was last updated.  # noqa: E501

        :return: The updated_at of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this MainReward.

        Timestamp for when this reward was last updated.  # noqa: E501

        :param updated_at: The updated_at of this MainReward.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    @property
    def value(self):
        """Gets the value of this MainReward.  # noqa: E501

        Value of metric in selected config for reward definition  # noqa: E501

        :return: The value of this MainReward.  # noqa: E501
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this MainReward.

        Value of metric in selected config for reward definition  # noqa: E501

        :param value: The value of this MainReward.  # noqa: E501
        :type: float
        """

        self._value = value

    @property
    def value_type(self):
        """Gets the value_type of this MainReward.  # noqa: E501

        Type of config selected for reward definition  # noqa: E501

        :return: The value_type of this MainReward.  # noqa: E501
        :rtype: str
        """
        return self._value_type

    @value_type.setter
    def value_type(self, value_type):
        """Sets the value_type of this MainReward.

        Type of config selected for reward definition  # noqa: E501

        :param value_type: The value_type of this MainReward.  # noqa: E501
        :type: str
        """

        self._value_type = value_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MainReward, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MainReward):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
