# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MainRule(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'condition': 'object',
        'created_at': 'str',
        'description': 'str',
        'event': 'object',
        'is_internal': 'bool',
        'loyalty_program_id': 'str',
        'loyalty_version_id': 'int',
        'meta': 'object',
        'name': 'str',
        'results': 'list[MainRuleResultResponse]',
        'rule_id': 'str',
        'rule_type': 'str',
        'updated_at': 'str'
    }

    attribute_map = {
        'condition': 'condition',
        'created_at': 'createdAt',
        'description': 'description',
        'event': 'event',
        'is_internal': 'isInternal',
        'loyalty_program_id': 'loyaltyProgramId',
        'loyalty_version_id': 'loyaltyVersionId',
        'meta': 'meta',
        'name': 'name',
        'results': 'results',
        'rule_id': 'ruleId',
        'rule_type': 'ruleType',
        'updated_at': 'updatedAt'
    }

    def __init__(self, condition=None, created_at=None, description=None, event=None, is_internal=None, loyalty_program_id=None, loyalty_version_id=None, meta=None, name=None, results=None, rule_id=None, rule_type=None, updated_at=None):  # noqa: E501
        """MainRule - a model defined in Swagger"""  # noqa: E501

        self._condition = None
        self._created_at = None
        self._description = None
        self._event = None
        self._is_internal = None
        self._loyalty_program_id = None
        self._loyalty_version_id = None
        self._meta = None
        self._name = None
        self._results = None
        self._rule_id = None
        self._rule_type = None
        self._updated_at = None
        self.discriminator = None

        if condition is not None:
            self.condition = condition
        if created_at is not None:
            self.created_at = created_at
        if description is not None:
            self.description = description
        if event is not None:
            self.event = event
        if is_internal is not None:
            self.is_internal = is_internal
        if loyalty_program_id is not None:
            self.loyalty_program_id = loyalty_program_id
        if loyalty_version_id is not None:
            self.loyalty_version_id = loyalty_version_id
        if meta is not None:
            self.meta = meta
        if name is not None:
            self.name = name
        if results is not None:
            self.results = results
        if rule_id is not None:
            self.rule_id = rule_id
        if rule_type is not None:
            self.rule_type = rule_type
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def condition(self):
        """Gets the condition of this MainRule.  # noqa: E501

        Selected rule condition  # noqa: E501

        :return: The condition of this MainRule.  # noqa: E501
        :rtype: object
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this MainRule.

        Selected rule condition  # noqa: E501

        :param condition: The condition of this MainRule.  # noqa: E501
        :type: object
        """

        self._condition = condition

    @property
    def created_at(self):
        """Gets the created_at of this MainRule.  # noqa: E501

        Timestamp when the rule was created  # noqa: E501

        :return: The created_at of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this MainRule.

        Timestamp when the rule was created  # noqa: E501

        :param created_at: The created_at of this MainRule.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this MainRule.  # noqa: E501

        Description of the rule  # noqa: E501

        :return: The description of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this MainRule.

        Description of the rule  # noqa: E501

        :param description: The description of this MainRule.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def event(self):
        """Gets the event of this MainRule.  # noqa: E501

        Selected event in the rule  # noqa: E501

        :return: The event of this MainRule.  # noqa: E501
        :rtype: object
        """
        return self._event

    @event.setter
    def event(self, event):
        """Sets the event of this MainRule.

        Selected event in the rule  # noqa: E501

        :param event: The event of this MainRule.  # noqa: E501
        :type: object
        """

        self._event = event

    @property
    def is_internal(self):
        """Gets the is_internal of this MainRule.  # noqa: E501

        Metric to identify if its an internal rule or not  # noqa: E501

        :return: The is_internal of this MainRule.  # noqa: E501
        :rtype: bool
        """
        return self._is_internal

    @is_internal.setter
    def is_internal(self, is_internal):
        """Sets the is_internal of this MainRule.

        Metric to identify if its an internal rule or not  # noqa: E501

        :param is_internal: The is_internal of this MainRule.  # noqa: E501
        :type: bool
        """

        self._is_internal = is_internal

    @property
    def loyalty_program_id(self):
        """Gets the loyalty_program_id of this MainRule.  # noqa: E501

        Loyalty Program id of which current rule is associated  # noqa: E501

        :return: The loyalty_program_id of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._loyalty_program_id

    @loyalty_program_id.setter
    def loyalty_program_id(self, loyalty_program_id):
        """Sets the loyalty_program_id of this MainRule.

        Loyalty Program id of which current rule is associated  # noqa: E501

        :param loyalty_program_id: The loyalty_program_id of this MainRule.  # noqa: E501
        :type: str
        """

        self._loyalty_program_id = loyalty_program_id

    @property
    def loyalty_version_id(self):
        """Gets the loyalty_version_id of this MainRule.  # noqa: E501

        Loyalty Version id to which current rule is associated  # noqa: E501

        :return: The loyalty_version_id of this MainRule.  # noqa: E501
        :rtype: int
        """
        return self._loyalty_version_id

    @loyalty_version_id.setter
    def loyalty_version_id(self, loyalty_version_id):
        """Sets the loyalty_version_id of this MainRule.

        Loyalty Version id to which current rule is associated  # noqa: E501

        :param loyalty_version_id: The loyalty_version_id of this MainRule.  # noqa: E501
        :type: int
        """

        self._loyalty_version_id = loyalty_version_id

    @property
    def meta(self):
        """Gets the meta of this MainRule.  # noqa: E501

        Additional data to define the rule  # noqa: E501

        :return: The meta of this MainRule.  # noqa: E501
        :rtype: object
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this MainRule.

        Additional data to define the rule  # noqa: E501

        :param meta: The meta of this MainRule.  # noqa: E501
        :type: object
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this MainRule.  # noqa: E501

        Rule name  # noqa: E501

        :return: The name of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MainRule.

        Rule name  # noqa: E501

        :param name: The name of this MainRule.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def results(self):
        """Gets the results of this MainRule.  # noqa: E501

        Results fo the rule definition  # noqa: E501

        :return: The results of this MainRule.  # noqa: E501
        :rtype: list[MainRuleResultResponse]
        """
        return self._results

    @results.setter
    def results(self, results):
        """Sets the results of this MainRule.

        Results fo the rule definition  # noqa: E501

        :param results: The results of this MainRule.  # noqa: E501
        :type: list[MainRuleResultResponse]
        """

        self._results = results

    @property
    def rule_id(self):
        """Gets the rule_id of this MainRule.  # noqa: E501

        Unique identifier for the rule  # noqa: E501

        :return: The rule_id of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._rule_id

    @rule_id.setter
    def rule_id(self, rule_id):
        """Sets the rule_id of this MainRule.

        Unique identifier for the rule  # noqa: E501

        :param rule_id: The rule_id of this MainRule.  # noqa: E501
        :type: str
        """

        self._rule_id = rule_id

    @property
    def rule_type(self):
        """Gets the rule_type of this MainRule.  # noqa: E501

        Type of the rule  # noqa: E501

        :return: The rule_type of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._rule_type

    @rule_type.setter
    def rule_type(self, rule_type):
        """Sets the rule_type of this MainRule.

        Type of the rule  # noqa: E501

        :param rule_type: The rule_type of this MainRule.  # noqa: E501
        :type: str
        """

        self._rule_type = rule_type

    @property
    def updated_at(self):
        """Gets the updated_at of this MainRule.  # noqa: E501

        Timestamp when the rule was updated  # noqa: E501

        :return: The updated_at of this MainRule.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this MainRule.

        Timestamp when the rule was updated  # noqa: E501

        :param updated_at: The updated_at of this MainRule.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MainRule, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MainRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
