# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Order(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_at': 'str',
        'updated_at': 'str',
        'status': 'str',
        'amount': 'float',
        'store_id': 'str',
        'identifiers': 'OrderIdentifiers',
        'products': 'list[OrderProducts]',
        'billing': 'OrderBilling',
        'coupons': 'list[str]',
        'meta_info': 'dict(str, object)'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'status': 'status',
        'amount': 'amount',
        'store_id': 'storeId',
        'identifiers': 'identifiers',
        'products': 'products',
        'billing': 'billing',
        'coupons': 'coupons',
        'meta_info': 'metaInfo'
    }

    def __init__(self, id=None, created_at=None, updated_at=None, status=None, amount=None, store_id=None, identifiers=None, products=None, billing=None, coupons=None, meta_info=None):  # noqa: E501
        """Order - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._created_at = None
        self._updated_at = None
        self._status = None
        self._amount = None
        self._store_id = None
        self._identifiers = None
        self._products = None
        self._billing = None
        self._coupons = None
        self._meta_info = None
        self.discriminator = None

        self.id = id
        self.created_at = created_at
        self.updated_at = updated_at
        self.status = status
        self.amount = amount
        if store_id is not None:
            self.store_id = store_id
        if identifiers is not None:
            self.identifiers = identifiers
        self.products = products
        if billing is not None:
            self.billing = billing
        if coupons is not None:
            self.coupons = coupons
        if meta_info is not None:
            self.meta_info = meta_info

    @property
    def id(self):
        """Gets the id of this Order.  # noqa: E501

        Unique ID of the order.  # noqa: E501

        :return: The id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Order.

        Unique ID of the order.  # noqa: E501

        :param id: The id of this Order.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this Order.  # noqa: E501

        Event occurrence UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when order is actually created.  # noqa: E501

        :return: The created_at of this Order.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Order.

        Event occurrence UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when order is actually created.  # noqa: E501

        :param created_at: The created_at of this Order.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Order.  # noqa: E501

        Event updated UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when the status of the order is actually changed/updated.  # noqa: E501

        :return: The updated_at of this Order.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Order.

        Event updated UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when the status of the order is actually changed/updated.  # noqa: E501

        :param updated_at: The updated_at of this Order.  # noqa: E501
        :type: str
        """
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    @property
    def status(self):
        """Gets the status of this Order.  # noqa: E501

        State of the order.  # noqa: E501

        :return: The status of this Order.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Order.

        State of the order.  # noqa: E501

        :param status: The status of this Order.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def amount(self):
        """Gets the amount of this Order.  # noqa: E501

        Total amount of the order, including all shipping expenses, tax and the price of items.  # noqa: E501

        :return: The amount of this Order.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Order.

        Total amount of the order, including all shipping expenses, tax and the price of items.  # noqa: E501

        :param amount: The amount of this Order.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def store_id(self):
        """Gets the store_id of this Order.  # noqa: E501

        ID of store where the order is placed  # noqa: E501

        :return: The store_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this Order.

        ID of store where the order is placed  # noqa: E501

        :param store_id: The store_id of this Order.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def identifiers(self):
        """Gets the identifiers of this Order.  # noqa: E501


        :return: The identifiers of this Order.  # noqa: E501
        :rtype: OrderIdentifiers
        """
        return self._identifiers

    @identifiers.setter
    def identifiers(self, identifiers):
        """Sets the identifiers of this Order.


        :param identifiers: The identifiers of this Order.  # noqa: E501
        :type: OrderIdentifiers
        """

        self._identifiers = identifiers

    @property
    def products(self):
        """Gets the products of this Order.  # noqa: E501


        :return: The products of this Order.  # noqa: E501
        :rtype: list[OrderProducts]
        """
        return self._products

    @products.setter
    def products(self, products):
        """Sets the products of this Order.


        :param products: The products of this Order.  # noqa: E501
        :type: list[OrderProducts]
        """
        if products is None:
            raise ValueError("Invalid value for `products`, must not be `None`")  # noqa: E501

        self._products = products

    @property
    def billing(self):
        """Gets the billing of this Order.  # noqa: E501


        :return: The billing of this Order.  # noqa: E501
        :rtype: OrderBilling
        """
        return self._billing

    @billing.setter
    def billing(self, billing):
        """Sets the billing of this Order.


        :param billing: The billing of this Order.  # noqa: E501
        :type: OrderBilling
        """

        self._billing = billing

    @property
    def coupons(self):
        """Gets the coupons of this Order.  # noqa: E501

        Coupons applied to the order. Stored case insensitive.  # noqa: E501

        :return: The coupons of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._coupons

    @coupons.setter
    def coupons(self, coupons):
        """Sets the coupons of this Order.

        Coupons applied to the order. Stored case insensitive.  # noqa: E501

        :param coupons: The coupons of this Order.  # noqa: E501
        :type: list[str]
        """

        self._coupons = coupons

    @property
    def meta_info(self):
        """Gets the meta_info of this Order.  # noqa: E501

        Meta data of order to store additional detal such as custom message, customer type, source.  # noqa: E501

        :return: The meta_info of this Order.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._meta_info

    @meta_info.setter
    def meta_info(self, meta_info):
        """Sets the meta_info of this Order.

        Meta data of order to store additional detal such as custom message, customer type, source.  # noqa: E501

        :param meta_info: The meta_info of this Order.  # noqa: E501
        :type: dict(str, object)
        """

        self._meta_info = meta_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Order, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
