# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class OrderBatch(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'orders': 'list[Order]',
        'notify_url': 'str',
        'historical': 'bool'
    }

    attribute_map = {
        'orders': 'orders',
        'notify_url': 'notifyUrl',
        'historical': 'historical'
    }

    def __init__(self, orders=None, notify_url=None, historical=True):  # noqa: E501
        """OrderBatch - a model defined in Swagger"""  # noqa: E501

        self._orders = None
        self._notify_url = None
        self._historical = None
        self.discriminator = None

        self.orders = orders
        if notify_url is not None:
            self.notify_url = notify_url
        if historical is not None:
            self.historical = historical

    @property
    def orders(self):
        """Gets the orders of this OrderBatch.  # noqa: E501

        array of order objects  # noqa: E501

        :return: The orders of this OrderBatch.  # noqa: E501
        :rtype: list[Order]
        """
        return self._orders

    @orders.setter
    def orders(self, orders):
        """Sets the orders of this OrderBatch.

        array of order objects  # noqa: E501

        :param orders: The orders of this OrderBatch.  # noqa: E501
        :type: list[Order]
        """
        if orders is None:
            raise ValueError("Invalid value for `orders`, must not be `None`")  # noqa: E501

        self._orders = orders

    @property
    def notify_url(self):
        """Gets the notify_url of this OrderBatch.  # noqa: E501

        Notify Url provided by client to get the status of batch request  # noqa: E501

        :return: The notify_url of this OrderBatch.  # noqa: E501
        :rtype: str
        """
        return self._notify_url

    @notify_url.setter
    def notify_url(self, notify_url):
        """Sets the notify_url of this OrderBatch.

        Notify Url provided by client to get the status of batch request  # noqa: E501

        :param notify_url: The notify_url of this OrderBatch.  # noqa: E501
        :type: str
        """

        self._notify_url = notify_url

    @property
    def historical(self):
        """Gets the historical of this OrderBatch.  # noqa: E501

        Defines wether you want your orders to be considered as live data or as historical data (import of past data, synchronising data). True: orders will not trigger any automation workflows. False: orders will trigger workflows as usual.  # noqa: E501

        :return: The historical of this OrderBatch.  # noqa: E501
        :rtype: bool
        """
        return self._historical

    @historical.setter
    def historical(self, historical):
        """Sets the historical of this OrderBatch.

        Defines wether you want your orders to be considered as live data or as historical data (import of past data, synchronising data). True: orders will not trigger any automation workflows. False: orders will trigger workflows as usual.  # noqa: E501

        :param historical: The historical of this OrderBatch.  # noqa: E501
        :type: bool
        """

        self._historical = historical

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderBatch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderBatch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
