# coding: utf-8

"""
    Brevo API

    Brevo provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/brevo  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   | 422  | Error. Unprocessable Entity |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@brevo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RequestContactExport(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'export_attributes': 'list[str]',
        'custom_contact_filter': 'RequestContactExportCustomContactFilter',
        'notify_url': 'str',
        'disable_notification': 'bool',
        'export_mandatory_attributes': 'bool',
        'export_subscription_status': 'list[str]',
        'export_metadata': 'list[str]'
    }

    attribute_map = {
        'export_attributes': 'exportAttributes',
        'custom_contact_filter': 'customContactFilter',
        'notify_url': 'notifyUrl',
        'disable_notification': 'disableNotification',
        'export_mandatory_attributes': 'exportMandatoryAttributes',
        'export_subscription_status': 'exportSubscriptionStatus',
        'export_metadata': 'exportMetadata'
    }

    def __init__(self, export_attributes=None, custom_contact_filter=None, notify_url=None, disable_notification=False, export_mandatory_attributes=True, export_subscription_status=None, export_metadata=None):  # noqa: E501
        """RequestContactExport - a model defined in Swagger"""  # noqa: E501

        self._export_attributes = None
        self._custom_contact_filter = None
        self._notify_url = None
        self._disable_notification = None
        self._export_mandatory_attributes = None
        self._export_subscription_status = None
        self._export_metadata = None
        self.discriminator = None

        if export_attributes is not None:
            self.export_attributes = export_attributes
        self.custom_contact_filter = custom_contact_filter
        if notify_url is not None:
            self.notify_url = notify_url
        if disable_notification is not None:
            self.disable_notification = disable_notification
        if export_mandatory_attributes is not None:
            self.export_mandatory_attributes = export_mandatory_attributes
        if export_subscription_status is not None:
            self.export_subscription_status = export_subscription_status
        if export_metadata is not None:
            self.export_metadata = export_metadata

    @property
    def export_attributes(self):
        """Gets the export_attributes of this RequestContactExport.  # noqa: E501

        List of all the attributes that you want to export. These attributes must be present in your contact database. It is required if exportMandatoryAttributes is set false. For example, ['fname', 'lname', 'email'].  # noqa: E501

        :return: The export_attributes of this RequestContactExport.  # noqa: E501
        :rtype: list[str]
        """
        return self._export_attributes

    @export_attributes.setter
    def export_attributes(self, export_attributes):
        """Sets the export_attributes of this RequestContactExport.

        List of all the attributes that you want to export. These attributes must be present in your contact database. It is required if exportMandatoryAttributes is set false. For example, ['fname', 'lname', 'email'].  # noqa: E501

        :param export_attributes: The export_attributes of this RequestContactExport.  # noqa: E501
        :type: list[str]
        """

        self._export_attributes = export_attributes

    @property
    def custom_contact_filter(self):
        """Gets the custom_contact_filter of this RequestContactExport.  # noqa: E501


        :return: The custom_contact_filter of this RequestContactExport.  # noqa: E501
        :rtype: RequestContactExportCustomContactFilter
        """
        return self._custom_contact_filter

    @custom_contact_filter.setter
    def custom_contact_filter(self, custom_contact_filter):
        """Sets the custom_contact_filter of this RequestContactExport.


        :param custom_contact_filter: The custom_contact_filter of this RequestContactExport.  # noqa: E501
        :type: RequestContactExportCustomContactFilter
        """
        if custom_contact_filter is None:
            raise ValueError("Invalid value for `custom_contact_filter`, must not be `None`")  # noqa: E501

        self._custom_contact_filter = custom_contact_filter

    @property
    def notify_url(self):
        """Gets the notify_url of this RequestContactExport.  # noqa: E501

        Webhook that will be called once the export process is finished. For reference, https://help.brevo.com/hc/en-us/articles/360007666479  # noqa: E501

        :return: The notify_url of this RequestContactExport.  # noqa: E501
        :rtype: str
        """
        return self._notify_url

    @notify_url.setter
    def notify_url(self, notify_url):
        """Sets the notify_url of this RequestContactExport.

        Webhook that will be called once the export process is finished. For reference, https://help.brevo.com/hc/en-us/articles/360007666479  # noqa: E501

        :param notify_url: The notify_url of this RequestContactExport.  # noqa: E501
        :type: str
        """

        self._notify_url = notify_url

    @property
    def disable_notification(self):
        """Gets the disable_notification of this RequestContactExport.  # noqa: E501

        To avoid generating the email notification upon contact export, pass **true**  # noqa: E501

        :return: The disable_notification of this RequestContactExport.  # noqa: E501
        :rtype: bool
        """
        return self._disable_notification

    @disable_notification.setter
    def disable_notification(self, disable_notification):
        """Sets the disable_notification of this RequestContactExport.

        To avoid generating the email notification upon contact export, pass **true**  # noqa: E501

        :param disable_notification: The disable_notification of this RequestContactExport.  # noqa: E501
        :type: bool
        """

        self._disable_notification = disable_notification

    @property
    def export_mandatory_attributes(self):
        """Gets the export_mandatory_attributes of this RequestContactExport.  # noqa: E501

        To export mandatory attributes like EMAIL, ADDED_TIME, MODIFIED_TIME  # noqa: E501

        :return: The export_mandatory_attributes of this RequestContactExport.  # noqa: E501
        :rtype: bool
        """
        return self._export_mandatory_attributes

    @export_mandatory_attributes.setter
    def export_mandatory_attributes(self, export_mandatory_attributes):
        """Sets the export_mandatory_attributes of this RequestContactExport.

        To export mandatory attributes like EMAIL, ADDED_TIME, MODIFIED_TIME  # noqa: E501

        :param export_mandatory_attributes: The export_mandatory_attributes of this RequestContactExport.  # noqa: E501
        :type: bool
        """

        self._export_mandatory_attributes = export_mandatory_attributes

    @property
    def export_subscription_status(self):
        """Gets the export_subscription_status of this RequestContactExport.  # noqa: E501

        Export subscription status of contacts for email & sms marketting. Pass email_marketing to obtain the marketing email subscription status & sms_marketing to retrieve the marketing SMS status of the contact.  # noqa: E501

        :return: The export_subscription_status of this RequestContactExport.  # noqa: E501
        :rtype: list[str]
        """
        return self._export_subscription_status

    @export_subscription_status.setter
    def export_subscription_status(self, export_subscription_status):
        """Sets the export_subscription_status of this RequestContactExport.

        Export subscription status of contacts for email & sms marketting. Pass email_marketing to obtain the marketing email subscription status & sms_marketing to retrieve the marketing SMS status of the contact.  # noqa: E501

        :param export_subscription_status: The export_subscription_status of this RequestContactExport.  # noqa: E501
        :type: list[str]
        """

        self._export_subscription_status = export_subscription_status

    @property
    def export_metadata(self):
        """Gets the export_metadata of this RequestContactExport.  # noqa: E501

        Export metadata of contacts such as _listIds, ADDED_TIME, MODIFIED_TIME.  # noqa: E501

        :return: The export_metadata of this RequestContactExport.  # noqa: E501
        :rtype: list[str]
        """
        return self._export_metadata

    @export_metadata.setter
    def export_metadata(self, export_metadata):
        """Sets the export_metadata of this RequestContactExport.

        Export metadata of contacts such as _listIds, ADDED_TIME, MODIFIED_TIME.  # noqa: E501

        :param export_metadata: The export_metadata of this RequestContactExport.  # noqa: E501
        :type: list[str]
        """

        self._export_metadata = export_metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RequestContactExport, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RequestContactExport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
